/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class ArrayUtils {
    public static boolean equals(int[] a, int[] b) {
        boolean eq = true;
        if (a == null && b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            eq = false;
            break;
        }
        return eq;
    }

    public static final Object resize(Object a, int newSize) {
        Class<?> cl = a.getClass();
        if (!cl.isArray()) {
            return null;
        }
        int size = Array.getLength(a);
        Class<?> componentType = a.getClass().getComponentType();
        Object newArray = Array.newInstance(componentType, newSize);
        System.arraycopy(a, 0, newArray, 0, Math.min(size, newSize));
        return newArray;
    }

    public static final double[] cut(double[] a, int off, int len) {
        int i;
        double[] res = new double[a.length - len];
        for (i = 0; i < off; ++i) {
            res[i] = a[i];
        }
        for (i = off; i < res.length; ++i) {
            res[i] = a[i + len];
        }
        return res;
    }

    public static final int[] toIntArray(Collection<Integer> list) {
        int[] res = new int[list.size()];
        int index = 0;
        for (Integer i : list) {
            res[index++] = i;
        }
        return res;
    }

    public static final <T> List<T> toList(T[] arr) {
        ArrayList<T> li = new ArrayList<T>(arr.length);
        for (T t : arr) {
            li.add(t);
        }
        return li;
    }

    public static final List<String> toList(String[] arr) {
        ArrayList<String> li = new ArrayList<String>(arr.length);
        for (String t : arr) {
            li.add(t);
        }
        return li;
    }

    public static final List<Integer> toList(int[] arr) {
        ArrayList<Integer> li = new ArrayList<Integer>(arr.length);
        for (int t : arr) {
            li.add(t);
        }
        return li;
    }

    public static final void toList(int[] arr, List<Integer> li) {
        for (int t : arr) {
            li.add(t);
        }
    }

    public static final String[] toStringArray(List<String> list) {
        String[] res = new String[list.size()];
        int index = 0;
        Iterator<String> iter = list.iterator();
        while (iter.hasNext()) {
            res[index++] = iter.next();
        }
        return res;
    }

    public static final int indexOf(Object[] array, Object obj) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(obj)) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOf(int[] array, int obj) {
        return ArrayUtils.indexOf(array, obj, 0);
    }

    public static final int indexOf(int[] array, int obj, int startIndex) {
        for (int i = startIndex; i < array.length; ++i) {
            if (array[i] != obj) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOf(byte[] array, byte obj) {
        return ArrayUtils.indexOf(array, obj, 0);
    }

    public static final int indexOf(byte[] array, byte obj, int startIndex) {
        for (int i = startIndex; i < array.length; ++i) {
            if (array[i] != obj) continue;
            return i;
        }
        return -1;
    }

    public static final int sum(int[] array) {
        int res = 0;
        for (int i = 0; i < array.length; ++i) {
            res += array[i];
        }
        return res;
    }

    public static final double sum(double[] array) {
        double res = 0.0;
        for (int i = 0; i < array.length; ++i) {
            res += array[i];
        }
        return res;
    }

    public static final double min(double[] array) {
        if (array.length == 0) {
            return 0.0;
        }
        double res = array[0];
        for (int i = 1; i < array.length; ++i) {
            res = Math.min(res, array[i]);
        }
        return res;
    }

    public static final double max(double[] array) {
        if (array.length == 0) {
            return 0.0;
        }
        double res = array[0];
        for (int i = 1; i < array.length; ++i) {
            res = Math.max(res, array[i]);
        }
        return res;
    }

    public static final int max(int[] array) {
        if (array.length == 0) {
            return 0;
        }
        int res = array[0];
        for (int i = 1; i < array.length; ++i) {
            res = Math.max(res, array[i]);
        }
        return res;
    }

    public static final float max(float[] array) {
        if (array.length == 0) {
            return 0.0f;
        }
        float res = array[0];
        for (int i = 1; i < array.length; ++i) {
            res = Math.max(res, array[i]);
        }
        return res;
    }

    public static final String toString(int[] v) {
        String res = "[";
        for (int i = 0; i < v.length; ++i) {
            res = res + (i > 0 ? ", " : "") + v[i];
        }
        return res + "]";
    }

    public static final String toString(byte[] v) {
        String res = "[";
        for (int i = 0; i < v.length; ++i) {
            res = res + (i > 0 ? ", " : "") + v[i];
        }
        return res + "]";
    }

    public static final String toString(double[] v) {
        String res = "[";
        for (int i = 0; i < v.length; ++i) {
            res = res + (i > 0 ? ", " : "") + v[i];
        }
        return res + "]";
    }

    public static final String toString(float[] v) {
        String res = "[";
        for (int i = 0; i < v.length; ++i) {
            res = res + (i > 0 ? ", " : "") + v[i];
        }
        return res + "]";
    }

    public static final String toString(double[] v, DecimalFormat df) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < v.length; ++i) {
            sb.append(df.format(v[i]));
            if (i >= v.length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static final String toString(Object[] v) {
        String res = "[";
        for (int i = 0; i < v.length; ++i) {
            res = res + (i > 0 ? ", " : "") + v[i];
        }
        return res + "]";
    }

    public static final void shift(int[] v, int n) {
        int[] copy = new int[v.length];
        for (int i = 0; i < v.length; ++i) {
            copy[i] = v[(i + n + v.length) % v.length];
        }
        System.arraycopy(copy, 0, v, 0, v.length);
    }

    public static void shuffle(int[] arr, Random random) {
        int cycles = 7;
        int size = arr.length;
        for (int i = 0; i < cycles; ++i) {
            for (int j = 0; j < size; ++j) {
                int dest = random.nextInt(size);
                if (dest == j) continue;
                int v = arr[j];
                arr[j] = arr[dest];
                arr[dest] = v;
            }
        }
    }

    public static void shuffle(int[] arr) {
        Random rnd = new Random();
        ArrayUtils.shuffle(arr, rnd);
    }

    public static <T> void shuffle(T[] arr) {
        Random rnd = new Random();
        int cycles = 7;
        int size = arr.length;
        for (int i = 0; i < cycles; ++i) {
            for (int j = 0; j < size; ++j) {
                int dest = rnd.nextInt(size);
                if (dest == j) continue;
                T v = arr[j];
                arr[j] = arr[dest];
                arr[dest] = v;
            }
        }
    }

    public static final Object copy(Object a) {
        Class<?> cl = a.getClass();
        if (!cl.isArray()) {
            return null;
        }
        int size = Array.getLength(a);
        Class<?> componentType = a.getClass().getComponentType();
        Object newArray = Array.newInstance(componentType, size);
        System.arraycopy(a, 0, newArray, 0, size);
        return newArray;
    }

    public static final boolean contains(List<int[]> list, int[] arr) {
        for (int[] arr2 : list) {
            if (arr.length != arr2.length) continue;
            for (int i = 0; i < arr2.length; ++i) {
                if (arr2[i] == arr[i]) continue;
            }
            return true;
        }
        return false;
    }

    public static void set(boolean[] a, boolean v) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = v;
        }
    }
}

