/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public class BinaryDecoder {
    private BufferedReader mReader;
    private int mAvailableBufferBits;
    private int mData;
    private int mDataBitCount;
    private int mBitsPerCharacter;
    private int mBaseCharacter;
    private int[] mMask;

    public static byte[] toBytes(String encodedBytes, int dataBitCount) {
        BinaryDecoder decoder = new BinaryDecoder(new BufferedReader(new StringReader(encodedBytes)));
        try {
            byte[] data = new byte[decoder.initialize(dataBitCount)];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)decoder.read();
            }
            return data;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static int[] toInts(String encodedBytes, int dataBitCount) {
        BinaryDecoder decoder = new BinaryDecoder(new BufferedReader(new StringReader(encodedBytes)));
        try {
            int[] data = new int[decoder.initialize(dataBitCount)];
            for (int i = 0; i < data.length; ++i) {
                data[i] = decoder.read();
            }
            return data;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public BinaryDecoder(BufferedReader reader) {
        this(reader, 6, 64);
    }

    public BinaryDecoder(BufferedReader reader, int bitsPerCharacter, int baseCharacter) {
        this.mReader = reader;
        this.mBitsPerCharacter = bitsPerCharacter;
        this.mBaseCharacter = baseCharacter;
        this.mAvailableBufferBits = 0;
        this.mMask = new int[bitsPerCharacter + 1];
        for (int i = 1; i <= bitsPerCharacter; ++i) {
            this.mMask[i] = this.mMask[i - 1] << 1 | 1;
        }
    }

    public int initialize(int dataBitCount) throws IOException {
        this.mDataBitCount = 32;
        int totalByteCount = this.read();
        this.mDataBitCount = dataBitCount;
        return totalByteCount;
    }

    public int read() throws IOException {
        int data = 0;
        int neededBits = this.mDataBitCount;
        while (neededBits != 0) {
            if (this.mAvailableBufferBits == 0) {
                while ((this.mData = this.mReader.read() - this.mBaseCharacter) < 0) {
                }
                this.mAvailableBufferBits = this.mBitsPerCharacter;
            }
            int bitsToRead = Math.min(this.mAvailableBufferBits, neededBits);
            int dataBits = this.mData & this.mMask[bitsToRead] << this.mAvailableBufferBits - bitsToRead;
            data |= this.mAvailableBufferBits > neededBits ? dataBits >> this.mAvailableBufferBits - neededBits : dataBits << neededBits - this.mAvailableBufferBits;
            neededBits -= bitsToRead;
            this.mAvailableBufferBits -= bitsToRead;
        }
        return data;
    }
}

