/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import com.actelion.research.util.BurtleHasherABC;
import java.util.Date;

public class BurtleHasher {
    private static BurtleHasherABC abcHashlittleInteger = new BurtleHasherABC(0L, 0L, 0L);
    private static final int HASHSTATE = 1;
    private static final long HASHLEN = 1L;
    private static final long MAXPAIR = 60L;
    private static final int MAXLEN = 70;

    public static int hashsize(long n) {
        int v = 1 << (int)n;
        return v;
    }

    public static int hashmask(int n) {
        int v = BurtleHasher.hashsize(n) - 1;
        return v;
    }

    public static long rot(long x, long k) {
        long v = x << (int)k ^ x >>> (int)(32L - k);
        return v;
    }

    private static void mix(BurtleHasherABC abc) {
        long a = abc.a;
        long b = abc.b;
        long c = abc.c;
        a -= c;
        a ^= BurtleHasher.rot(c, 4L);
        c += b;
        b -= a;
        b ^= BurtleHasher.rot(a, 6L);
        a += c;
        c -= b;
        c ^= BurtleHasher.rot(b, 8L);
        b += a;
        a -= c;
        a ^= BurtleHasher.rot(c, 16L);
        c += b;
        b -= a;
        b ^= BurtleHasher.rot(a, 19L);
        a += c;
        c -= b;
        c ^= BurtleHasher.rot(b, 4L);
        abc.a = a;
        abc.b = b += a;
        abc.c = c;
    }

    public static void mix64(BurtleHasherABC abc) {
        abc.a -= abc.b;
        abc.a -= abc.c;
        abc.a ^= abc.c >> 43;
        abc.b -= abc.c;
        abc.b -= abc.a;
        abc.b ^= abc.a << 9;
        abc.c -= abc.a;
        abc.c -= abc.b;
        abc.c ^= abc.b >> 8;
        abc.a -= abc.b;
        abc.a -= abc.c;
        abc.a ^= abc.c >> 38;
        abc.b -= abc.c;
        abc.b -= abc.a;
        abc.b ^= abc.a << 23;
        abc.c -= abc.a;
        abc.c -= abc.b;
        abc.c ^= abc.b >> 5;
        abc.a -= abc.b;
        abc.a -= abc.c;
        abc.a ^= abc.c >> 35;
        abc.b -= abc.c;
        abc.b -= abc.a;
        abc.b ^= abc.a << 49;
        abc.c -= abc.a;
        abc.c -= abc.b;
        abc.c ^= abc.b >> 11;
        abc.a -= abc.b;
        abc.a -= abc.c;
        abc.a ^= abc.c >> 12;
        abc.b -= abc.c;
        abc.b -= abc.a;
        abc.b ^= abc.a << 18;
        abc.c -= abc.a;
        abc.c -= abc.b;
        abc.c ^= abc.b >> 22;
    }

    private static void finalMix(BurtleHasherABC abc) {
        long a = abc.a;
        long b = abc.b;
        long c = abc.c;
        c ^= b;
        a ^= (c -= BurtleHasher.rot(b, 14L));
        b ^= (a -= BurtleHasher.rot(c, 11L));
        c ^= (b -= BurtleHasher.rot(a, 25L));
        a ^= (c -= BurtleHasher.rot(b, 16L));
        b ^= (a -= BurtleHasher.rot(c, 4L));
        c ^= (b -= BurtleHasher.rot(a, 14L));
        abc.a = a;
        abc.b = b;
        abc.c = c -= BurtleHasher.rot(b, 24L);
    }

    public static int hashword(String w, long initval) {
        long c;
        int length = w.length();
        byte[] k = w.getBytes();
        long b = c = -559038737L + ((long)length << 2) + initval;
        long a = c;
        BurtleHasherABC abc = new BurtleHasherABC(a, b, c);
        int cc = 0;
        while (length > 3) {
            abc.a += (long)k[cc + 0];
            abc.b += (long)k[cc + 1];
            abc.c += (long)k[cc + 2];
            BurtleHasher.mix(abc);
            length -= 3;
            cc += 3;
        }
        switch (length) {
            case 3: {
                abc.c += (long)k[2];
            }
            case 2: {
                abc.b += (long)k[1];
            }
            case 1: {
                abc.a += (long)k[0];
                BurtleHasher.finalMix(abc);
            }
        }
        return (int)abc.c;
    }

    public static int hashlittle(String key, long initval) {
        long c;
        int length = key.length();
        long b = c = -559038737L + (long)length + initval;
        long a = c;
        byte[] k = key.getBytes();
        BurtleHasherABC abc = new BurtleHasherABC(a, b, c);
        int cc = 0;
        while (length > 12) {
            abc.a += (long)k[cc + 0];
            abc.a += (long)k[cc + 1] << 8;
            abc.a += (long)k[cc + 2] << 16;
            abc.a += (long)k[cc + 3] << 24;
            abc.b += (long)k[cc + 4];
            abc.b += (long)k[cc + 5] << 8;
            abc.b += (long)k[cc + 6] << 16;
            abc.b += (long)k[cc + 7] << 24;
            abc.c += (long)k[cc + 8];
            abc.c += (long)k[cc + 9] << 8;
            abc.c += (long)k[cc + 10] << 16;
            abc.c += (long)k[cc + 11] << 24;
            BurtleHasher.mix(abc);
            length -= 12;
            cc += 12;
        }
        switch (length) {
            case 12: {
                abc.c += (long)k[cc + 11] << 24;
            }
            case 11: {
                abc.c += (long)k[cc + 10] << 16;
            }
            case 10: {
                abc.c += (long)k[cc + 9] << 8;
            }
            case 9: {
                abc.c += (long)k[8];
            }
            case 8: {
                abc.b += (long)k[cc + 7] << 24;
            }
            case 7: {
                abc.b += (long)k[cc + 6] << 16;
            }
            case 6: {
                abc.b += (long)k[cc + 5] << 8;
            }
            case 5: {
                abc.b += (long)k[4];
            }
            case 4: {
                abc.a += (long)k[cc + 3] << 24;
            }
            case 3: {
                abc.a += (long)k[cc + 2] << 16;
            }
            case 2: {
                abc.a += (long)k[cc + 1] << 8;
            }
            case 1: {
                abc.a += (long)k[cc + 0];
                break;
            }
            case 0: {
                return (int)abc.c;
            }
        }
        BurtleHasher.finalMix(abc);
        return (int)abc.c;
    }

    public static int hashlittle(byte[] k, long initval) {
        return BurtleHasher.hashlittle(k, initval, k.length);
    }

    public static int hashlittle(byte[] k, long initval, int size) {
        long c;
        int length = size;
        long b = c = -559038737L + (long)length + initval;
        long a = c;
        BurtleHasherABC abc = new BurtleHasherABC(a, b, c);
        int cc = 0;
        while (length > 12) {
            abc.a += (long)k[cc + 0];
            abc.a += (long)k[cc + 1] << 8;
            abc.a += (long)k[cc + 2] << 16;
            abc.a += (long)k[cc + 3] << 24;
            abc.b += (long)k[cc + 4];
            abc.b += (long)k[cc + 5] << 8;
            abc.b += (long)k[cc + 6] << 16;
            abc.b += (long)k[cc + 7] << 24;
            abc.c += (long)k[cc + 8];
            abc.c += (long)k[cc + 9] << 8;
            abc.c += (long)k[cc + 10] << 16;
            abc.c += (long)k[cc + 11] << 24;
            BurtleHasher.mix(abc);
            length -= 12;
            cc += 12;
        }
        switch (length) {
            case 12: {
                abc.c += (long)k[cc + 11] << 24;
            }
            case 11: {
                abc.c += (long)k[cc + 10] << 16;
            }
            case 10: {
                abc.c += (long)k[cc + 9] << 8;
            }
            case 9: {
                abc.c += (long)k[8];
            }
            case 8: {
                abc.b += (long)k[cc + 7] << 24;
            }
            case 7: {
                abc.b += (long)k[cc + 6] << 16;
            }
            case 6: {
                abc.b += (long)k[cc + 5] << 8;
            }
            case 5: {
                abc.b += (long)k[4];
            }
            case 4: {
                abc.a += (long)k[cc + 3] << 24;
            }
            case 3: {
                abc.a += (long)k[cc + 2] << 16;
            }
            case 2: {
                abc.a += (long)k[cc + 1] << 8;
            }
            case 1: {
                abc.a += (long)k[cc + 0];
                break;
            }
            case 0: {
                return (int)abc.c;
            }
        }
        BurtleHasher.finalMix(abc);
        return (int)abc.c;
    }

    public static int hashlittle(int[] k, long initval) {
        return BurtleHasher.hashlittle(k, initval, k.length);
    }

    public static int hashlittle(int[] k, long initval, int size) {
        long a;
        long c;
        int length = size;
        long b = c = -559038737L + (long)length + initval;
        BurtleHasher.abcHashlittleInteger.a = a = c;
        BurtleHasher.abcHashlittleInteger.b = b;
        BurtleHasher.abcHashlittleInteger.c = c;
        int cc = 0;
        while (length > 12) {
            BurtleHasher.abcHashlittleInteger.a += (long)k[cc + 0];
            BurtleHasher.abcHashlittleInteger.a += (long)k[cc + 1] << 8;
            BurtleHasher.abcHashlittleInteger.a += (long)k[cc + 2] << 16;
            BurtleHasher.abcHashlittleInteger.a += (long)k[cc + 3] << 24;
            BurtleHasher.abcHashlittleInteger.b += (long)k[cc + 4];
            BurtleHasher.abcHashlittleInteger.b += (long)k[cc + 5] << 8;
            BurtleHasher.abcHashlittleInteger.b += (long)k[cc + 6] << 16;
            BurtleHasher.abcHashlittleInteger.b += (long)k[cc + 7] << 24;
            BurtleHasher.abcHashlittleInteger.c += (long)k[cc + 8];
            BurtleHasher.abcHashlittleInteger.c += (long)k[cc + 9] << 8;
            BurtleHasher.abcHashlittleInteger.c += (long)k[cc + 10] << 16;
            BurtleHasher.abcHashlittleInteger.c += (long)k[cc + 11] << 24;
            BurtleHasher.mix(abcHashlittleInteger);
            length -= 12;
            cc += 12;
        }
        switch (length) {
            case 12: {
                BurtleHasher.abcHashlittleInteger.c += (long)k[cc + 11] << 24;
            }
            case 11: {
                BurtleHasher.abcHashlittleInteger.c += (long)k[cc + 10] << 16;
            }
            case 10: {
                BurtleHasher.abcHashlittleInteger.c += (long)k[cc + 9] << 8;
            }
            case 9: {
                BurtleHasher.abcHashlittleInteger.c += (long)k[8];
            }
            case 8: {
                BurtleHasher.abcHashlittleInteger.b += (long)k[cc + 7] << 24;
            }
            case 7: {
                BurtleHasher.abcHashlittleInteger.b += (long)k[cc + 6] << 16;
            }
            case 6: {
                BurtleHasher.abcHashlittleInteger.b += (long)k[cc + 5] << 8;
            }
            case 5: {
                BurtleHasher.abcHashlittleInteger.b += (long)k[4];
            }
            case 4: {
                BurtleHasher.abcHashlittleInteger.a += (long)k[cc + 3] << 24;
            }
            case 3: {
                BurtleHasher.abcHashlittleInteger.a += (long)k[cc + 2] << 16;
            }
            case 2: {
                BurtleHasher.abcHashlittleInteger.a += (long)k[cc + 1] << 8;
            }
            case 1: {
                BurtleHasher.abcHashlittleInteger.a += (long)k[cc + 0];
                break;
            }
            case 0: {
                return (int)BurtleHasher.abcHashlittleInteger.c;
            }
        }
        BurtleHasher.finalMix(abcHashlittleInteger);
        return (int)BurtleHasher.abcHashlittleInteger.c;
    }

    public static void driver1() {
        int size = 256;
        Date daStart = new Date();
        String s = "";
        for (int i = 0; i < size; ++i) {
            s = s + 'x';
        }
        long h = 0L;
        for (int i = 0; i < 1; ++i) {
            h = BurtleHasher.hashlittle(s, h);
        }
        Date daEnd = new Date();
        long delta = daEnd.getTime() - daStart.getTime();
        System.out.println("time: " + delta);
    }

    private static void driver2() {
    }

    public static void driver3() {
        String q = "This is the time for all good men to come to the aid of their country...";
        String qq = "xThis is the time for all good men to come to the aid of their country...";
        String qqq = "xxThis is the time for all good men to come to the aid of their country...";
        String qqqq = "xxxThis is the time for all good men to come to the aid of their country...";
        System.out.println("Endianness.  These lines should all be the same (for values filled in):\n");
        System.out.println("\n");
        System.out.println(BurtleHasher.hashword(q, 13L));
        String p1 = "";
        String p2 = "";
        p1 = q.substring(0, q.length() - 1);
        p2 = q.substring(0, q.length() - 2);
        System.out.println(BurtleHasher.hashlittle(p1, 13L) + " " + BurtleHasher.hashlittle(p2, 13L));
        p1 = q.substring(0, q.length() - 3);
        p2 = q.substring(0, q.length() - 4);
        System.out.println(BurtleHasher.hashlittle(p1, 13L) + " " + BurtleHasher.hashlittle(p2, 13L));
        p1 = q.substring(0, q.length() - 5);
        p2 = q.substring(0, q.length() - 6);
        System.out.println(BurtleHasher.hashlittle(p1, 13L) + " " + BurtleHasher.hashlittle(p2, 13L));
        p1 = q.substring(0, q.length() - 7);
        p2 = q.substring(0, q.length() - 8);
        System.out.println(BurtleHasher.hashlittle(p1, 13L) + " " + BurtleHasher.hashlittle(p2, 13L));
        p1 = q.substring(0, q.length() - 9);
        p2 = q.substring(0, q.length() - 10);
        System.out.println(BurtleHasher.hashlittle(p1, 13L) + " " + BurtleHasher.hashlittle(p2, 13L));
        p1 = q.substring(0, q.length() - 11);
        p2 = q.substring(0, q.length() - 12);
        System.out.println(BurtleHasher.hashlittle(p1, 13L) + " " + BurtleHasher.hashlittle(p2, 13L));
        System.out.println("\n");
    }

    public static void main(String[] args) {
        String id1 = "DasIstderJanua";
        int hash = BurtleHasher.hashlittle(id1, 13L);
        System.out.println("hash1: " + hash);
        System.out.println("hash2: " + (hash &= BurtleHasher.hashmask(10)));
    }
}

