/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.awt.Color;

public class ColorHelper {
    private static final float[] PERCEIVED_BRIGHTNESS = new float[]{0.299f, 0.587f, 0.114f};
    private static final float MIN_CONTRAST_TO_BACKGROUND = 0.3f;

    public static Color intermediateColor(Color c1, Color c2, float ratio) {
        return new Color((int)((float)c1.getRed() + ratio * (float)(c2.getRed() - c1.getRed())), (int)((float)c1.getGreen() + ratio * (float)(c2.getGreen() - c1.getGreen())), (int)((float)c1.getBlue() + ratio * (float)(c2.getBlue() - c1.getBlue())));
    }

    public static int intermediateColor(int rgb1, int rgb2, float ratio) {
        int r1 = (rgb1 & 0xFF0000) >> 16;
        int g1 = (rgb1 & 0xFF00) >> 8;
        int b1 = rgb1 & 0xFF;
        int r2 = (rgb2 & 0xFF0000) >> 16;
        int g2 = (rgb2 & 0xFF00) >> 8;
        int b2 = rgb2 & 0xFF;
        return (r1 + Math.round(ratio * (float)(r2 - r1)) << 16) + (g1 + Math.round(ratio * (float)(g2 - g1)) << 8) + b1 + Math.round(ratio * (float)(b2 - b1));
    }

    public static Color brighter(Color c, float factor) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int alpha = c.getAlpha();
        int i = (int)(1.0 / (1.0 - (double)factor));
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i, alpha);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((float)r / factor), 255), Math.min((int)((float)g / factor), 255), Math.min((int)((float)b / factor), 255), alpha);
    }

    public static int brighter(int argb, float factor) {
        int alpha = argb & 0xFF000000;
        int r = (argb & 0xFF0000) >> 16;
        int g = (argb & 0xFF00) >> 8;
        int b = argb & 0xFF;
        int i = (int)(1.0 / (1.0 - (double)factor));
        if (r == 0 && g == 0 && b == 0) {
            return alpha | i << 16 | i << 8 | i;
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return alpha | Math.min((int)((float)r / factor), 255) << 16 | Math.min((int)((float)g / factor), 255) << 8 | Math.min((int)((float)b / factor), 255);
    }

    public static Color darker(Color c, float factor) {
        return new Color(Math.max((int)((float)c.getRed() * factor), 0), Math.max((int)((float)c.getGreen() * factor), 0), Math.max((int)((float)c.getBlue() * factor), 0), c.getAlpha());
    }

    public static int darker(int argb, float factor) {
        return argb & 0xFF000000 | Math.round(factor * (float)((argb & 0xFF0000) >> 16)) << 16 | Math.round(factor * (float)((argb & 0xFF00) >> 8)) << 8 | Math.round(factor * (float)(argb & 0xFF));
    }

    public static float perceivedBrightness(Color c) {
        return c == null ? 1.0f : (PERCEIVED_BRIGHTNESS[0] * (float)c.getRed() + PERCEIVED_BRIGHTNESS[1] * (float)c.getGreen() + PERCEIVED_BRIGHTNESS[2] * (float)c.getBlue()) / 255.0f;
    }

    public static float perceivedBrightness(float[] cc) {
        return PERCEIVED_BRIGHTNESS[0] * cc[0] + PERCEIVED_BRIGHTNESS[1] * cc[1] + PERCEIVED_BRIGHTNESS[2] * cc[2];
    }

    public static float perceivedBrightness(int argb) {
        return (PERCEIVED_BRIGHTNESS[0] * (float)((argb & 0xFF0000) >> 16) + PERCEIVED_BRIGHTNESS[1] * (float)((argb & 0xFF00) >> 8) + PERCEIVED_BRIGHTNESS[2] * (float)(argb & 0xFF)) / 255.0f;
    }

    public static Color createColor(Color c, float perceivedBrightness) {
        float[] cc = c.getRGBComponents(null);
        ColorHelper.createColor(cc, perceivedBrightness);
        return new Color(cc[0], cc[1], cc[2], cc[3]);
    }

    public static int createColor(int argb, float perceivedBrightness) {
        float[] cc = new float[4];
        float f = 0.003921569f;
        cc[0] = f * (float)((argb & 0xFF0000) >> 16);
        cc[1] = f * (float)((argb & 0xFF00) >> 8);
        cc[2] = f * (float)(argb & 0xFF);
        ColorHelper.createColor(cc, perceivedBrightness);
        return argb & 0xFF000000 | Math.round(cc[0] * 255.0f) << 16 | Math.round(cc[1] * 255.0f) << 8 | Math.round(cc[2] * 255.0f);
    }

    private static void createColor(float[] cc, float perceivedBrightness) {
        float pb = ColorHelper.perceivedBrightness(cc);
        if (pb == 0.0f) {
            cc[0] = 0.0f;
            cc[1] = 0.0f;
            cc[2] = 0.0f;
            return;
        }
        float f = perceivedBrightness / pb;
        float surplusBrightness = 0.0f;
        float sum = 0.0f;
        for (int i = 0; i < 3; ++i) {
            int n = i;
            cc[n] = cc[n] * f;
            if (cc[i] < 1.0f) {
                sum += PERCEIVED_BRIGHTNESS[i];
                continue;
            }
            surplusBrightness += (cc[i] - 1.0f) * PERCEIVED_BRIGHTNESS[i];
            cc[i] = 1.0f;
        }
        if (surplusBrightness != 0.0f) {
            int i;
            float remainingBrightness = 0.0f;
            for (i = 0; i < 3; ++i) {
                if (!(cc[i] < 1.0f)) continue;
                int n = i;
                cc[n] = cc[n] + surplusBrightness / sum;
                if (!(cc[i] > 1.0f)) continue;
                remainingBrightness += (cc[i] - 1.0f) * PERCEIVED_BRIGHTNESS[i];
                cc[i] = 1.0f;
            }
            if (remainingBrightness != 0.0f) {
                for (i = 0; i < 3; ++i) {
                    if (!(cc[i] < 1.0f)) continue;
                    int n = i;
                    cc[n] = cc[n] + remainingBrightness / PERCEIVED_BRIGHTNESS[i];
                    if (!(cc[i] > 1.0f)) continue;
                    cc[i] = 1.0f;
                }
            }
        }
    }

    public static Color getContrastColor(Color fg, Color bg) {
        float hueDifferenceFactor;
        float brightnessFactor;
        float saturationFactor;
        float neededContrast;
        float fgb;
        float bgb = ColorHelper.perceivedBrightness(bg);
        float contrast = Math.abs(bgb - (fgb = ColorHelper.perceivedBrightness(fg)));
        if (contrast > 0.3f) {
            return fg;
        }
        float[] hsbBG = Color.RGBtoHSB(bg.getRed(), bg.getGreen(), bg.getBlue(), null);
        float[] hsbFG = Color.RGBtoHSB(fg.getRed(), fg.getGreen(), fg.getBlue(), null);
        double hueDif = Math.abs(hsbFG[0] - hsbBG[0]);
        if (hueDif > 0.5) {
            hueDif = 1.0 - hueDif;
        }
        if (contrast > (neededContrast = 0.3f * Math.max(saturationFactor = 1.0f - Math.max(hsbFG[1], hsbBG[1]), Math.max(brightnessFactor = Math.abs(fgb + bgb - 1.0f), hueDifferenceFactor = (float)Math.cos(Math.PI * hueDif * 3.0))))) {
            return fg;
        }
        boolean darken = fgb > bgb ? fgb + neededContrast > 1.0f : fgb - neededContrast > 0.0f;
        return ColorHelper.createColor(fg, darken ? bgb - neededContrast : bgb + neededContrast);
    }

    public static int getContrastColor(int fgRGB, int bgRGB) {
        float hueDifferenceFactor;
        float brightnessFactor;
        float saturationFactor;
        float neededContrast;
        float fgb;
        float bgb = ColorHelper.perceivedBrightness(bgRGB);
        float contrast = Math.abs(bgb - (fgb = ColorHelper.perceivedBrightness(fgRGB)));
        if (contrast > 0.3f) {
            return fgRGB;
        }
        float[] hsbBG = Color.RGBtoHSB((bgRGB & 0xFF0000) >> 16, (bgRGB & 0xFF00) >> 8, bgRGB & 0xFF, null);
        float[] hsbFG = Color.RGBtoHSB((fgRGB & 0xFF0000) >> 16, (fgRGB & 0xFF00) >> 8, fgRGB & 0xFF, null);
        double hueDif = Math.abs(hsbFG[0] - hsbBG[0]);
        if (hueDif > 0.5) {
            hueDif = 1.0 - hueDif;
        }
        if (contrast > (neededContrast = 0.3f * Math.max(saturationFactor = 1.0f - Math.max(hsbFG[1], hsbBG[1]), Math.max(brightnessFactor = Math.abs(fgb + bgb - 1.0f), hueDifferenceFactor = (float)Math.cos(Math.PI * hueDif * 3.0))))) {
            return fgRGB;
        }
        boolean darken = fgb > bgb ? fgb + neededContrast > 1.0f : fgb - neededContrast > 0.0f;
        return ColorHelper.createColor(fgRGB, darken ? bgb - neededContrast : bgb + neededContrast);
    }
}

