/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;

public class CursorHelper {
    public static final int cChainCursor = 0;
    public static final int cDeleteCursor = 1;
    public static final int cHandCursor = 2;
    public static final int cHandPlusCursor = 3;
    public static final int cFistCursor = 4;
    public static final int cLassoCursor = 5;
    public static final int cLassoPlusCursor = 6;
    public static final int cSelectRectCursor = 7;
    public static final int cSelectRectPlusCursor = 8;
    public static final int cZoomCursor = 9;
    public static final int cInvisibleCursor = 10;
    public static final int cPointerCursor = 11;
    public static final int cTextCursor = 12;
    public static final int cPointedHandCursor = 13;
    private static final int cCursorCount = 14;
    private static final int[][] cCursorData = new int[][]{{-1432180054, -1434146134, -1441453406, -1471067516, -1589095916, -2060839854, 1420461386, 1454022954, 1454024874}, {-1431677611, -1431764987, -1432092655, -1433403327, -1438646015, -1459616762, -1543499750, -1879031702, 1431634346, 1073809066, 1073814186, 1073834666, 0x5555AAAA}, {-1431737686, -1453057622, -1542187926, -1542188954, -1459351471, -1459351487, -1774190527, 0x41400001, 0x40400006, -1879048186, -1543503866, -1543503846, -1459617766, -1438646166, -1433403286, -1433403286}, {-1431737686, -1453057622, -1542187926, -1542188954, -1459351471, -1459351487, -1774190527, 0x41400001, 0x40404006, -1879031802, -1543154682, -1543487462, -1459601382, -1438646166, -1433403286, -1433403286}, {-1431655766, -1431655766, -1431741782, -1437330070, -1459351462, -1459351482, -1774190527, -1858076671, -1874853882, -1879048186, -1543503866, -1543503846, -1459617766, -1438646166, -1433403286, -1433403286}, {-1431655766, -1432005270, -1454374890, -1543503871, -1879048191, 0x40000001, 1073741846, 1073743210, -1795073366, 1079421610, 0x446AAAAA, -1783977302, -1448432982, -1448432982, -1498764630}, {-1431655766, -1432005270, -1454374890, -1543438335, -1878982655, 1075138561, 1073807382, 1073808746, -1795073366, 1079421610, 0x446AAAAA, -1783977302, -1448432982, -1448432982, -1498764630}, {0x5555556A, 1073741866, 1073741930, 1073741866, 1073741930, 1073741866, 1073741930, 1073741866, 1073741930, 1073741866, 1073741930, 1073741866, 0x4444446A}, {0x5555556A, 1073741866, 1073741930, 1073741866, 1073741930, 1073741866, 1073758314, 1073758250, 1074091114, 1073758250, 1073758314, 1073741866, 0x4444446A}, {-1432003926, -1437248086, 1767548266, 0x55AAAA5A, 0x55AAAA56, 1433053846, 0x556A6AA5, -1431672155, -1432004955, 0x556A6AA5, 1433037462, 0x55AAAA56, 0x55AAAA5A, 1767548266, -1437248086, -1432003926}, null};
    private static final Point[] cCursorHotSpot = new Point[]{new Point(1, 7), new Point(7, 5), new Point(8, 7), new Point(8, 7), new Point(8, 7), new Point(2, 14), new Point(2, 14), new Point(0, 0), new Point(0, 0), new Point(8, 8), new Point(0, 0)};
    private static Cursor[] sCursor;

    public static Cursor getCursor(int cursor) {
        if (sCursor == null) {
            sCursor = new Cursor[14];
        }
        if (sCursor[cursor] == null) {
            CursorHelper.sCursor[cursor] = CursorHelper.createCursor(cursor);
        }
        return sCursor[cursor];
    }

    public static Cursor createCursor(int cursor) {
        if (cursor < cCursorData.length) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension size = tk.getBestCursorSize(16, 16);
            if (size != null && size.width > 15 && size.height > 15) {
                BufferedImage image = new BufferedImage(size.width, size.height, 2);
                if (cCursorData[cursor] != null) {
                    int k;
                    int row;
                    int j;
                    Graphics2D g2 = image.createGraphics();
                    g2.setColor(new Color(255, 255, 255, 255));
                    for (j = 0; j < cCursorData[cursor].length; ++j) {
                        row = cCursorData[cursor][j];
                        for (k = 15; k >= 0; --k) {
                            if ((row & 3) == 0) {
                                g2.fillRect(k, j, 1, 1);
                            }
                            row >>= 2;
                        }
                    }
                    g2.setColor(new Color(0, 0, 0, 255));
                    for (j = 0; j < cCursorData[cursor].length; ++j) {
                        row = cCursorData[cursor][j];
                        for (k = 15; k >= 0; --k) {
                            if ((row & 3) == 1) {
                                g2.fillRect(k, j, 1, 1);
                            }
                            row >>= 2;
                        }
                    }
                }
                return tk.createCustomCursor(image, cCursorHotSpot[cursor], "");
            }
        } else {
            switch (cursor) {
                case 11: {
                    return Cursor.getPredefinedCursor(0);
                }
                case 12: {
                    return Cursor.getPredefinedCursor(2);
                }
                case 13: {
                    return Cursor.getPredefinedCursor(12);
                }
            }
        }
        return null;
    }
}

