/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

public class DoubleFormat {
    private static String[] ZEROS = new String[]{"", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000"};

    public static String toString(double theDouble) {
        return DoubleFormat.toString(theDouble, 5, true);
    }

    public static String toString(double value, int significantDigits) {
        return DoubleFormat.toString(value, significantDigits, true);
    }

    public static String toString(double value, int significantDigits, boolean skipTrailingZeros) {
        if (Double.isNaN(value)) {
            return "NaN";
        }
        if (Double.isInfinite(value)) {
            return "Infinity";
        }
        if (value == 0.0) {
            return skipTrailingZeros || significantDigits == 1 ? "0" : "0." + DoubleFormat.zeros(significantDigits - 1);
        }
        double limit1 = 1.0;
        for (int i = 1; i < significantDigits; ++i) {
            limit1 *= 10.0;
        }
        double limit2 = limit1 * 10.0;
        int exponent = 0;
        while (Math.abs(value) + 0.5 < limit1) {
            value *= 10.0;
            --exponent;
        }
        while (Math.abs(value) + 0.5 >= limit2) {
            value /= 10.0;
            ++exponent;
        }
        return DoubleFormat.toString((long)(value + (value < 0.0 ? -0.5 : 0.5)), exponent, significantDigits, skipTrailingZeros);
    }

    public static String toShortString(long value, int exponent) {
        return DoubleFormat.toString(value, exponent, 16, true);
    }

    private static String toString(long value, int exponent, int significantDigits, boolean skipTrailingZeros) {
        int noOfCiphers = 1;
        if (value == 0L) {
            return skipTrailingZeros || significantDigits == 1 ? "0" : "0." + DoubleFormat.zeros(significantDigits - 1);
        }
        if (value != 0L) {
            while (value % 10L == 0L) {
                value /= 10L;
                ++exponent;
            }
            noOfCiphers = 0;
            for (long temp = value; temp != 0L; temp /= 10L) {
                ++noOfCiphers;
            }
        }
        assert (significantDigits >= noOfCiphers);
        StringBuilder label = new StringBuilder();
        if (value < 0L) {
            label.append('-');
        }
        int trailingZeros = Math.max(0, significantDigits - noOfCiphers);
        String cipherString = Long.toString(Math.abs(value));
        if (exponent == 0) {
            label.append(cipherString);
            if (!skipTrailingZeros && trailingZeros != 0) {
                label.append(".");
                label.append(DoubleFormat.zeros(trailingZeros));
            }
        } else if (exponent > 0) {
            boolean useScientificNotation;
            boolean bl = skipTrailingZeros ? exponent > 4 : (useScientificNotation = exponent - trailingZeros > 4);
            if (useScientificNotation) {
                if (noOfCiphers == 1) {
                    label.append(cipherString);
                    if (significantDigits > 1) {
                        label.append(".");
                        if (skipTrailingZeros) {
                            label.append("0");
                        } else {
                            label.append(DoubleFormat.zeros(trailingZeros));
                        }
                    }
                } else {
                    label.append(cipherString.substring(0, 1));
                    label.append(".");
                    label.append(cipherString.substring(1));
                    if (!skipTrailingZeros && trailingZeros != 0) {
                        label.append(DoubleFormat.zeros(trailingZeros));
                    }
                }
                label.append("e");
                label.append(Integer.toString(exponent + noOfCiphers - 1));
            } else {
                label.append(cipherString);
                label.append(DoubleFormat.zeros(exponent));
                if (!skipTrailingZeros && trailingZeros > exponent) {
                    label.append(".");
                    label.append(DoubleFormat.zeros(trailingZeros - exponent));
                }
            }
        } else if (-exponent < noOfCiphers) {
            label.append(cipherString.substring(0, noOfCiphers + exponent));
            label.append(".");
            label.append(cipherString.substring(noOfCiphers + exponent));
            if (!skipTrailingZeros && trailingZeros != 0) {
                label.append(DoubleFormat.zeros(trailingZeros));
            }
        } else if (-exponent == noOfCiphers) {
            label.append("0.");
            label.append(cipherString);
            if (!skipTrailingZeros && trailingZeros != 0) {
                label.append(DoubleFormat.zeros(trailingZeros));
            }
        } else if (exponent + noOfCiphers < -2) {
            if (noOfCiphers == 1) {
                label.append(cipherString);
                if (significantDigits > 1) {
                    label.append(".");
                    if (skipTrailingZeros) {
                        label.append("0");
                    } else {
                        label.append(DoubleFormat.zeros(trailingZeros));
                    }
                }
            } else {
                label.append(cipherString.charAt(0));
                label.append(".");
                label.append(cipherString.substring(1));
                if (!skipTrailingZeros && trailingZeros != 0) {
                    label.append(DoubleFormat.zeros(trailingZeros));
                }
            }
            label.append("e-");
            label.append(Integer.toString(1 - exponent - noOfCiphers));
        } else {
            label.append("0.");
            label.append(DoubleFormat.zeros(-exponent - noOfCiphers));
            label.append(cipherString);
            if (!skipTrailingZeros && trailingZeros != 0) {
                label.append(DoubleFormat.zeros(trailingZeros));
            }
        }
        return label.toString();
    }

    private static String zeros(int i) {
        if (i < ZEROS.length) {
            return ZEROS[i];
        }
        StringBuilder b = new StringBuilder();
        while (i >= ZEROS.length) {
            b.append(ZEROS[ZEROS.length - 1]);
            i -= ZEROS.length - 1;
        }
        b.append(ZEROS[i]);
        return b.toString();
    }
}

