/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.text.DecimalFormat;
import java.util.Random;
import java.util.Vector;

public class DoubleVec
implements Comparable<DoubleVec> {
    private static final DecimalFormat NF = new DecimalFormat("0.000");
    private static final Random RAND = new Random();
    public static final int COSINE = 1;
    public static final int EUCLIDEAN = 2;
    public static final int EUCLIDEAN_FAST = 3;
    public static final int TANIMOTO = 4;
    public static final int TANIMOTO_INV = 5;
    private double[] data;
    private double mDotProd;

    public DoubleVec(DoubleVec dVec) {
        this.init();
        this.data = new double[dVec.data.length];
        for (int ii = 0; ii < this.data.length; ++ii) {
            this.data[ii] = dVec.data[ii];
        }
    }

    public DoubleVec(DoubleVec dVec, boolean bDotProd) {
        this.init();
        this.data = new double[dVec.data.length];
        for (int ii = 0; ii < this.data.length; ++ii) {
            this.data[ii] = dVec.data[ii];
        }
        if (bDotProd) {
            this.mDotProd = DoubleVec.mult(this.data, this.data);
        }
    }

    public DoubleVec(int iSize) {
        this.init();
        this.data = new double[iSize];
    }

    public DoubleVec(double[] dVec) {
        this.init();
        this.data = new double[dVec.length];
        for (int ii = 0; ii < this.data.length; ++ii) {
            this.data[ii] = dVec[ii];
        }
    }

    public DoubleVec(int[] dVec) {
        this.init();
        this.data = new double[dVec.length];
        for (int ii = 0; ii < this.data.length; ++ii) {
            this.data[ii] = dVec[ii];
        }
    }

    public DoubleVec(double[] dVec, boolean bDotProd) {
        this.init();
        this.data = new double[dVec.length];
        for (int ii = 0; ii < this.data.length; ++ii) {
            this.data[ii] = dVec[ii];
        }
        if (bDotProd) {
            this.mDotProd = DoubleVec.mult(this.data, this.data);
        }
    }

    public DoubleVec(Vector<Double> vec) {
        this.init();
        this.data = new double[vec.size()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = vec.get(i);
        }
    }

    public DoubleVec(Vector<Double> vec, boolean bDotProd) {
        this.init();
        this.data = new double[vec.size()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = vec.get(i);
        }
        if (bDotProd) {
            this.mDotProd = DoubleVec.mult(this.data, this.data);
        }
    }

    public void addRNDvalue(double dPercentage) {
        Random rnd = new Random();
        for (int ii = 0; ii < this.data.length; ++ii) {
            double dVal = this.data[ii] * (dPercentage / 100.0) * rnd.nextDouble();
            this.data[ii] = rnd.nextBoolean() ? this.data[ii] + dVal : this.data[ii] - dVal;
        }
    }

    public DoubleVec add(DoubleVec dvVec) {
        DoubleVec ret = new DoubleVec(this.data.length);
        if (this.data.length != dvVec.data.length) {
            throw new RuntimeException();
        }
        for (int ii = 0; ii < ret.data.length; ++ii) {
            ret.data[ii] = this.data[ii] + dvVec.data[ii];
        }
        return ret;
    }

    public void addNoise(double fracNoise, double min, double max) {
        double d = max - min;
        for (int ii = 0; ii < this.data.length; ++ii) {
            double rnd;
            if (!(RAND.nextDouble() < fracNoise)) continue;
            this.data[ii] = rnd = min + RAND.nextDouble() * d;
        }
    }

    public Object clone() {
        DoubleVec vec = new DoubleVec(this);
        return vec;
    }

    @Override
    public int compareTo(DoubleVec dv) {
        int cmp = 0;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] > dv.data[i]) {
                cmp = 1;
                break;
            }
            if (!(this.data[i] < dv.data[i])) continue;
            cmp = -1;
            break;
        }
        return cmp;
    }

    public static double distance(DoubleVec dVec1, DoubleVec dVec2, int metric) throws Exception {
        double dDist = 0.0;
        if (metric == 1) {
            dDist = DoubleVec.getCosine(dVec1, dVec2);
        } else if (metric == 2) {
            dDist = DoubleVec.euclideanDistance(dVec1, dVec2);
        } else if (metric == 3) {
            dDist = DoubleVec.getEuclideanDistanceFast(dVec1, dVec2);
        } else if (metric == 4) {
            dDist = DoubleVec.getTanimotoSimilarity(dVec1, dVec2);
        } else if (metric == 5) {
            dDist = DoubleVec.getTanimotoDistanceDotProd(dVec1, dVec2);
        } else {
            throw new Exception("Unknown distance metric.");
        }
        return dDist;
    }

    public static DoubleVec devide(DoubleVec dVec1, DoubleVec dVec2) {
        DoubleVec dVecDev = new DoubleVec(dVec1.data.length);
        for (int ii = 0; ii < dVec1.data.length; ++ii) {
            dVecDev.data[ii] = dVec1.data[ii] / dVec2.data[ii];
        }
        return dVecDev;
    }

    public boolean equal(DoubleVec dv) {
        boolean bEq = true;
        for (int ii = 0; ii < this.data.length; ++ii) {
            if (this.data[ii] == dv.data[ii]) continue;
            bEq = false;
            break;
        }
        return bEq;
    }

    public boolean equals(DoubleVec dv) {
        boolean bEq = true;
        for (int ii = 0; ii < this.data.length; ++ii) {
            if (this.data[ii] == dv.data[ii]) continue;
            bEq = false;
            break;
        }
        return bEq;
    }

    public static double euclideanDistance(DoubleVec dVec1, DoubleVec dVec2) {
        double dist = 0.0;
        double sum = 0.0;
        for (int i = 0; i < dVec1.data.length; ++i) {
            sum += (dVec1.data[i] - dVec2.data[i]) * (dVec1.data[i] - dVec2.data[i]);
        }
        dist = Math.sqrt(sum);
        return dist;
    }

    public static double euclideanDistance(double[] arr1, double[] arr2) {
        double dist = 0.0;
        double sum = 0.0;
        for (int i = 0; i < arr1.length; ++i) {
            sum += (arr1[i] - arr2[i]) * (arr1[i] - arr2[i]);
        }
        dist = Math.sqrt(sum);
        return dist;
    }

    public static double overlapDistance(DoubleVec dVec1, DoubleVec dVec2) {
        double dDist = 0.0;
        double occ1 = 0.0;
        double occ2 = 0.0;
        for (int ii = 0; ii < dVec1.data.length; ++ii) {
            if (dVec1.data[ii] != 0.0) {
                occ1 += 1.0;
            }
            if (dVec2.data[ii] == 0.0) continue;
            occ2 += 1.0;
        }
        double dSum = 0.0;
        double occ = 0.0;
        for (int ii = 0; ii < dVec1.data.length; ++ii) {
            if (dVec1.data[ii] == 0.0 || dVec2.data[ii] == 0.0) continue;
            dSum += Math.abs(dVec1.data[ii] - dVec2.data[ii]);
            occ += 1.0;
        }
        dDist = 1.0 - occ / Math.min(occ1, occ2);
        return dDist;
    }

    public static double getEuclideanDistanceFast(DoubleVec dVec1, DoubleVec dVec2) throws ArrayIndexOutOfBoundsException {
        double dSum = 0.0;
        try {
            for (int ii = 0; ii < dVec1.data.length; ii += 4) {
                dSum += (dVec1.data[ii] - dVec2.data[ii]) * (dVec1.data[ii] - dVec2.data[ii]);
                dSum += (dVec1.data[ii + 1] - dVec2.data[ii + 1]) * (dVec1.data[ii + 1] - dVec2.data[ii + 1]);
                dSum += (dVec1.data[ii + 2] - dVec2.data[ii + 2]) * (dVec1.data[ii + 2] - dVec2.data[ii + 2]);
                dSum += (dVec1.data[ii + 3] - dVec2.data[ii + 3]) * (dVec1.data[ii + 3] - dVec2.data[ii + 3]);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return dSum;
    }

    public double[] get() {
        return this.data;
    }

    public double get(int col) {
        return this.data[col];
    }

    public double getNorm() {
        double dNorm = 0.0;
        for (int ii = 0; ii < this.data.length; ++ii) {
            dNorm += this.data[ii] * this.data[ii];
        }
        dNorm = Math.sqrt(dNorm);
        return dNorm;
    }

    public static double getCosine(DoubleVec dVec1, DoubleVec dVec2) {
        double cosine = 0.0;
        for (int ii = 0; ii < dVec1.data.length; ++ii) {
            cosine += dVec1.data[ii] * dVec2.data[ii];
        }
        return cosine;
    }

    public static double cubicDistance(DoubleVec dVec1, DoubleVec dVec2) {
        double dSum = 0.0;
        for (int ii = 0; ii < dVec1.data.length; ++ii) {
            double dDist = Math.abs(dVec1.data[ii] - dVec2.data[ii]);
            dSum += dDist * dDist * dDist;
        }
        return dSum;
    }

    public void initRND(double dMin, double dMax) {
        double dRange = dMax - dMin;
        for (int kk = 0; kk < this.data.length; ++kk) {
            double dVal;
            this.data[kk] = dVal = dRange * Math.random() + dMin;
        }
    }

    private void init() {
        this.mDotProd = Double.NaN;
    }

    public void initRND(double[][] dArrMaxMin) {
        for (int kk = 0; kk < this.data.length; ++kk) {
            double dVal;
            double dRange = dArrMaxMin[0][kk] - dArrMaxMin[1][kk];
            this.data[kk] = dVal = dRange * Math.random() + dArrMaxMin[1][kk];
        }
    }

    public static double getManhattanBlockDistance(DoubleVec dVec1, DoubleVec dVec2) {
        double dDist = 0.0;
        double dSum = 0.0;
        for (int ii = 0; ii < dVec1.data.length; ++ii) {
            dSum += Math.abs(dVec1.data[ii] - dVec2.data[ii]);
        }
        dDist = Math.sqrt(dSum);
        return dDist;
    }

    public DoubleVec mult(double dFactor) {
        DoubleVec ret = new DoubleVec(this.data.length);
        for (int ii = 0; ii < ret.data.length; ++ii) {
            ret.data[ii] = this.data[ii] * dFactor;
        }
        return ret;
    }

    public static double mult(DoubleVec dVec1, DoubleVec dVec2) {
        double dSum = 0.0;
        for (int ii = 0; ii < dVec1.data.length; ++ii) {
            dSum += dVec1.data[ii] * dVec2.data[ii];
        }
        return dSum;
    }

    private static double mult(double[] arr1, double[] arr2) {
        double dSum = 0.0;
        for (int ii = 0; ii < arr1.length; ++ii) {
            dSum += arr1[ii] * arr2[ii];
        }
        return dSum;
    }

    public static DoubleVec multEl(DoubleVec dVec1, DoubleVec dVec2) {
        DoubleVec dVecMult = new DoubleVec(dVec1.data.length);
        for (int ii = 0; ii < dVec1.data.length; ++ii) {
            dVecMult.data[ii] = dVec1.data[ii] * dVec2.data[ii];
        }
        return dVecMult;
    }

    public void norm2One() {
        double norm = this.getNorm();
        int ii = 0;
        while (ii < this.data.length) {
            int n = ii++;
            this.data[n] = this.data[n] / norm;
        }
    }

    public static DoubleVec minus(DoubleVec dVec1, DoubleVec dVec2) {
        DoubleVec dVecSub = new DoubleVec(dVec1.data.length);
        for (int i = 0; i < dVec1.data.length; ++i) {
            dVecSub.data[i] = dVec1.data[i] - dVec2.data[i];
        }
        return dVecSub;
    }

    public void reduce(Vector<Integer> vecIndices) {
        double[] arr = new double[vecIndices.size()];
        for (int i = 0; i < vecIndices.size(); ++i) {
            int iIndex = vecIndices.get(i);
            arr[i] = this.data[iIndex];
        }
        this.data = arr;
    }

    public static DoubleVec plus(DoubleVec dVec1, DoubleVec dVec2) {
        DoubleVec dVecSum = new DoubleVec(dVec1.data.length);
        for (int ii = 0; ii < dVec1.data.length; ++ii) {
            dVecSum.data[ii] = dVec1.data[ii] + dVec2.data[ii];
        }
        return dVecSum;
    }

    public void set(double dVal) {
        for (int ii = 0; ii < this.data.length; ++ii) {
            this.data[ii] = dVal;
        }
    }

    public void set(double[] arr) {
        this.data = new double[arr.length];
        for (int ii = 0; ii < arr.length; ++ii) {
            this.data[ii] = arr[ii];
        }
    }

    public void set(int[] arr) {
        this.data = new double[arr.length];
        for (int ii = 0; ii < arr.length; ++ii) {
            this.data[ii] = arr[ii];
        }
    }

    public void set(int col, double val) {
        this.data[col] = val;
    }

    public void set(int start, int end, double val) {
        for (int ii = start; ii < end; ++ii) {
            this.data[ii] = val;
        }
    }

    public void setRNDvalue(double dCenter, double dRange) {
        double dMin = dCenter - dRange / 2.0;
        for (int ii = 0; ii < this.data.length; ++ii) {
            double dVal = dRange * Math.random();
            this.data[ii] = dMin + dVal;
        }
    }

    public int size() {
        return this.data.length;
    }

    public void setRNDvalue(double dRange) {
        for (int ii = 0; ii < this.data.length; ++ii) {
            double dMin = this.data[ii] - dRange / 2.0;
            double dVal = dRange * Math.random();
            this.data[ii] = dMin + dVal;
        }
    }

    public DoubleVec sub(DoubleVec dvSub) {
        DoubleVec ret = new DoubleVec(this.data.length);
        for (int ii = 0; ii < ret.data.length; ++ii) {
            ret.data[ii] = this.data[ii] - dvSub.data[ii];
        }
        return ret;
    }

    public static double getTanimotoSimilarity(DoubleVec dVec1, DoubleVec dVec2) {
        double dSum = 0.0;
        double dAtB = DoubleVec.mult(dVec1, dVec2);
        double dAtA = DoubleVec.mult(dVec1, dVec1);
        double dBtB = DoubleVec.mult(dVec2, dVec2);
        dSum = dAtB / (dAtA + dBtB - dAtB);
        return dSum;
    }

    public static double getTanimotoSimilarity(double[] d1, double[] d2) {
        double dSum = 0.0;
        double dAtB = DoubleVec.mult(d1, d2);
        double dAtA = DoubleVec.mult(d1, d1);
        double dBtB = DoubleVec.mult(d2, d2);
        dSum = dAtB / (dAtA + dBtB - dAtB);
        return dSum;
    }

    public static double getTanimotoDistance(DoubleVec dVec1, DoubleVec dVec2) {
        double dSum = 0.0;
        double dAtB = DoubleVec.mult(dVec1, dVec2);
        double dAtA = DoubleVec.mult(dVec1, dVec1);
        double dBtB = DoubleVec.mult(dVec2, dVec2);
        dSum = 1.0 - dAtB / (dAtA + dBtB - dAtB);
        return dSum;
    }

    public static double getTanimotoDistance(double[] d1, double[] d2) {
        return 1.0 - DoubleVec.getTanimotoSimilarity(d1, d2);
    }

    public static double getTanimotoDistanceDotProd(DoubleVec dVec1, DoubleVec dVec2) {
        double dSum = 0.0;
        double dAtB = DoubleVec.mult(dVec1, dVec2);
        double dAtA = dVec1.mDotProd;
        double dBtB = dVec2.mDotProd;
        dSum = 1.0 - dAtB / (dAtA + dBtB - dAtB);
        return dSum;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (int ii = 0; ii < this.data.length; ++ii) {
            String sVal = NF.format(this.data[ii]);
            str.append(sVal + " ");
        }
        return str.toString();
    }

    public String toString(int iNumDigits) {
        StringBuffer str = new StringBuffer();
        String sFormat = "0";
        if (iNumDigits > 0) {
            sFormat = sFormat + ".";
        }
        for (int ii = 0; ii < iNumDigits; ++ii) {
            sFormat = sFormat + "0";
        }
        DecimalFormat nf = new DecimalFormat(sFormat);
        for (int ii = 0; ii < this.data.length; ++ii) {
            String sVal = nf.format(this.data[ii]);
            str.append(sVal + " ");
        }
        return str.toString();
    }

    public double[] toArray() {
        return this.data;
    }
}

