/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;

public class Formatter {
    private LocaleFormat localeFormat = LocaleFormat.SWISS;
    private static DateFormat yyyyFormat = new SimpleDateFormat("yyyyMMdd");
    private static DateFormat dateFormat;
    private static DateFormat timeFormat;
    private static DateFormat[] dateTimeParsers;
    private static DateFormat[] dateTimeFormatters;
    private static final DecimalFormat df0;
    private static final DecimalFormat df1;
    private static final DecimalFormat df2;
    private static final DecimalFormat dfmax2;
    private static final DecimalFormat df3;
    private static final DecimalFormat dfmax3;
    private static final DecimalFormat df4;
    private static final DecimalFormat df8;
    private static final DecimalFormat dfE;
    public static final DecimalFormat dfI2;
    public static final DecimalFormat dfI3;

    public LocaleFormat getLocaleFormat() {
        return this.localeFormat;
    }

    public static void setLocaleFormat(LocaleFormat localeFormat) {
        assert (localeFormat != null);
        dateFormat = new SimpleDateFormat(localeFormat.getLocaleDateFormat());
        timeFormat = new SimpleDateFormat(localeFormat.getLocaleTimeFormat());
        dateTimeParsers = new SimpleDateFormat[]{new SimpleDateFormat(localeFormat.getLocaleDateFormat() + " " + localeFormat.getLocaleTimeFormat() + ":ss"), new SimpleDateFormat(localeFormat.getLocaleDateFormat() + " " + localeFormat.getLocaleTimeFormat()), new SimpleDateFormat(localeFormat.getLocaleDateFormat()), new SimpleDateFormat("MM.yy"), new SimpleDateFormat("yy")};
        dateTimeFormatters = new SimpleDateFormat[]{new SimpleDateFormat(localeFormat.getLocaleDateFormat() + "yy " + localeFormat.getLocaleTimeFormat() + ":ss"), new SimpleDateFormat(localeFormat.getLocaleDateFormat() + "yy " + localeFormat.getLocaleTimeFormat()), new SimpleDateFormat(localeFormat.getLocaleDateFormat() + "yy"), new SimpleDateFormat("MM.yyyy"), new SimpleDateFormat("yyyy")};
    }

    public static final String format0(Double d) {
        if (d == null) {
            return "";
        }
        return df0.format(d);
    }

    public static final String format1(Double d) {
        if (d == null) {
            return "";
        }
        return df1.format(d);
    }

    public static final String format2(Double d) {
        if (d == null) {
            return "";
        }
        return df2.format(d);
    }

    public static final String formatMax2(Double d) {
        if (d == null) {
            return "";
        }
        return dfmax2.format(d);
    }

    public static final String format3(Double d) {
        if (d == null) {
            return "";
        }
        return df3.format(d);
    }

    public static final String formatMax3(Double d) {
        if (d == null) {
            return "";
        }
        return dfmax3.format(d);
    }

    public static final String format4(Double d) {
        if (d == null) {
            return "";
        }
        return df4.format(d);
    }

    public static final String format8(Double d) {
        if (d == null) {
            return "";
        }
        return df8.format(d);
    }

    public static final String formatE(Double d) {
        if (d == null) {
            return "";
        }
        return dfE.format(d);
    }

    public static final String format(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Double) {
            return Formatter.format3((Double)value);
        }
        if (value instanceof Date) {
            return Formatter.formatDateTime((Date)value);
        }
        return "" + value;
    }

    public static final String formatDate(Date d) {
        return d == null ? "" : dateFormat.format(d);
    }

    public static final String formatTime(Date d) {
        return d == null ? "" : timeFormat.format(d);
    }

    public static final String formatDateTime(Date d) {
        if (d == null) {
            return "";
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        if (cal.get(13) != 0) {
            return dateTimeFormatters[0].format(d);
        }
        if (cal.get(11) != 0 || cal.get(12) != 0) {
            return dateTimeFormatters[1].format(d);
        }
        if (cal.get(5) != 1) {
            return dateTimeFormatters[2].format(d);
        }
        if (cal.get(2) != 0) {
            return dateTimeFormatters[3].format(d);
        }
        return dateTimeFormatters[4].format(d);
    }

    public static final String formatDateTimeShort(Date d) {
        if (d == null) {
            return "";
        }
        return dateTimeParsers[2].format(d);
    }

    public static final Date parseDate(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        try {
            return dateFormat.parse(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final Date parseDateTime(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        int ndate = 0;
        int ntime = 0;
        int[] date = new int[3];
        int[] time = new int[3];
        boolean inDate = true;
        StringTokenizer st = new StringTokenizer(s.trim(), ":/. ", true);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals("/") || tok.equals(".")) {
                if (inDate) {
                    if (++ndate <= 2) continue;
                    return null;
                }
                return null;
            }
            if (tok.equals(":")) {
                if (inDate) {
                    return null;
                }
                if (++ntime <= 2) continue;
                return null;
            }
            if (tok.equals(" ")) {
                if (inDate) {
                    ++ndate;
                    inDate = false;
                    continue;
                }
                return null;
            }
            for (int i = 0; i < tok.length(); ++i) {
                if (Character.isDigit(tok.charAt(i))) continue;
                return null;
            }
            if (inDate) {
                date[ndate] = Integer.parseInt(tok);
                continue;
            }
            time[ntime] = Integer.parseInt(tok);
        }
        if (inDate) {
            ++ndate;
        } else {
            ++ntime;
        }
        if (ndate == 0) {
            cal.set(5, 1);
            cal.set(2, 0);
            cal.set(1, 0);
        } else if (ndate == 1) {
            cal.set(5, 1);
            cal.set(2, 0);
            cal.set(1, date[0] < 100 ? date[0] + 2000 : date[0]);
        } else if (ndate == 2) {
            cal.set(5, 1);
            cal.set(2, date[0] - 1);
            cal.set(1, date[1] < 100 ? date[1] + 2000 : date[1]);
        } else if (ndate == 3) {
            cal.set(5, date[0]);
            cal.set(2, date[1] - 1);
            cal.set(1, date[2] < 100 ? date[2] + 2000 : date[2]);
        } else {
            return null;
        }
        if (ntime == 0) {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        } else {
            if (ntime == 1) {
                return null;
            }
            if (ntime == 2) {
                cal.set(11, time[0]);
                cal.set(12, time[1]);
                cal.set(13, 0);
            } else if (ntime == 3) {
                cal.set(11, time[0]);
                cal.set(12, time[1]);
                cal.set(13, time[2]);
            } else {
                return null;
            }
        }
        return cal.getTime();
    }

    public static final String cleanDate(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        try {
            return Formatter.formatDate(Formatter.parseDate(s));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final String cleanDateTime(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        Date d = Formatter.parseDateTime(s);
        if (d == null) {
            return "";
        }
        return Formatter.formatDateTime(d);
    }

    public static final String formatYYYYMMDD() {
        return yyyyFormat.format(new Date());
    }

    public static void main(String[] args) {
        System.out.println(Formatter.format3(Double.NaN));
        System.out.println(Formatter.parseDateTime("10.10.2013 12:23:20"));
        System.out.println(Formatter.parseDateTime("10.10.2013 12:23"));
        System.out.println(Formatter.parseDateTime("10.10.2013"));
        System.out.println(Formatter.parseDateTime("10.2013"));
        System.out.println(Formatter.parseDateTime("2013"));
        System.out.println();
        System.out.println(Formatter.formatDateTime(Formatter.parseDateTime("10.10.2013 12:23:20")));
        System.out.println(Formatter.formatDateTime(Formatter.parseDateTime("10.10.2013 12:23")));
        System.out.println(Formatter.formatDateTime(Formatter.parseDateTime("10.10.2013")));
        System.out.println();
        System.out.println("10.10.2013 12:23:20 -> " + Formatter.cleanDateTime("10.10.2013 12:23:20"));
        System.out.println("10/1/2013 12:60 -> " + Formatter.cleanDateTime("10.10.2013 12:60"));
        System.out.println("31.12.2013 23:60 -> " + Formatter.cleanDateTime("31.12.2013 23:60"));
        System.out.println("10.12.2013 -> " + Formatter.cleanDateTime("10.12.2013"));
        System.out.println("12.2013 -> " + Formatter.cleanDateTime("12.2013"));
        System.out.println("2013 -> " + Formatter.cleanDateTime("2013"));
        System.out.println("13 -> " + Formatter.cleanDateTime("13"));
        System.out.println();
        System.out.println(Formatter.cleanDateTime("10/10/2013"));
        System.out.println(Formatter.cleanDateTime("toto"));
    }

    static {
        df0 = new DecimalFormat("0");
        df1 = new DecimalFormat("0.0");
        df2 = new DecimalFormat("0.00");
        dfmax2 = new DecimalFormat("0.##");
        df3 = new DecimalFormat("0.000");
        dfmax3 = new DecimalFormat("0.###");
        df4 = new DecimalFormat("0.0000");
        df8 = new DecimalFormat("0.00000000");
        dfE = new DecimalFormat("0.00E0");
        dfI2 = new DecimalFormat("00");
        dfI3 = new DecimalFormat("000");
        Formatter.setLocaleFormat(LocaleFormat.SWISS);
        df0.setRoundingMode(RoundingMode.HALF_UP);
        df1.setRoundingMode(RoundingMode.HALF_UP);
        df2.setRoundingMode(RoundingMode.HALF_UP);
        dfmax2.setRoundingMode(RoundingMode.HALF_UP);
        df3.setRoundingMode(RoundingMode.HALF_UP);
        dfmax3.setRoundingMode(RoundingMode.HALF_UP);
        df4.setRoundingMode(RoundingMode.HALF_UP);
        df8.setRoundingMode(RoundingMode.HALF_UP);
        dfE.setRoundingMode(RoundingMode.HALF_UP);
    }

    public static enum LocaleFormat {
        SWISS("dd.MM.yy", "HH:mm"),
        EUROPEAN("dd/MM/yy", "HH:mm"),
        AMERICAN("dd/MM/yy", "HH:mm");

        private String localeDateFormat;
        private String localeTimeFormat;

        private LocaleFormat(String localeDateFormat, String localeTimeFormat) {
            this.localeDateFormat = localeDateFormat;
            this.localeTimeFormat = localeTimeFormat;
        }

        public String getLocaleDateFormat() {
            return this.localeDateFormat;
        }

        public String getLocaleTimeFormat() {
            return this.localeTimeFormat;
        }
    }
}

