/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LittleEndianDataInputStream
implements DataInput {
    protected DataInputStream d;
    protected InputStream in;
    byte[] w;

    public LittleEndianDataInputStream(InputStream in) {
        this.in = in;
        this.d = new DataInputStream(in);
        this.w = new byte[8];
    }

    @Override
    public final short readShort() throws IOException {
        this.d.readFully(this.w, 0, 2);
        return (short)((this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF);
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        this.d.readFully(this.w, 0, 2);
        return (this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF;
    }

    @Override
    public final char readChar() throws IOException {
        this.d.readFully(this.w, 0, 2);
        return (char)((this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF);
    }

    @Override
    public final int readInt() throws IOException {
        this.d.readFully(this.w, 0, 4);
        return this.w[3] << 24 | (this.w[2] & 0xFF) << 16 | (this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF;
    }

    @Override
    public final long readLong() throws IOException {
        this.d.readFully(this.w, 0, 8);
        return (long)this.w[7] << 56 | (long)(this.w[6] & 0xFF) << 48 | (long)(this.w[5] & 0xFF) << 40 | (long)(this.w[4] & 0xFF) << 32 | (long)(this.w[3] & 0xFF) << 24 | (long)(this.w[2] & 0xFF) << 16 | (long)(this.w[1] & 0xFF) << 8 | (long)(this.w[0] & 0xFF);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.d.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            System.err.println("Error: Negative number of bytes to read");
        } else {
            this.d.readFully(b, off, len);
        }
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        return this.d.skipBytes(n);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.d.readBoolean();
    }

    @Override
    public final byte readByte() throws IOException {
        return this.d.readByte();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.d.readUnsignedByte();
    }

    @Override
    @Deprecated
    public final String readLine() throws IOException {
        return this.d.readLine();
    }

    @Override
    public final String readUTF() throws IOException {
        return this.d.readUTF();
    }

    public static String readUTF(DataInput in) throws IOException {
        return DataInputStream.readUTF(in);
    }

    public final void close() throws IOException {
        this.d.close();
    }
}

