/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LittleEndianDataOutputStream
implements DataOutput {
    private DataOutputStream delegate;
    private byte[] buffer;

    public LittleEndianDataOutputStream(OutputStream out) {
        this.delegate = new DataOutputStream(out);
        this.buffer = new byte[8];
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.buffer[0] = (byte)v;
        this.buffer[1] = (byte)(v >> 8);
        this.delegate.write(this.buffer, 0, 2);
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.buffer[0] = (byte)v;
        this.buffer[1] = (byte)(v >> 8);
        this.delegate.write(this.buffer, 0, 2);
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.buffer[0] = (byte)v;
        this.buffer[1] = (byte)(v >> 8);
        this.buffer[2] = (byte)(v >> 16);
        this.buffer[3] = (byte)(v >> 24);
        this.delegate.write(this.buffer, 0, 4);
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.buffer[0] = (byte)v;
        this.buffer[1] = (byte)(v >> 8);
        this.buffer[2] = (byte)(v >> 16);
        this.buffer[3] = (byte)(v >> 24);
        this.buffer[4] = (byte)(v >> 32);
        this.buffer[5] = (byte)(v >> 40);
        this.buffer[6] = (byte)(v >> 48);
        this.buffer[7] = (byte)(v >> 56);
        this.delegate.write(this.buffer, 0, 8);
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public final void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    @Override
    public final synchronized void write(int b) throws IOException {
        this.delegate.write(b);
    }

    @Override
    public final synchronized void write(byte[] b, int off, int len) throws IOException {
        this.delegate.write(b, off, len);
    }

    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.delegate.writeBoolean(v);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.delegate.writeByte(v);
    }

    @Override
    public final void writeBytes(String s) throws IOException {
        this.delegate.writeBytes(s);
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        this.delegate.writeUTF(str);
    }

    public final int size() {
        return this.delegate.size();
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.delegate.write(b, 0, b.length);
    }

    public final void close() throws IOException {
        this.delegate.close();
    }
}

