/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public class Platform {
    private static boolean isWin = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
    private static boolean isMac = System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0;
    private static boolean isLinux = System.getProperty("os.name").toLowerCase().indexOf("nux") >= 0;
    private static boolean isUnix = System.getProperty("os.name").toLowerCase().indexOf("nix") >= 0;
    private static Properties PATH_PROPERTIES = null;
    private static String WINPATH = "\\\\idorsia.com\\app\\DDSC\\config";
    private static String WINPROPERTIES = WINPATH + "\\ApplicationDatabase.db";
    private static final String[] WINDOWS_APP_DIR = new String[]{"C:\\Program Files\\", "C:\\Program Files (x86)\\"};
    private static final String[][] WINDOWS_APPL_NAME = new String[][]{{"datawarrior", "DataWarrior\\DataWarrior.exe"}, {"orbit", "Orbit\\Orbit.exe"}, {"pymol", "PyMOL\\pymol.exe"}};
    private static final String[][] MACINTOSH_APP_NAME = new String[][]{{"orbit", "Orbit Image Analysis"}, {"datawarrior", "DataWarrior"}, {"actelion3d", "Actelion3D"}, {"pymol", "PyMol"}, {"spirit", "Spirit Database"}};

    public static boolean isWindows() {
        return isWin;
    }

    public static boolean isMacintosh() {
        return isMac;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static boolean isUnix() {
        return isUnix;
    }

    public static boolean is64BitJRE() {
        return System.getProperty("os.arch").indexOf("64") != -1;
    }

    public static Process execute(String program, String ... args) throws IOException {
        String executable = Platform.findExecutable(program);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(executable);
        if (args != null && args.length > 0) {
            for (String a : args) {
                arguments.add(a);
            }
        }
        Process command = Platform.systemExec(arguments.toArray(new String[0]));
        return command;
    }

    public static void execute(String[] programAndArgs) throws IOException {
        programAndArgs[0] = Platform.findExecutable(programAndArgs[0]);
        Platform.systemExec(programAndArgs);
    }

    public static Process systemExec(String[] programAndArgs) throws IOException {
        if (Platform.isWindows()) {
            String[] modifiedProgramAndArgs = new String[programAndArgs.length + 4];
            modifiedProgramAndArgs[0] = "cmd";
            modifiedProgramAndArgs[1] = "/c";
            modifiedProgramAndArgs[2] = "start";
            modifiedProgramAndArgs[3] = "\"\"";
            System.arraycopy(programAndArgs, 0, modifiedProgramAndArgs, 4, programAndArgs.length);
            programAndArgs = modifiedProgramAndArgs;
        }
        return Runtime.getRuntime().exec(programAndArgs);
    }

    public static void openDocument(String doc) throws IOException, UnsupportedOperationException {
        if (!Desktop.isDesktopSupported()) {
            if (Platform.isLinux()) {
                throw new UnsupportedOperationException("Please check your OS installation: Is the libgnome2 library missing?");
            }
            throw new UnsupportedOperationException("Desktop integration on this OS/Machine not supported");
        }
        Desktop.getDesktop().open(new File(doc));
    }

    private static String findExecutable(String name) {
        String path;
        String res = name;
        if (Platform.isWindows()) {
            for (String[] stringArray : WINDOWS_APPL_NAME) {
                if (!stringArray[0].equals(name)) continue;
                for (String appDir : WINDOWS_APP_DIR) {
                    String path2 = appDir.concat(stringArray[1]);
                    if (!new File(path2).exists()) continue;
                    return path2;
                }
            }
            for (String[] stringArray : WINDOWS_APP_DIR) {
                path = stringArray.concat(name).concat("\\").concat(name).concat(".exe");
                if (!new File(path).exists()) continue;
                return path;
            }
            try {
                String value;
                if (PATH_PROPERTIES == null) {
                    PATH_PROPERTIES = new Properties();
                    PATH_PROPERTIES.load(new FileInputStream(WINPROPERTIES));
                }
                if ((value = PATH_PROPERTIES.getProperty(name)) != null) {
                    res = value;
                }
            }
            catch (Throwable e) {
                System.err.println("Error reading Application Database file: " + e);
            }
        }
        if (Platform.isMacintosh()) {
            for (String[] stringArray : MACINTOSH_APP_NAME) {
                if (!stringArray[0].equals(name)) continue;
                path = "/Applications/" + stringArray[1] + ".app/Contents/MacOS/" + name;
                if (new File(path).exists()) {
                    return path;
                }
                path = "/Applications/" + stringArray[1] + ".app/Contents/MacOS/JavaApplicationStub";
                return new File(path).exists() ? path : res;
            }
        }
        if (Platform.isLinux()) {
            String path3 = "/opt/actelion/" + name + "/" + name;
            if (new File(path3).exists()) {
                return path3;
            }
            path3 = "/opt/idorsia/" + name + "/" + name;
            if (new File(path3).exists()) {
                return path3;
            }
            path3 = "/opt/" + name + "/" + name;
            if (new File(path3).exists()) {
                return path3;
            }
            return res;
        }
        return res;
    }
}

