/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.util.Arrow;
import com.actelion.research.util.DblPoint;
import com.actelion.research.util.LittleEndianDataInputStream;
import com.actelion.research.util.LittleEndianDataOutputStream;
import com.actelion.research.util.Rect;
import com.actelion.research.util.Rect2D;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class Sketch {
    private static final boolean debug_ = false;
    public static final double PI = 3.1415926;
    public static final int MAXMOLS = 12;
    public static final byte $Version = 1;
    public static final byte $Totobjs = 2;
    public static final byte $Obj = 3;
    public static final byte $Locked = 4;
    public static final byte $Pen_width = 5;
    public static final byte $Pen_style = 6;
    public static final byte $Pen_color = 7;
    public static final byte $Transparent = 8;
    public static final byte $Fill_style = 9;
    public static final byte $Fill_color = 10;
    public static final byte $Font = 11;
    public static final byte $Parent = 12;
    public static final byte $Obj_coords = 13;
    public static final byte $Crop_coords = 14;
    public static final byte $Roundrect_curve = 15;
    public static final byte $Arc_endpts = 16;
    public static final byte $Poly_points = 17;
    public static final byte $Poly_smoothed = 18;
    public static final byte $Begsketch = 19;
    public static final byte $Endsketch = 20;
    public static final byte $MDLEditText = 21;
    public static final byte $Atom_coords = 22;
    public static final byte $Atom_type = 23;
    public static final byte $Atom_list = 24;
    public static final byte $Atom_alias = 25;
    public static final byte $Atom_number = 26;
    public static final byte $Atom_chg = 27;
    public static final byte $Atom_rad = 28;
    public static final byte $Atom_msdif = 29;
    public static final byte $Atom_valence = 30;
    public static final byte $Atom_rbcount = 31;
    public static final byte $Atom_substcount = 32;
    public static final byte $Atom_stereo_care = 33;
    public static final byte $Atom_h0bit = 34;
    public static final byte $Atom_unsat = 35;
    public static final byte $Atom_value = 36;
    public static final byte $Atom_dispflags = 37;
    public static final byte $Atom_hpos = 38;
    public static final byte $Bond_atoms = 39;
    public static final byte $Bond_type = 40;
    public static final byte $Bond_stereo_type = 41;
    public static final byte $Bond_topo = 42;
    public static final byte $Bond_qtopo = 43;
    public static final byte $Bond_rxn_center = 44;
    public static final byte $Bond_stereo_care = 45;
    public static final byte $Bond_dbl_side = 46;
    public static final byte $Bond_dbl_width = 47;
    public static final byte $RxnAtch = 48;
    public static final byte $RGroupNo = 49;
    public static final byte $RLogic = 50;
    public static final byte $SGroupAtch = 51;
    public static final byte $SGroupName = 52;
    public static final byte $Atom_rgroupAtch = 53;
    public static final byte $SGroupType = 54;
    public static final byte $SGroupLinkVal = 55;
    public static final byte $ArrowDir = 56;
    public static final byte $ArrowStyle = 57;
    public static final byte $MetaData = 58;
    public static final byte $Mol_type = 59;
    public static final byte $Abbrev_atch = 60;
    public static final byte $SGroupAtchPt = 61;
    public static final byte $Atom_npos = 62;
    public static final byte $Atom_aamapped = 63;
    public static final byte $Name = 64;
    public static final byte $Comment = 65;
    public static final byte $Atom_fixed = 66;
    public static final byte $3D_num_basis_objs = 67;
    public static final byte $3D_basis_objs = 68;
    public static final byte $3D_name = 69;
    public static final byte $3D_minval = 70;
    public static final byte $3D_maxval = 71;
    public static final byte $3D_tolerance = 72;
    public static final byte $3D_point_dist = 73;
    public static final byte $3D_dihed_chiral = 74;
    public static final byte $3D_exclus_radius = 75;
    public static final byte $3D_point_dir = 76;
    public static final byte $3D_atom_query = 77;
    public static final byte $Atom_zcoord = 78;
    public static final byte $Atom_exact_change = 79;
    public static final byte $Atom_rxn_stereo = 80;
    public static final byte $Bond_crossed = 81;
    public static final byte $Bond_alt_stereo = 82;
    public static final byte $3D_exclus_ignore = 83;
    public static final byte $Pen_style_token = 84;
    public static final byte $BigMetaData = 85;
    public static final byte $Pen_RGB2Color = 88;
    public static final byte $Fill_RGB2Color = 89;
    public static final byte $Atom_tplatchpt = 91;
    public static final byte $Is_A_Model = 92;
    public static final byte $Atom_aamap_num = 96;
    public static final byte $Atom_hshow = 98;
    public static final byte $SGroupNewAtch = -92;
    public static final byte $SGroupContext = -54;
    public static final byte $Nostruct_label = -53;
    public static final byte $Nostruct_regno = -52;
    public static final byte $Circ_Arc_Points = -51;
    public static final byte $Bond_hash_spacing = -50;
    public static final byte $Bond_bond_spacing = -49;
    public static final byte $Atom_margin_width = -48;
    public static final byte $ArrowType = -36;
    public static final byte $Atom_Orig_coords = -33;
    public static final byte $Atom_AttachLen = -32;
    public static final byte $Atom_DotWidth = -31;
    public static final byte $SGroupBracketLen = -30;
    public static final byte $3D_marker_rf = -29;
    public static final byte $Model_Rotated = -28;
    public static final byte $ArrowSize = -27;
    public static final byte $ArrowShaftSp = -26;
    public static final byte $Pen_widthUnit = -25;
    public static final byte $Atom_symbol = -24;
    public static final byte $Atom_NumSize = -23;
    public static final byte $3D_exclus_dradius = -22;
    public static final byte $Atom_can_reverse = -21;
    public static final byte $3D_point_ddist = -20;
    public static final byte $Obj_Mol = 12;
    public static final byte $Obj_Chiral = 19;
    public static final byte $Obj_Bond = 32;
    public static final byte $Obj_Atom = 33;
    public static final int MSDIFF_OFFSET = 19;
    private static String DefaultFontName = "Arial";
    private static final int BYTESIZE = 1;
    private static final int WORDSIZE = 2;
    private static final int MOLSIZE = 1440;
    private static final int REACTIONSIZE = 4000;
    private static final int PLUSSIZE = 20;

    public static boolean createMolFromSketchFile(StereoMolecule mol, String szFileName) throws IOException {
        File f = new File(szFileName);
        byte[] buffer = new byte[(int)f.length()];
        FileInputStream is = new FileInputStream(f);
        is.read(buffer);
        is.close();
        return Sketch.createMolFromSketchBuffer(mol, buffer);
    }

    public static boolean createMolFromSketchBuffer(StereoMolecule mol, byte[] buffer) throws IOException {
        ByteArrayInputStream b = new ByteArrayInputStream(buffer);
        LittleEndianDataInputStream fp = new LittleEndianDataInputStream(b);
        return Sketch.getMolObjects(mol, fp);
    }

    public static boolean writeMolSketchFile(Molecule mol, String filename) throws IOException {
        FileOutputStream os = new FileOutputStream(filename);
        boolean ok = Sketch.writeMolSketchFile(mol, os);
        os.close();
        return ok;
    }

    public static boolean writeMolSketchFile(Molecule mol, OutputStream os) throws IOException {
        boolean ok = false;
        byte[] buffer = Sketch.createSketchFromMol(mol);
        if (buffer != null) {
            os.write(buffer);
            ok = true;
        }
        return ok;
    }

    public static boolean createReactionFromSketchFile(Reaction rxn, String szFileName) throws IOException {
        File f = new File(szFileName);
        byte[] buffer = new byte[(int)f.length()];
        FileInputStream is = new FileInputStream(f);
        is.read(buffer);
        is.close();
        ByteArrayInputStream b = new ByteArrayInputStream(buffer);
        LittleEndianDataInputStream fp = new LittleEndianDataInputStream(b);
        return Sketch.createReactionFromSketchBuffer(rxn, fp);
    }

    public static boolean createReactionFromSketchBuffer(Reaction rxn, byte[] buffer) throws IOException {
        ByteArrayInputStream b = new ByteArrayInputStream(buffer);
        LittleEndianDataInputStream fp = new LittleEndianDataInputStream(b);
        return Sketch.createReactionFromSketchBuffer(rxn, fp);
    }

    public static boolean writeReactionSketchFile(Reaction rxn, String filename) throws IOException {
        boolean ok = false;
        FileOutputStream os = new FileOutputStream(filename);
        if (Sketch.writeReactionSketchFile(rxn, os)) {
            os.flush();
            os.close();
            ok = true;
        }
        return ok;
    }

    public static boolean writeReactionSketchFile(Reaction rxn, OutputStream os) throws IOException {
        boolean ok = false;
        byte[] buffer = Sketch.createSketchFromReaction(rxn);
        if (buffer != null) {
            os.write(buffer);
            ok = true;
        }
        return ok;
    }

    private static boolean getMolObjects(StereoMolecule molMain, LittleEndianDataInputStream fp) throws IOException {
        byte c;
        int ObjectCount = 0;
        boolean ok = false;
        byte[] buff = new byte[1024];
        boolean chiralFound = false;
        block14: do {
            c = fp.readByte();
            block1 : switch (c) {
                case 1: {
                    ObjectCount = 0;
                    short t = fp.readShort();
                    byte bval = fp.readByte();
                    break;
                }
                case 2: {
                    short t = fp.readShort();
                    fp.readShort();
                    ObjectCount = -1;
                    break;
                }
                case 11: {
                    short t = fp.readShort();
                    byte bval = fp.readByte();
                    fp.readFully(buff, 0, bval);
                    fp.readShort();
                    fp.readByte();
                    break;
                }
                case 20: {
                    short t;
                    try {
                        t = fp.readShort();
                    }
                    catch (IOException e) {
                        System.err.println("Error found $Endsketch, but no data...");
                    }
                    continue block14;
                }
                case 3: {
                    short t = fp.readShort();
                    byte bval = fp.readByte();
                    switch (bval) {
                        case 12: {
                            StereoMolecule m = new StereoMolecule();
                            if (!Sketch.getMolObject(m, fp)) {
                                return false;
                            }
                            molMain.addMolecule(m);
                            if (m.isFragment()) {
                                molMain.setFragment(true);
                            }
                            ok = true;
                            break block1;
                        }
                        case 19: {
                            chiralFound = true;
                            ++ObjectCount;
                            break block1;
                        }
                    }
                    System.out.println("Warning: Sketch.getMolObjects() Object not supported: " + bval);
                    ++ObjectCount;
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    short t = fp.readShort();
                    if (t <= 2) continue block14;
                    fp.readFully(buff, 0, t - 2);
                }
            }
        } while (c != -1 && fp.in.available() > 0);
        if (!chiralFound) {
            molMain.setToRacemate();
        }
        return ok;
    }

    private static boolean createReactionFromSketchBuffer(Reaction rxn, LittleEndianDataInputStream fp) throws IOException {
        StereoMolecule mol = null;
        Rect rect = new Rect();
        Arrow arrow = new Arrow();
        ArrayList<StereoMolecule> v = new ArrayList<StereoMolecule>();
        int numObjects = Sketch.readSketchHeader(fp);
        if (numObjects > 1) {
            block6: for (int i = 0; i < numObjects; ++i) {
                switch (Sketch.getNextObject(fp)) {
                    case 9: {
                        String strText = Sketch.getTextObject(rect, fp);
                        if (strText != "+") continue block6;
                        continue block6;
                    }
                    case 12: {
                        mol = new StereoMolecule();
                        Sketch.getMolObject(mol, fp);
                        mol.ensureHelperArrays(1);
                        v.add(mol);
                        continue block6;
                    }
                    case 14: {
                        Sketch.getArrowObject(arrow, fp);
                        continue block6;
                    }
                    case 4: {
                        Sketch.getLineArrowObject(arrow, fp);
                        continue block6;
                    }
                    default: {
                        System.err.println("Warning: Sketch.createReactionFromSketchBuffer(): UnKnown Object");
                    }
                }
            }
            Sketch.buildReaction(rxn, v, arrow);
            return true;
        }
        return false;
    }

    private static void buildReaction(Reaction r, ArrayList<StereoMolecule> v, Arrow a) {
        int size = v.size();
        StereoMolecule m = null;
        for (int i = 0; i < size; ++i) {
            m = v.get(i);
            Point pt = Sketch.getMoleculeCenter(m);
            if (a.left > pt.x) {
                r.addReactant(m);
                continue;
            }
            r.addProduct(m);
        }
    }

    private static Rect getBoundingRect(Molecule m) {
        Rect r = new Rect(Short.MAX_VALUE, Short.MAX_VALUE, Short.MIN_VALUE, Short.MIN_VALUE);
        int atoms = m.getAllAtoms();
        for (int i = 0; i < atoms; ++i) {
            float x = (short)m.getAtomX(i);
            float y = (short)m.getAtomY(i);
            r.left = (short)Math.min(x, (float)r.left);
            r.top = (short)Math.min(y, (float)r.top);
            r.right = (short)Math.max(x, (float)r.right);
            r.bottom = (short)Math.max(y, (float)r.bottom);
        }
        Sketch.debug("Bounding Rect for Molecule " + m + " is " + r.left + "," + r.top + "," + r.right + "," + r.bottom);
        return r;
    }

    private static Rect2D getBoundingRectangle(Molecule m) {
        Rect2D r = new Rect2D(Double.MAX_VALUE, Double.MAX_VALUE, Double.MIN_VALUE, Double.MIN_VALUE);
        int atoms = m.getAllAtoms();
        for (int i = 0; i < atoms; ++i) {
            double x = m.getAtomX(i);
            double y = m.getAtomY(i);
            r.left = Math.min(x, r.left);
            r.top = Math.min(y, r.top);
            r.right = Math.max(x, r.right);
            r.bottom = Math.max(y, r.bottom);
        }
        Sketch.debug("Bounding Rect2D for Molecule " + m + " is " + r.left + "," + r.top + "," + r.right + "," + r.bottom);
        return r;
    }

    private static Rect2D getBoundingRectangle(Reaction rxn) {
        Rect2D r = new Rect2D(Double.MAX_VALUE, Double.MAX_VALUE, Double.MIN_VALUE, Double.MIN_VALUE);
        Rect2D rm = null;
        int mols = rxn.getMolecules();
        for (int i = 0; i < mols; ++i) {
            rm = Sketch.getBoundingRectangle(rxn.getMolecule(i));
            r.left = Math.min(r.left, rm.left);
            r.top = Math.min(r.top, rm.top);
            r.right = Math.max(r.right, rm.right);
            r.bottom = Math.max(r.bottom, rm.bottom);
        }
        Sketch.debug("Bounding Rect2D for Reaction " + rxn + " is " + r.left + "," + r.top + "," + r.right + "," + r.bottom);
        return r;
    }

    private static Point getMoleculeCenter(Molecule m) {
        Rect r = Sketch.getBoundingRect(m);
        return Sketch.getCenter(r);
    }

    private static Point getCenter(Rect r) {
        int dx = r.right - r.left;
        int dy = r.bottom - r.top;
        return new Point(r.left + dx / 2, r.top + dy / 2);
    }

    private static boolean getMolObject(StereoMolecule mol, LittleEndianDataInputStream fp) throws IOException {
        byte c;
        byte[] buff = new byte[1024];
        int AtomType = 0;
        short val = 0;
        int num = 0;
        DblPoint dblCoords = new DblPoint();
        int ObjectCount = 0;
        int MolObject = -1;
        int BondObject = -1;
        int AtomObject = -1;
        int[] molAtoms = new int[mol.getMaxAtoms()];
        boolean chiralFound = false;
        block26: do {
            c = fp.readByte();
            switch (c) {
                case 2: {
                    short t = fp.readShort();
                    val = fp.readShort();
                    ObjectCount = -1;
                    AtomObject = -1;
                    BondObject = -1;
                    break;
                }
                case 3: {
                    short t = fp.readShort();
                    byte bval = fp.readByte();
                    switch (bval) {
                        case 32: {
                            ++BondObject;
                            ++ObjectCount;
                            break;
                        }
                        case 33: {
                            ++AtomObject;
                            mol.addAtom("C");
                            ++ObjectCount;
                            AtomType = 0;
                            break;
                        }
                        case 19: {
                            ++ObjectCount;
                            chiralFound = true;
                            AtomType = 0;
                            break;
                        }
                        default: {
                            ++ObjectCount;
                        }
                    }
                    if (MolObject <= 1) continue block26;
                    System.err.println("Sorry Only One Molecule supported\n");
                    throw new RuntimeException("Only One Molecule supported");
                }
                case 19: {
                    short t = fp.readShort();
                    fp.readFully(buff, 0, t - 2);
                    break;
                }
                case 20: {
                    short t = fp.readShort();
                    Sketch.correctBondAtomNumbering(mol, AtomObject + 1, BondObject + 1, molAtoms);
                    if (!chiralFound) {
                        mol.setToRacemate();
                    }
                    return true;
                }
                case 22: {
                    short t = fp.readShort();
                    dblCoords.x = fp.readFloat();
                    dblCoords.y = fp.readFloat();
                    mol.setAtomX(AtomObject, dblCoords.x);
                    mol.setAtomY(AtomObject, dblCoords.y);
                    mol.setAtomZ(AtomObject, 0.0);
                    molAtoms[AtomObject] = ObjectCount;
                    break;
                }
                case 23: {
                    short t = fp.readShort();
                    AtomType = fp.readShort();
                    break;
                }
                case -24: {
                    short t = fp.readShort();
                    fp.readFully(buff, 0, t - 2);
                    String s = Sketch.convertPascalString(buff);
                    mol.setAtomicNo(AtomObject, Molecule.getAtomicNoFromLabel(s));
                    break;
                }
                case 24: {
                    boolean bNotList = false;
                    if (AtomType == 271) {
                        bNotList = true;
                    }
                    short t = fp.readShort();
                    num = fp.readByte();
                    int[] v = new int[num];
                    for (int i = 0; i < num; ++i) {
                        val = fp.readShort();
                        v[i] = val;
                    }
                    mol.setAtomList(AtomObject, v, bNotList);
                    mol.setFragment(true);
                    break;
                }
                case 25: {
                    short t = fp.readShort();
                    fp.readFully(buff, 0, t - 2);
                    break;
                }
                case 26: {
                    short t = fp.readShort();
                    val = fp.readShort();
                    break;
                }
                case 27: {
                    short t = fp.readShort();
                    byte bval = fp.readByte();
                    mol.setAtomCharge(AtomObject, bval - 16);
                    break;
                }
                case 28: {
                    short t = fp.readShort();
                    byte bval = fp.readByte();
                    mol.setAtomRadical(AtomObject, Sketch.getRadicalType(bval));
                    break;
                }
                case 29: {
                    short t = fp.readShort();
                    byte bval = fp.readByte();
                    if (bval == 0) continue block26;
                    int iso = bval - 19;
                    int atomicNo = mol.getAtomicNo(AtomObject);
                    mol.setAtomMass(AtomObject, Molecule.cRoundedMass[atomicNo] + iso);
                    break;
                }
                case 30: {
                    short t = fp.readShort();
                    byte bval = fp.readByte();
                    break;
                }
                case 39: {
                    short t = fp.readShort();
                    short at1 = fp.readShort();
                    short at2 = fp.readShort();
                    mol.addBond(at1, at2, 1);
                    break;
                }
                case 40: {
                    short t = fp.readShort();
                    byte bval = fp.readByte();
                    Sketch.setBondFeatures(mol, BondObject, bval, 0, 0);
                    break;
                }
                case 41: {
                    short t = fp.readShort();
                    byte bval = fp.readByte();
                    Sketch.setBondFeatures(mol, BondObject, 0, bval, 0);
                    break;
                }
                case 96: {
                    short t = fp.readShort();
                    val = fp.readShort();
                    mol.setAtomMapNo(AtomObject, val, false);
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    short t = fp.readShort();
                    if (t <= 2) continue block26;
                    fp.readFully(buff, 0, t - 2);
                }
            }
        } while (c != -1);
        return false;
    }

    private static int findAtomIndex(StereoMolecule mol, int number, int[] molAtoms) {
        int cnt = molAtoms.length;
        for (int i = 0; i < cnt; ++i) {
            if (molAtoms[i] != number) continue;
            return i;
        }
        return -1;
    }

    private static boolean correctBondAtomNumbering(StereoMolecule mol, int atoms, int bonds, int[] molAtoms) {
        int i;
        int cnt = bonds;
        for (i = 0; i < cnt; ++i) {
            int a1 = Sketch.findAtomIndex(mol, mol.getBondAtom(0, i), molAtoms);
            int a2 = Sketch.findAtomIndex(mol, mol.getBondAtom(1, i), molAtoms);
            if (a1 == -1 || a2 == -1) {
                return false;
            }
            mol.setBondAtom(0, i, a1);
            mol.setBondAtom(1, i, a2);
        }
        cnt = atoms;
        for (i = 0; i < cnt; ++i) {
        }
        return true;
    }

    private static String convertPascalString(byte[] pstr) {
        if (pstr == null || pstr[0] > 255) {
            return null;
        }
        return new String(pstr, 1, (int)pstr[0]);
    }

    private static void setBondFeatures(StereoMolecule mMol, int bond, int bondType, int stereo, int topology) {
        int realBondType = 0;
        boolean isAtomESRAnd = false;
        block0 : switch (stereo) {
            case 1: {
                realBondType = 17;
                break;
            }
            case 3: {
                realBondType = 26;
                break;
            }
            case 4: {
                realBondType = 17;
                isAtomESRAnd = true;
                break;
            }
            case 6: {
                realBondType = 9;
                break;
            }
            default: {
                switch (bondType) {
                    case 1: {
                        realBondType = 1;
                        break block0;
                    }
                    case 2: {
                        realBondType = 2;
                        break block0;
                    }
                    case 3: {
                        realBondType = 4;
                        break block0;
                    }
                    case 4: {
                        realBondType = 64;
                    }
                }
            }
        }
        if (realBondType > 0) {
            mMol.setBondType(bond, realBondType);
        }
        if (isAtomESRAnd) {
            mMol.setAtomESR(mMol.getBondAtom(0, bond), 1, -1);
        }
        int queryFeatures = 0;
        if (bondType > 4) {
            switch (bondType) {
                case 5: {
                    queryFeatures |= 3;
                    break;
                }
                case 6: {
                    queryFeatures |= 9;
                    break;
                }
                case 7: {
                    queryFeatures |= 0xA;
                    break;
                }
                case 8: {
                    queryFeatures |= 0x1F;
                }
            }
        }
        if (topology == 1) {
            queryFeatures |= 0x40;
        }
        if (topology == 2) {
            queryFeatures |= 0x20;
        }
        if (queryFeatures != 0) {
            mMol.setBondQueryFeature(bond, queryFeatures, true);
        }
    }

    private static int getRadicalType(int rad) {
        int radical = 0;
        switch (rad) {
            case 1: {
                radical = 16;
                break;
            }
            case 2: {
                radical = 32;
                break;
            }
            case 3: {
                radical = 48;
                break;
            }
            default: {
                radical = 0;
            }
        }
        return radical;
    }

    private static int readSketchHeader(LittleEndianDataInputStream fp) throws IOException {
        byte c;
        byte[] buff = new byte[1024];
        block5: while ((c = fp.readByte()) != -1) {
            short t;
            switch (c) {
                case 1: {
                    t = fp.readShort();
                    fp.readByte();
                    continue block5;
                }
                case 2: {
                    t = fp.readShort();
                    short val = fp.readShort();
                    return val;
                }
                case 64: 
                case 65: {
                    t = fp.readShort();
                    fp.readFully(buff, 0, t - 2);
                    continue block5;
                }
            }
            t = fp.readShort();
            fp.readFully(buff, 0, t - 2);
            return 0;
        }
        return 0;
    }

    private static int getNextObject(LittleEndianDataInputStream fp) throws IOException {
        byte c;
        byte[] buff = new byte[1024];
        while ((c = fp.readByte()) != -1) {
            short t;
            switch (c) {
                case 3: {
                    t = fp.readShort();
                    byte bval = fp.readByte();
                    return bval;
                }
            }
            t = fp.readShort();
            fp.readFully(buff, 0, t - 2);
        }
        return 0;
    }

    private static String getTextObject(Rect rect, LittleEndianDataInputStream fp) throws IOException {
        byte c;
        String s = null;
        byte[] buff = new byte[1024];
        fp.in.mark(1);
        block5: while ((c = fp.readByte()) != -1) {
            switch (c) {
                case 13: {
                    short t = fp.readShort();
                    rect.left = fp.readShort();
                    rect.top = fp.readShort();
                    rect.right = fp.readShort();
                    rect.bottom = fp.readShort();
                    continue block5;
                }
                case 21: {
                    short t = fp.readShort();
                    s = Sketch.getMDLText(fp);
                    continue block5;
                }
                case 8: 
                case 14: 
                case 48: 
                case 88: {
                    short t = fp.readShort();
                    fp.readFully(buff, 0, t - 2);
                    continue block5;
                }
            }
            fp.in.reset();
            return s;
        }
        return s;
    }

    private static String getMDLText(LittleEndianDataInputStream fp) throws IOException {
        byte[] buff = new byte[1024];
        byte[] text = null;
        fp.readShort();
        fp.readFully(buff, 0, 12);
        int nNumChar = fp.readShort();
        fp.readShort();
        fp.readShort();
        fp.readShort();
        fp.readInt();
        fp.readShort();
        fp.readFully(buff, 0, 32);
        fp.readByte();
        fp.readShort();
        text = new byte[nNumChar];
        for (int i = 0; i < nNumChar; ++i) {
            text[i] = fp.readByte();
            fp.readByte();
        }
        return new String(text);
    }

    private static boolean getArrowObject(Arrow arrow, LittleEndianDataInputStream fp) throws IOException {
        byte c;
        int maxcount = 12;
        int count = 0;
        boolean bFound = false;
        byte[] buff = new byte[1024];
        fp.in.mark(1);
        while ((c = fp.readByte()) != -1) {
            switch (c) {
                case 13: {
                    short t = fp.readShort();
                    arrow.left = fp.readShort();
                    arrow.top = fp.readShort();
                    arrow.right = fp.readShort();
                    arrow.bottom = fp.readShort();
                    bFound = true;
                    break;
                }
                case -36: 
                case -27: 
                case -26: 
                case -25: 
                case 5: 
                case 14: 
                case 56: 
                case 57: 
                case 84: 
                case 88: {
                    short t = fp.readShort();
                    fp.readFully(buff, 0, t - 2);
                    break;
                }
                case 48: {
                    short t = fp.readShort();
                    arrow.attach[0] = fp.readShort();
                    arrow.attach[1] = fp.readShort();
                    break;
                }
                default: {
                    fp.in.reset();
                    return bFound;
                }
            }
            if (++count < maxcount) continue;
            return bFound;
        }
        return bFound;
    }

    private static boolean getLineArrowObject(Arrow arrow, LittleEndianDataInputStream fp) throws IOException {
        byte c;
        int maxcount = 13;
        int count = 0;
        boolean bFound = false;
        byte[] buff = new byte[1024];
        fp.in.mark(1);
        while ((c = fp.readByte()) != -1) {
            switch (c) {
                case 13: {
                    short t = fp.readShort();
                    arrow.left = fp.readShort();
                    arrow.top = fp.readShort();
                    arrow.right = fp.readShort();
                    arrow.bottom = fp.readShort();
                    bFound = true;
                    break;
                }
                case -36: 
                case -27: 
                case -26: 
                case -25: 
                case 5: 
                case 9: 
                case 56: 
                case 57: 
                case 84: 
                case 88: 
                case 89: {
                    short t = fp.readShort();
                    fp.readFully(buff, 0, t - 2);
                    break;
                }
                case 48: {
                    short t = fp.readShort();
                    arrow.attach[0] = fp.readShort();
                    arrow.attach[1] = fp.readShort();
                    break;
                }
                default: {
                    fp.in.reset();
                    return bFound;
                }
            }
            if (++count < maxcount) continue;
            return bFound;
        }
        return bFound;
    }

    private static int writeSketchHeader(LittleEndianDataOutputStream fp, int nObjects) throws IOException {
        Sketch.writeProperty(fp, (byte)1, (byte)4);
        Sketch.writeProperty(fp, (byte)2, (short)nObjects);
        Sketch.Write97(fp);
        int c = 88;
        fp.writeByte(c);
        fp.writeShort(5);
        c = 0;
        fp.writeByte(c);
        fp.writeByte(c);
        fp.writeByte(c);
        c = 89;
        fp.writeByte(c);
        fp.writeShort(5);
        c = 0;
        fp.writeByte(c);
        fp.writeByte(c);
        fp.writeByte(c);
        int nLen = DefaultFontName.length();
        fp.writeByte(11);
        fp.writeShort((short)(nLen + 4 + 2));
        fp.writeByte((byte)nLen);
        fp.writeBytes(DefaultFontName);
        fp.writeShort(120);
        fp.writeByte(0);
        return 1;
    }

    private static int writeProperty(LittleEndianDataOutputStream fp, byte c, byte d) throws IOException {
        fp.writeByte(c);
        fp.writeShort(3);
        fp.writeByte(d);
        return 4;
    }

    private static int writeProperty(LittleEndianDataOutputStream fp, byte c, String sz) throws IOException {
        int nLen = sz.length();
        fp.writeByte(c);
        fp.writeShort((short)(nLen + 1 + 2));
        fp.writeByte((byte)nLen);
        fp.writeBytes(sz);
        return nLen + 5;
    }

    private static int writeProperty(LittleEndianDataOutputStream fp, byte c, short d) throws IOException {
        fp.writeByte(c);
        fp.writeShort(4);
        fp.writeShort(d);
        return 5;
    }

    private static int writeProperty(LittleEndianDataOutputStream fp, byte c, DblPoint d) throws IOException {
        fp.writeByte(c);
        fp.writeShort(10);
        fp.writeFloat(d.x);
        fp.writeFloat(d.y);
        return 11;
    }

    private static int writeProperty(LittleEndianDataOutputStream fp, byte c, Rect r) throws IOException {
        fp.writeByte(c);
        fp.writeShort(10);
        fp.writeShort(r.left);
        fp.writeShort(r.top);
        fp.writeShort(r.right);
        fp.writeShort(r.bottom);
        return 11;
    }

    private static int writeProperty(LittleEndianDataOutputStream fp, byte c) throws IOException {
        fp.writeByte(c);
        fp.writeShort(2);
        return 3;
    }

    private static int Write97(LittleEndianDataOutputStream fp) throws IOException {
        int c = 97;
        fp.writeByte((byte)c);
        fp.writeShort(3);
        c = 0;
        fp.writeByte((byte)c);
        return 4;
    }

    private static void translateMolecule(Molecule m) {
        Rect2D rc = Sketch.getBoundingRectangle(m);
        double dx = 0.0;
        double dy = 0.0;
        if (rc.left < 0.0) {
            dx = 0.0 - rc.left;
        }
        if (rc.top < 0.0) {
            dy = 0.0 - rc.top;
        }
        Sketch.translateMolecule(m, dx, dy);
    }

    private static void translateMolecule(Molecule m, double dx, double dy) {
        int atoms = m.getAllAtoms();
        Sketch.debug("Translate molecule " + dx + " " + dy);
        for (int i = 0; i < atoms; ++i) {
            m.setAtomX(i, m.getAtomX(i) + dx);
            m.setAtomY(i, m.getAtomY(i) + dy);
        }
    }

    private static void translateReaction(Reaction m) {
        Rect2D rc = Sketch.getBoundingRectangle(m);
        double dx = 0.0;
        double dy = 0.0;
        if (rc.left < 0.0) {
            dx = 0.0 - rc.left;
        }
        if (rc.top < 0.0) {
            dy = 0.0 - rc.top;
        }
        int mols = m.getMolecules();
        for (int i = 0; i < mols; ++i) {
            Sketch.translateMolecule(m.getMolecule(i), dx, dy);
        }
    }

    private static void scaleMolecule(Molecule m, int maxsize) {
        Rect2D rc = Sketch.getBoundingRectangle(m);
        double dx = Math.abs(rc.right - rc.left);
        double dy = Math.abs(rc.bottom - rc.top);
        double scale = (double)maxsize / Math.max(dx, dy);
        Sketch.scaleMolecule(m, scale);
    }

    private static void scaleMolecule(Molecule m, double scale) {
        int atoms = m.getAllAtoms();
        for (int i = 0; i < atoms; ++i) {
            m.setAtomX(i, m.getAtomX(i) * scale);
            m.setAtomY(i, m.getAtomY(i) * scale);
            m.setAtomZ(i, m.getAtomZ(i) * scale);
        }
    }

    private static double getScaleFactor(Reaction m) {
        Rect2D rc = Sketch.getBoundingRectangle(m);
        double scale = 4000.0 / (rc.right - rc.left);
        return scale;
    }

    private static void scaleReaction(Reaction m, double scale) {
        Sketch.debug("Scaling Reaciton at " + scale);
        int mols = m.getMolecules();
        for (int i = 0; i < mols; ++i) {
            Sketch.scaleMolecule((Molecule)m.getMolecule(i), scale);
        }
    }

    public static byte[] createSketchFromMol(Molecule m) {
        byte[] buffer = null;
        StereoMolecule mol = new StereoMolecule(m);
        try {
            if (mol.getAllAtoms() > 0) {
                ByteArrayOutputStream b = new ByteArrayOutputStream();
                LittleEndianDataOutputStream fp = new LittleEndianDataOutputStream(b);
                Sketch.writeSketchHeader(fp, 1);
                Sketch.translateMolecule(mol);
                Sketch.scaleMolecule((Molecule)mol, 1440);
                Sketch.writeMoleculeToSketch(fp, mol, 1.0);
                Sketch.writeProperty(fp, (byte)20);
                buffer = b.toByteArray();
            }
        }
        catch (IOException e) {
            System.err.println("Sketch.SketchFromMol() " + e);
        }
        return buffer;
    }

    public static byte[] createSketchFromReaction(Reaction r) throws IOException {
        Rect rp;
        Rect rc;
        StereoMolecule mol;
        int i;
        Reaction rxn = new Reaction(r);
        int reactants = rxn.getReactants();
        int prods = rxn.getProducts();
        int cnt = prods + reactants;
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        LittleEndianDataOutputStream fp = new LittleEndianDataOutputStream(b);
        Sketch.translateReaction(rxn);
        double scale = Sketch.getScaleFactor(rxn);
        Sketch.scaleReaction(rxn, scale);
        Sketch.writeSketchHeader(fp, cnt + reactants - 1 + prods - 1 + 1);
        for (i = 0; i < reactants; ++i) {
            mol = rxn.getMolecule(i);
            rc = Sketch.getBoundingRect(mol);
            Sketch.debug("Drawing reactant " + i + " @ " + rc.left + "," + rc.top + "," + rc.right + "," + rc.bottom);
            Sketch.writeMoleculeToSketch(fp, mol, (short)-1, (short)-1, 1.0);
            if (i >= reactants - 1) continue;
            Rect rn = Sketch.getBoundingRect(rxn.getMolecule(i + 1));
            rp = Sketch.calcMiddleRect(rc, rn, 20);
            Sketch.debug("Writing plus at " + rp.left + "," + rp.top + "," + rp.right + "," + rp.bottom);
            Sketch.writePlus(fp, rp, -1, -1);
        }
        if (reactants > 0 && prods > 0) {
            Rect rr = Sketch.getBoundingRect(rxn.getMolecule(reactants - 1));
            Rect rp2 = Sketch.getBoundingRect(rxn.getMolecule(reactants));
            Rect ra = Sketch.calcMiddleRect(rr, rp2, 1);
            int dx = (rp2.left - rr.right) / 4;
            ra.left = (short)(ra.left - dx);
            ra.right = (short)(ra.right + dx);
            Sketch.writeArrowObject(fp, ra, -1, -1);
        }
        for (i = reactants; i < cnt; ++i) {
            mol = rxn.getMolecule(i);
            rc = Sketch.getBoundingRect(mol);
            Sketch.debug("Drawing prod " + i + " @ " + rc.left + "," + rc.top + "," + rc.right + "," + rc.bottom);
            Sketch.writeMoleculeToSketch(fp, mol, (short)-1, (short)-1, 1.0);
            if (i >= cnt - 1) continue;
            Rect rn = Sketch.getBoundingRect(rxn.getMolecule(i + 1));
            rp = Sketch.calcMiddleRect(rc, rn, 20);
            Sketch.writePlus(fp, rp, -1, -1);
        }
        Sketch.writeProperty(fp, (byte)20);
        return b.toByteArray();
    }

    public static byte[] createSketchFromReactionOLd(Reaction rxn) throws IOException {
        Rect rp;
        Rect rc;
        StereoMolecule mol;
        int i;
        int reactants = rxn.getReactants();
        int prods = rxn.getProducts();
        int cnt = prods + reactants;
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        LittleEndianDataOutputStream fp = new LittleEndianDataOutputStream(b);
        Rect2D rxnRect = Sketch.getBoundingRectangle(rxn);
        float factor = (float)(rxnRect.right - rxnRect.left);
        factor = 5000.0f / factor;
        Sketch.writeSketchHeader(fp, cnt + reactants - 1 + prods - 1 + 1);
        for (i = 0; i < reactants; ++i) {
            mol = rxn.getMolecule(i);
            rc = Sketch.getBoundingRect(mol);
            Sketch.writeMoleculeToSketch(fp, mol, (short)-1, (short)-1, factor);
            if (i >= reactants - 1) continue;
            Rect rn = Sketch.getBoundingRect(rxn.getMolecule(i + 1));
            rp = Sketch.calcMiddleRect(rc, rn, 5);
            Sketch.scaleRect(rp, factor);
            Sketch.writePlus(fp, rp, -1, -1);
        }
        if (reactants > 0 && prods > 0) {
            Rect rr = Sketch.getBoundingRect(rxn.getMolecule(reactants - 1));
            Rect rp2 = Sketch.getBoundingRect(rxn.getMolecule(reactants));
            Rect ra = Sketch.calcMiddleRect(rr, rp2, 1);
            int dx = (rp2.left - rr.right) / 4;
            ra.left = (short)(ra.left - dx);
            ra.right = (short)(ra.right + dx);
            Sketch.scaleRect(ra, factor);
            Sketch.writeArrowObject(fp, ra, -1, -1);
        }
        for (i = reactants; i < cnt; ++i) {
            mol = rxn.getMolecule(i);
            rc = Sketch.getBoundingRect(mol);
            Sketch.writeMoleculeToSketch(fp, mol, (short)-1, (short)-1, factor);
            if (i >= cnt - 1) continue;
            Rect rn = Sketch.getBoundingRect(rxn.getMolecule(i + 1));
            rp = Sketch.calcMiddleRect(rc, rn, 5);
            Sketch.scaleRect(rp, factor);
            Sketch.writePlus(fp, rp, -1, -1);
        }
        Sketch.writeProperty(fp, (byte)20);
        return b.toByteArray();
    }

    private static void scaleRect(Rect rc, double scale) {
        rc.left = (short)((double)rc.left * scale);
        rc.top = (short)((double)rc.top * scale);
        rc.right = (short)((double)rc.right * scale);
        rc.bottom = (short)((double)rc.bottom * scale);
    }

    private static int writeMoleculeToSketch(LittleEndianDataOutputStream fp, Molecule mol, double scale) throws IOException {
        Sketch.writeProperty(fp, (byte)3, (byte)12);
        Sketch.writeSubSketch(fp, mol, scale);
        return 1;
    }

    private static int writeMoleculeToSketch(LittleEndianDataOutputStream fp, Molecule mol, short wFrom, short wTo, double scale) throws IOException {
        Sketch.writeProperty(fp, (byte)3, (byte)12);
        int c = 48;
        fp.writeByte(c);
        fp.writeShort(6);
        fp.writeShort(wFrom);
        fp.writeShort(wTo);
        Sketch.writeSubSketch(fp, mol, scale);
        return 1;
    }

    private static void writeSubSketch(LittleEndianDataOutputStream fp, Molecule mol, double scale) throws IOException {
        int nAtoms = mol.getAllAtoms();
        int nBonds = mol.getAllBonds();
        Sketch.writeProperty(fp, (byte)19);
        Sketch.writeProperty(fp, (byte)2, (short)(nAtoms + nBonds));
        Sketch.Write97(fp);
        for (int i = 0; i < nAtoms; ++i) {
            Sketch.writeAtom(fp, mol, i, scale);
            if (mol.getAtomCharge(i) != 0) {
                Sketch.writeAtomCharge(fp, mol, i);
            }
            if (!mol.isNaturalAbundance(i)) {
                Sketch.writeAtomIsotope(fp, mol, i);
            }
            if (mol.getAtomRadical(i) != 0) {
                Sketch.writeAtomRadical(fp, mol, i);
            }
            if (mol.getAtomList(i) == null) continue;
            Sketch.writeAtomList(fp, mol, i);
        }
        for (int j = 0; j < nBonds; ++j) {
            Sketch.writeProperty(fp, (byte)3, (byte)32);
            Sketch.writeProperty(fp, (byte)5, (byte)7);
            int c = 39;
            fp.writeByte(c);
            fp.writeShort(6);
            fp.writeShort((short)mol.getBondAtom(0, j));
            fp.writeShort((short)mol.getBondAtom(1, j));
            Sketch.writeProperty(fp, (byte)40, (byte)Sketch.getMDLBondType(mol.getBondType(j), false));
            Sketch.writeProperty(fp, (byte)41, (byte)Sketch.getMDLBondType(mol.getBondType(j), true));
        }
        if (mol.getChirality() != 65536 && mol.getChirality() != 131072 && mol.getChirality() != 196608 && mol.getChirality() != 0) {
            Sketch.writeChiral(fp, mol, scale);
        }
        Sketch.writeProperty(fp, (byte)20);
    }

    private static void writeAtom(LittleEndianDataOutputStream fp, Molecule mol, int atom, double scale) throws IOException {
        DblPoint pt = new DblPoint();
        pt.x = (float)(mol.getAtomX(atom) * scale);
        pt.y = (float)(mol.getAtomY(atom) * scale);
        Sketch.writeProperty(fp, (byte)3, (byte)33);
        Sketch.writeProperty(fp, (byte)22, pt);
        Sketch.writeProperty(fp, (byte)-24, mol.getAtomLabel(atom));
        Sketch.writeProperty(fp, (byte)26, (short)(atom + 1));
        Sketch.writeProperty(fp, (byte)37, (short)4);
        Sketch.writeProperty(fp, (byte)-48, (short)15);
        if (mol.getAtomMapNo(atom) != 0) {
            Sketch.writeProperty(fp, (byte)96, (short)mol.getAtomMapNo(atom));
        }
    }

    private static void writeChiral(LittleEndianDataOutputStream fp, Molecule mol, double scale) throws IOException {
        Rect r = Sketch.getBoundingRect(mol);
        Sketch.scaleRect(r, scale);
        Sketch.writeProperty(fp, (byte)3, (byte)19);
        r.left = (short)(r.right + 10);
        r.right = (short)(r.left + 300);
        r.top = (short)(r.top - 50);
        r.bottom = (short)(r.top + 40);
        Sketch.writeProperty(fp, (byte)13, r);
    }

    private static void writeAtomCharge(LittleEndianDataOutputStream fp, Molecule mol, int atom) throws IOException {
        int charge = mol.getAtomCharge(atom);
        Sketch.writeProperty(fp, (byte)27, (byte)(charge + 16));
    }

    private static void writeAtomIsotope(LittleEndianDataOutputStream fp, Molecule mol, int atom) throws IOException {
        int mass = mol.getAtomMass(atom);
        int atomicNo = mol.getAtomicNo(atom);
        int diff = mass - Molecule.cRoundedMass[atomicNo];
        int iso = diff + 19;
        Sketch.writeProperty(fp, (byte)29, (byte)iso);
    }

    private static void writeAtomRadical(LittleEndianDataOutputStream fp, Molecule mol, int atom) throws IOException {
        int rad = 0;
        switch (mol.getAtomRadical(atom)) {
            case 16: {
                rad = 1;
                break;
            }
            case 32: {
                rad = 2;
                break;
            }
            case 48: {
                rad = 3;
                break;
            }
        }
        Sketch.writeProperty(fp, (byte)28, (byte)rad);
    }

    private static void writeAtomList(LittleEndianDataOutputStream fp, Molecule mol, int atom) throws IOException {
        int[] atomList = mol.getAtomList(atom);
        if (atomList != null) {
            boolean notlist = (mol.getAtomQueryFeatures(atom) & 1L) == 1L;
            int size = atomList.length;
            if (size > 0) {
                Sketch.writeProperty(fp, (byte)23, (short)(notlist ? 271 : 270));
                Sketch.writeProperty(fp, (byte)24, (byte)size);
                for (int i = 0; i < size; ++i) {
                    int atomno = atomList[i];
                    fp.writeShort(atomno);
                }
            }
        }
    }

    private static int writeArrowObject(LittleEndianDataOutputStream fp, Rect coords, int wFrom, int wTo) throws IOException {
        Sketch.writeProperty(fp, (byte)3, (byte)4);
        Sketch.writeProperty(fp, (byte)5, (byte)7);
        Sketch.writeProperty(fp, (byte)56, (byte)1);
        Sketch.writeProperty(fp, (byte)57, (byte)1);
        fp.writeByte(-27);
        fp.writeShort(8);
        fp.writeShort(10);
        fp.writeShort(10);
        fp.writeByte(2);
        fp.writeByte(2);
        fp.writeByte(48);
        fp.writeShort(6);
        fp.writeShort(wFrom);
        fp.writeShort(wTo);
        Sketch.writeProperty(fp, (byte)13, coords);
        return 1;
    }

    static int writeMDLText(LittleEndianDataOutputStream buf, String szSource) throws IOException {
        int i;
        int nFontLen = DefaultFontName.length();
        int TextLen = szSource.length();
        int TotalLen = TextLen * 2 + 63;
        buf.writeShort(TotalLen - 2);
        for (i = 0; i < 12; ++i) {
            buf.writeByte(0);
        }
        buf.writeShort(TextLen);
        buf.writeShort(0);
        buf.writeShort(1);
        buf.writeShort(0);
        buf.writeInt(49152);
        buf.writeShort(17);
        buf.writeBytes(DefaultFontName);
        for (i = 0; i < 32 - nFontLen; ++i) {
            buf.writeByte(0);
        }
        buf.writeByte(0);
        buf.writeShort(120);
        for (i = 0; i < TextLen; ++i) {
            buf.writeByte((byte)szSource.charAt(i));
            buf.writeByte(0);
        }
        return TotalLen;
    }

    static int writePlus(LittleEndianDataOutputStream fp, Rect rect, int wFrom, int wTo) throws IOException {
        String s = "+";
        int TextLen = s.length();
        int TotalLen = TextLen * 2 + 63;
        Sketch.writeProperty(fp, (byte)3, (byte)9);
        Sketch.writeProperty(fp, (byte)8);
        fp.writeByte(48);
        fp.writeShort(6);
        fp.writeShort(wFrom);
        fp.writeShort(wTo);
        Sketch.writeProperty(fp, (byte)13, rect);
        fp.writeByte(21);
        fp.writeShort(TotalLen + 2);
        Sketch.writeMDLText(fp, s);
        return 0;
    }

    private static Rect calcMiddleRect(Rect rc, Rect rn, int size) {
        Rect rp = new Rect(rc.right, rc.top, rn.left, rc.bottom);
        Point p = Sketch.getCenter(rp);
        return new Rect((short)(p.x - size / 2), (short)(p.y - size / 2), (short)(p.x + size / 2), (short)(p.y + size / 2));
    }

    static int getMDLBondType(int btype, boolean bstereo) {
        int order = 1;
        int stereo = 0;
        switch (btype) {
            case 1: {
                order = 1;
                stereo = 0;
                break;
            }
            case 2: {
                order = 2;
                stereo = 0;
                break;
            }
            case 4: {
                order = 3;
                stereo = 0;
                break;
            }
            case 9: {
                order = 1;
                stereo = 6;
                break;
            }
            case 17: {
                order = 1;
                stereo = 1;
                break;
            }
            case 26: {
                order = 2;
                stereo = 3;
                break;
            }
            case 64: {
                order = 4;
                stereo = 0;
                break;
            }
            default: {
                order = 1;
                stereo = 0;
            }
        }
        if (bstereo) {
            return stereo;
        }
        return order;
    }

    private static void debug(String s) {
    }
}

