/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.util.ArrayList;
import java.util.Comparator;

public class SortedList<T extends Comparable<? super T>> {
    static final long serialVersionUID = 538314278L;
    private ArrayList<T> mList = new ArrayList();
    private Comparator mComparator;

    public SortedList() {
        this(null);
    }

    public SortedList(Comparator comparator) {
        this.mComparator = comparator;
    }

    public boolean contains(T object) {
        return this.getIndex(object) != -1;
    }

    public boolean equals(SortedList<T> s) {
        if (this.mList.size() != s.mList.size()) {
            return false;
        }
        if (this.mComparator != null) {
            for (int i = 0; i < this.mList.size(); ++i) {
                if (this.mComparator.compare(this.mList.get(i), s.mList.get(i)) == 0) continue;
                return false;
            }
        } else {
            for (int i = 0; i < this.mList.size(); ++i) {
                if (((Comparable)this.mList.get(i)).equals(s.mList.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public int getIndex(T object) {
        int index = this.getIndexOrInsertIndex(object);
        return index < 0 ? -1 : index;
    }

    public int getIndexOrInsertIndex(T object) {
        int vectorSize = this.mList.size();
        if (vectorSize == 0) {
            return -1;
        }
        int index = 1;
        while (2 * index <= vectorSize) {
            index <<= 1;
        }
        int increment = index--;
        while (increment != 0) {
            increment >>= 1;
            if (index >= vectorSize) {
                index -= increment;
                continue;
            }
            int comparison = this.compare(object, (Comparable)this.mList.get(index));
            if (comparison == 0) {
                return index;
            }
            if (increment == 0) break;
            if (comparison < 0) {
                index -= increment;
                continue;
            }
            index += increment;
        }
        if (index < vectorSize && this.compare(object, (Comparable)this.mList.get(index)) > 0) {
            ++index;
        }
        return -(index + 1);
    }

    private int compare(T o1, T o2) {
        return this.mComparator != null ? this.mComparator.compare(o1, o2) : o1.compareTo(o2);
    }

    public int getIndexBelowEqual(T object) {
        int index = this.getIndexOrInsertIndex(object);
        return index < 0 ? -(index + 1) : index;
    }

    public int getIndexAboveEqual(T object) {
        int index = this.getIndexOrInsertIndex(object);
        return index < 0 ? -(index + 1) : index + 1;
    }

    public int add(T object) {
        int index = this.getIndexOrInsertIndex(object);
        if (index < 0) {
            index = -(index + 1);
            this.mList.add(index, object);
        }
        return index;
    }

    public boolean addIfNew(T object) {
        int index = this.getIndexOrInsertIndex(object);
        if (index >= 0) {
            return false;
        }
        index = -(index + 1);
        this.mList.add(index, object);
        return true;
    }

    public int size() {
        return this.mList.size();
    }

    public T get(int index) {
        return (T)(index < 0 ? null : (Comparable)this.mList.get(index));
    }

    public T[] toArray(T[] e) {
        return (Comparable[])this.mList.toArray(e);
    }

    public void remove(int index) {
        this.mList.remove(index);
    }

    public void removeAll() {
        this.mList.clear();
    }
}

