/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.awt.Point;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringFunctions {
    public static final String PAT_WHITESPACE = "[\\s\\u0085\\p{Z}]";
    public static final String PAT_NOT_ALPHANUMERIC = "[^\\p{IsAlphabetic}^\\p{IsDigit}]";
    public static final String[] REGEX_META_CHARACTERS = new String[]{"*", "%", "@", "&", "+", "(", ")"};
    public static final String SEP = "; ";

    public static double[] parse2Double(String s, String sepRegEx) {
        String[] a = s.split(sepRegEx);
        double[] arrDouble = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            arrDouble[i] = Double.parseDouble(a[i]);
        }
        return arrDouble;
    }

    public static String getAppendedSorted(String s1, String s2) {
        StringBuilder sb = new StringBuilder();
        if (s1.compareTo(s2) > 0) {
            sb.append(s1);
            sb.append(s2);
        } else {
            sb.append(s2);
            sb.append(s1);
        }
        return sb.toString();
    }

    public static String min(String s1, String s2) {
        StringBuilder sb = new StringBuilder();
        if (s1.compareTo(s2) < 0) {
            sb.append(s1);
        } else {
            sb.append(s2);
        }
        return sb.toString();
    }

    public static String max(String s1, String s2) {
        StringBuilder sb = new StringBuilder();
        if (s1.compareTo(s2) > 0) {
            sb.append(s1);
        } else {
            sb.append(s2);
        }
        return sb.toString();
    }

    public static int countIntegerInText(String txt) {
        int nInt = 0;
        boolean started = false;
        for (int i = 0; i < txt.length(); ++i) {
            char c = txt.charAt(i);
            if (Character.isDigit(c)) {
                if (started) continue;
                ++nInt;
                started = true;
                continue;
            }
            started = false;
        }
        return nInt;
    }

    public static int countWordInText(String txt) {
        int nWords = 0;
        boolean started = false;
        for (int i = 0; i < txt.length(); ++i) {
            char c = txt.charAt(i);
            if (Character.isLetter(c)) {
                if (started) continue;
                ++nWords;
                started = true;
                continue;
            }
            started = false;
        }
        return nWords;
    }

    public static boolean equal(byte[] b1, byte[] b2) {
        if (b1 == null && b2 == null) {
            return true;
        }
        if (b1 != null && b2 == null) {
            return false;
        }
        if (b1 == null && b2 != null) {
            return false;
        }
        String s1 = new String(b1);
        String s2 = new String(b2);
        return s1.equals(s2);
    }

    public static String encodeHTML(String txt) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < txt.length(); ++i) {
            char c = txt.charAt(i);
            if (c > '\u007f' || c == '\"' || c == '<' || c == '>') {
                sb.append("&#" + c + ";");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static Comparator<String> getComparatorLength() {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int cmp = 0;
                if (o1.length() > o2.length()) {
                    cmp = 1;
                } else if (o1.length() < o2.length()) {
                    cmp = -1;
                }
                return cmp;
            }
        };
    }

    public static DecimalFormat getDecimalFormat(int precision) {
        StringBuilder sbFormPat = new StringBuilder("0");
        if (precision > 0) {
            sbFormPat.append(".");
        }
        for (int i = 0; i < precision; ++i) {
            sbFormPat.append("0");
        }
        return new DecimalFormat(sbFormPat.toString());
    }

    public static List<String> getAllSubStrings(String str, int minsize) {
        TreeSet<String> ts = new TreeSet<String>();
        for (int i = 0; i < str.length(); ++i) {
            for (int j = i + minsize; j < str.length() + 1; ++j) {
                String pat = str.substring(i, j);
                ts.add(pat);
            }
        }
        return new ArrayList<String>(ts);
    }

    public static String getRandom(int min, int max) {
        Random rnd = new Random();
        int s = rnd.nextInt(max - min) + min;
        StringBuilder sb = new StringBuilder();
        int startASCII = 97;
        int endASCII = 123;
        for (int i = 0; i < s; ++i) {
            int c = rnd.nextInt(endASCII - startASCII) + startASCII;
            sb.append(Character.toString((char)c));
        }
        return sb.toString();
    }

    public static int[][] getMatrixFromString(String str, String seperator) {
        ArrayList<Integer> li;
        ArrayList lili = new ArrayList();
        int start = -1;
        int end = -1;
        String strTmp = str;
        int pos = 0;
        while (strTmp.length() > 0 && (start = str.indexOf("[", pos)) != -1) {
            pos = end = StringFunctions.nextClosingBracket(str, start);
            String sVector = str.substring(start + 1, end);
            StringTokenizer st = new StringTokenizer(sVector, seperator);
            li = new ArrayList<Integer>();
            while (st.hasMoreTokens()) {
                String sVal = st.nextToken();
                int v = Integer.parseInt(sVal);
                li.add(v);
            }
            lili.add(li);
        }
        int[][] arr = new int[lili.size()][];
        for (int i = 0; i < lili.size(); ++i) {
            li = (ArrayList<Integer>)lili.get(i);
            int[] a = new int[li.size()];
            for (int j = 0; j < a.length; ++j) {
                a[j] = (Integer)li.get(j);
            }
            arr[i] = a;
        }
        return arr;
    }

    public static String getMaximumOverlap(List<String> li, int minsize) {
        String maxo = "";
        List<String> liPat = StringFunctions.getAllSubStrings(li.get(0), minsize);
        for (int i = 0; i < liPat.size(); ++i) {
            String pat = liPat.get(i);
            Pattern p = Pattern.compile(pat);
            boolean match = true;
            for (int j = 1; j < li.size(); ++j) {
                String line = li.get(j);
                Matcher m = p.matcher(line);
                if (m.find()) continue;
                match = false;
                break;
            }
            if (!match || pat.length() <= maxo.length()) continue;
            maxo = pat;
        }
        return maxo;
    }

    public static String removeCharacter(String str, char c) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == c) continue;
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    public static String removeCharacter(StringBuilder str, char c) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == c) continue;
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    public static int countOccurence(String str, char c) {
        int cc = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            ++cc;
        }
        return cc;
    }

    public static String convertToValidFileNameCharacters(String str) {
        String strFormated = "";
        for (int jj = 0; jj < str.length(); ++jj) {
            char cChar = str.charAt(jj);
            String sInsert = "";
            sInsert = cChar == '\\' || cChar == '/' || cChar == ':' || cChar == '*' || cChar == '?' || cChar == '<' || cChar == '>' ? "-X-" : sInsert + cChar;
            strFormated = strFormated + sInsert;
        }
        return strFormated;
    }

    public static String toStringFileNameCompatible(double d) {
        String str = Double.toString(d);
        str = str.replace('.', '-');
        return str;
    }

    public static String formatToPrintableCharactersOnly(String str) {
        String strFormated = "";
        for (int i = 0; i < str.length(); ++i) {
            char iChar = str.charAt(i);
            if (iChar <= '\u001f' || iChar >= '\u007f') continue;
            strFormated = strFormated + str.charAt(i);
        }
        return strFormated;
    }

    public static String formatToCharactersAndDigits(String str) {
        String regex = "[0-9a-zA-Z ]";
        Pattern pa = Pattern.compile(regex);
        Matcher ma = pa.matcher(str);
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        while (ma.find(pos)) {
            int end;
            MatchResult mr = ma.toMatchResult();
            int start = mr.start();
            pos = end = mr.end();
            sb.append(str.substring(start, end));
        }
        return sb.toString();
    }

    public static String format2DefinedLengthTrailing(String s, int length) {
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() < length) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String format2DefinedLengthLeading(String s, int length) {
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() < length) {
            sb.insert(0, ' ');
        }
        return sb.toString();
    }

    public static String format(String str) {
        return StringFunctions.format(str, '_');
    }

    public static String format(String str, char replacement) {
        StringBuilder sb = new StringBuilder();
        char cLastLetter = '\u0000';
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (Character.isLetterOrDigit(ch)) {
                sb.append(ch);
                cLastLetter = ch;
                continue;
            }
            if (ch == '-') {
                sb.append(ch);
                cLastLetter = ch;
                continue;
            }
            if (cLastLetter == replacement) continue;
            sb.append(replacement);
            cLastLetter = replacement;
        }
        return sb.toString();
    }

    public static String getString(String sLine, String sStart, String sEnd) {
        String str = "";
        int iStart = sLine.indexOf(sStart) + sStart.length();
        int iEnd = sLine.indexOf(sEnd);
        if (iStart > -1 && iEnd > -1) {
            str = sLine.substring(iStart, iEnd);
        }
        return str;
    }

    public static String getStringFromRegEx(String str, String regex) {
        Pattern pa = Pattern.compile(regex);
        Matcher ma = pa.matcher(str);
        int start = -1;
        int end = -1;
        if (!ma.find()) {
            return null;
        }
        MatchResult mr = ma.toMatchResult();
        start = mr.start();
        end = mr.end();
        return str.substring(start, end);
    }

    public static Point getStartEnd(String str, String regex) {
        Pattern pa = Pattern.compile(regex);
        Matcher ma = pa.matcher(str);
        int start = -1;
        int end = -1;
        if (!ma.find()) {
            return null;
        }
        MatchResult mr = ma.toMatchResult();
        start = mr.start();
        end = mr.end();
        return new Point(start, end);
    }

    public static boolean isRegexInString(String str, String regex) {
        Pattern pa = Pattern.compile(regex);
        Matcher ma = pa.matcher(str);
        return ma.find();
    }

    public static String extract(String str, String regex) {
        String substring = "";
        Pattern pa = Pattern.compile(regex);
        Matcher ma = pa.matcher(str);
        if (ma.find()) {
            MatchResult mr = ma.toMatchResult();
            substring = mr.group();
        }
        return substring;
    }

    public static String extractInverse(String str, String regex) {
        String substring = "";
        Pattern pa = Pattern.compile(regex);
        Matcher ma = pa.matcher(str);
        if (ma.find()) {
            MatchResult mr = ma.toMatchResult();
            int start = mr.start();
            int end = mr.end();
            String rest1 = str.substring(0, start);
            String rest2 = str.substring(end);
            substring = rest1 + rest2;
        }
        return substring;
    }

    public static String getString(String sLine, String sStart, String sEnd, int iFromIndex) {
        String str = "";
        int iStart = sLine.indexOf(sStart, iFromIndex);
        int iEnd = sLine.indexOf(sEnd, iStart);
        if (iStart > -1 && iEnd > -1) {
            str = sLine.substring(iStart += sStart.length(), iEnd);
        }
        return str;
    }

    public static List<String> getWordsFormatted(String txt) {
        String txtFormatted = StringFunctions.formatToCharactersAndDigits(txt);
        ArrayList<String> li = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(txtFormatted);
        while (st.hasMoreTokens()) {
            String s = st.nextToken().trim();
            li.add(s);
        }
        return li;
    }

    public static List<String> getWordsFormattedUniqueLowerCase(String txt) {
        String txtFormatted = StringFunctions.formatToCharactersAndDigits(txt);
        HashSet<String> hs = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(txtFormatted);
        while (st.hasMoreTokens()) {
            String s = st.nextToken().trim().toLowerCase();
            hs.add(s);
        }
        return new ArrayList<String>(hs);
    }

    public static List<String> getTokenizedQuoted(String txt) {
        int indexEnd;
        int indexBegin;
        ArrayList<String> li = new ArrayList<String>();
        int startPos = 0;
        while (startPos < txt.length() && (indexBegin = txt.indexOf(34, startPos)) != -1 && (indexEnd = txt.indexOf(34, indexBegin + 1)) != -1) {
            String sub = txt.substring(indexBegin + 1, indexEnd);
            li.add(sub);
            startPos = indexEnd + 1;
        }
        if (startPos == 0) {
            li.add(txt);
        }
        return li;
    }

    public static List<String> getTokenized(String txt, String separator) {
        ArrayList<String> li = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(txt, separator);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken().trim();
            li.add(tok);
        }
        return li;
    }

    public static List<String> getTokenizedBySeperatorRegex(String txt, String regex) {
        List<Point> liSep = StringFunctions.match(txt, regex);
        ArrayList<String> li = new ArrayList<String>();
        if (liSep.size() == 0) {
            li.add(txt);
            return li;
        }
        int start = 0;
        for (int i = 0; i < liSep.size(); ++i) {
            Point p = liSep.get(i);
            String tok = txt.substring(start, p.x);
            li.add(tok.trim());
            start = p.y;
        }
        Point p = liSep.get(liSep.size() - 1);
        start = p.y;
        String tok = txt.substring(start);
        li.add(tok.trim());
        return li;
    }

    public static List<String> getSplittedOverlappingText(List<String> liWords, int lenSubText, int lenOverlap) {
        ArrayList<String> li = new ArrayList<String>();
        int steplen = lenSubText - lenOverlap;
        for (int i = 0; i < liWords.size(); i += steplen) {
            int end = Math.min(i + lenSubText, liWords.size());
            StringBuilder sb = new StringBuilder();
            for (int j = i; j < end; ++j) {
                sb.append(liWords.get(j));
                if (j >= end - 1) continue;
                sb.append(" ");
            }
            li.add(sb.toString());
        }
        return li;
    }

    public static int sizeOf(String s) {
        return 36 + s.length() * 2;
    }

    public static int sizeOf(List<String> l) {
        int n = 0;
        for (String s : l) {
            n += StringFunctions.sizeOf(s);
        }
        return n;
    }

    public static String toString(double[] arr, NumberFormat nf) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            sb.append(nf.format(arr[i]));
            if (i >= arr.length - 1) continue;
            sb.append(SEP);
        }
        return sb.toString();
    }

    public static String toString(float[] arr, NumberFormat nf) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            sb.append(nf.format(arr[i]));
            if (i >= arr.length - 1) continue;
            sb.append(SEP);
        }
        return sb.toString();
    }

    public static String toString(byte[] arr) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            byte v = arr[i];
            sb.append(v);
            if (i >= arr.length - 1) continue;
            sb.append(SEP);
        }
        return sb.toString();
    }

    public static String toString(boolean[] arr) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i]) {
                sb.append(1);
                continue;
            }
            sb.append(0);
        }
        return sb.toString();
    }

    public static String toString(List<Double> li, NumberFormat nf) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < li.size(); ++i) {
            sb.append(nf.format(li.get(i)));
            if (i >= li.size() - 1) continue;
            sb.append(SEP);
        }
        return sb.toString();
    }

    public static String toStringInteger(List<Integer> li, String sep) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < li.size(); ++i) {
            sb.append(li.get(i));
            if (i >= li.size() - 1) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    public static String toString(double[] arr) {
        DecimalFormat nf = new DecimalFormat("0.000");
        return StringFunctions.toString(arr, (NumberFormat)nf);
    }

    public static String toString(int[][] arr, String seperator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            sb.append("[");
            for (int j = 0; j < arr[i].length; ++j) {
                sb.append(arr[i][j]);
                if (j >= arr[i].length - 1) continue;
                sb.append(seperator);
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public static String toString(String[] arr, String seperator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (sb.length() > 0) {
                sb.append(seperator);
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public static String toString(int[] arr, String seperator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (sb.length() > 0) {
                sb.append(seperator);
            }
            sb.append(Integer.toString(arr[i]));
        }
        return sb.toString();
    }

    public static String toStringTabNL(String[][] arr) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[i].length; ++j) {
                sb.append(arr[i][j]);
                if (j >= arr[i].length - 1) continue;
                sb.append("\t");
            }
            if (i >= arr.length - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(Exception ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        String exceptionAsString = sw.toString();
        return exceptionAsString;
    }

    public static String toString(List<String> li) {
        return StringFunctions.toString(li, " ");
    }

    public static String toString(Collection<String> li, String sep) {
        StringBuilder sb = new StringBuilder();
        for (String s : li) {
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String toStringLong(List<Long> li, String sep) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < li.size(); ++i) {
            sb.append(li.get(i));
            if (i >= li.size() - 1) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    public static String toStringInt(List<Integer> li, String sep) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < li.size(); ++i) {
            sb.append(li.get(i));
            if (i >= li.size() - 1) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    public static String toStringInt(List<Integer> li) {
        return StringFunctions.toStringInt(li, SEP);
    }

    public static String toSortedString(List<String> li) {
        StringBuilder sb = new StringBuilder();
        Collections.sort(li);
        for (String s : li) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String toStringBinary(int v) {
        String str = "";
        int len = 32;
        for (int ii = 0; ii < len; ++ii) {
            str = (v & 1) == 1 ? "1 " + str : "0 " + str;
            v >>= 1;
        }
        return str.trim();
    }

    public static String toStringBinary(long v) {
        String str = "";
        int len = 64;
        for (int ii = 0; ii < len; ++ii) {
            str = (v & 1L) == 1L ? "1 " + str : "0 " + str;
            v >>= 1;
        }
        return str.trim();
    }

    public static String toStringHex(String s) {
        String sHex = "";
        for (int i = 0; i < s.length(); ++i) {
            String h = Integer.toHexString(s.charAt(i));
            while (h.length() < 2) {
                h = '0' + h;
            }
            sHex = sHex + h;
        }
        return sHex;
    }

    public static String hex2String(String hex) {
        String s = "";
        for (int i = 0; i < hex.length(); i += 2) {
            String h = hex.substring(i, i + 2);
            char c = (char)Integer.parseInt(h, 16);
            String sC = Character.toString(c);
            s = s + sC;
        }
        return s;
    }

    public static int nextClosingBracket(String txt, int iIndexStart) {
        return StringFunctions.nextClosing(txt, iIndexStart, '[', ']');
    }

    public static String escapeDanglingMetaCharacters(String pattern) {
        for (int i = 0; i < REGEX_META_CHARACTERS.length; ++i) {
            pattern = pattern.replace(REGEX_META_CHARACTERS[i], "\\" + REGEX_META_CHARACTERS[i]);
        }
        return pattern;
    }

    public static final List<Point> match(String str, String regex) {
        Pattern pa = Pattern.compile(regex);
        Matcher ma = pa.matcher(str);
        ArrayList<Point> li = new ArrayList<Point>();
        while (ma.find()) {
            MatchResult mr = ma.toMatchResult();
            int start = mr.start();
            int end = mr.end();
            li.add(new Point(start, end));
        }
        return li;
    }

    public static final Point matchFirst(String str, String regex) {
        Pattern pa = Pattern.compile(regex);
        Matcher ma = pa.matcher(str);
        Point p = null;
        if (ma.find()) {
            MatchResult mr = ma.toMatchResult();
            int start = mr.start();
            int end = mr.end();
            p = new Point(start, end);
        }
        return p;
    }

    public static int nextClosing(String txt, int indexStart, char cOpen, char cClose) {
        int indexBracket = -1;
        int indexOpenBracket = txt.indexOf(cOpen, indexStart);
        int numberOpenBrackets = 1;
        for (int i = indexOpenBracket + 1; i < txt.length(); ++i) {
            if (txt.charAt(i) == cOpen) {
                ++numberOpenBrackets;
            } else if (txt.charAt(i) == cClose) {
                --numberOpenBrackets;
            }
            if (numberOpenBrackets != 0) continue;
            indexBracket = i;
            break;
        }
        return indexBracket;
    }

    public static boolean isAllLetter(String s) {
        for (char c : s.toCharArray()) {
            if (Character.isLetter(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllUpperCase(String s) {
        for (char c : s.toCharArray()) {
            if (!Character.isLetter(c) || !Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllLowerCase(String s) {
        for (char c : s.toCharArray()) {
            if (!Character.isLetter(c) || !Character.isUpperCase(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsUpperCase(String s) {
        for (char c : s.toCharArray()) {
            if (!Character.isLetter(c) || !Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsLowerCase(String s) {
        for (char c : s.toCharArray()) {
            if (!Character.isLetter(c) || !Character.isLowerCase(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCapitalizedWord(String s) {
        if (s.length() < 1) {
            return false;
        }
        if (!Character.isUpperCase(s.charAt(0))) {
            return false;
        }
        if (s.length() < 2) {
            return true;
        }
        String sub = s.substring(1);
        for (char c : sub.toCharArray()) {
            if (Character.isLetter(c) && !Character.isUpperCase(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpperAndLowerCase(String s) {
        boolean upper = false;
        boolean lower = false;
        for (char c : s.toCharArray()) {
            if (Character.isUpperCase(c)) {
                upper = true;
            } else if (Character.isLowerCase(c)) {
                lower = true;
            }
            if (upper && lower) break;
        }
        return upper && lower;
    }

    public static boolean isMissingParenthesis(String name) {
        int ccOpen = 0;
        int ccClose = 0;
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == '(') {
                ++ccOpen;
                continue;
            }
            if (name.charAt(i) != ')') continue;
            ++ccClose;
        }
        return ccOpen != ccClose;
    }

    public static void main(String[] args) {
        String sLine = "Pos3ition: 8 15 StartName:XXXEn7890dName0";
        System.out.println(StringFunctions.countWordInText(sLine));
    }
}

