/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util.datamodel;

import com.actelion.research.util.BurtleHasher;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;

public class IntArray
implements Serializable {
    private static final int START_CAPACITY = 32;
    private static final int MAX_DELTA_CAPACITY = (int)Math.pow(2.0, 20.0);
    private int[] data;
    private int size;
    private int delta_capacity;
    private int hash;

    public IntArray() {
        this.init(32);
    }

    public IntArray(int capacity) {
        this.init(capacity);
    }

    public IntArray(int[] a) {
        this.data = a;
        this.size = this.data.length;
        this.delta_capacity = this.size / 2;
        this.calculateHashCode();
    }

    public IntArray(IntArray ia) {
        this.init(ia.data.length);
        System.arraycopy(ia.data, 0, this.data, 0, ia.size);
        this.size = ia.size;
        this.delta_capacity = ia.delta_capacity;
        this.hash = ia.hash;
    }

    private void init(int capacity) {
        this.data = new int[capacity];
        this.delta_capacity = capacity / 2;
        this.size = 0;
        this.hash = -1;
    }

    public void calculateHashCode() {
        int h;
        this.hash = h = BurtleHasher.hashlittle(this.data, 13L, this.size);
    }

    public int getCapacity() {
        return this.data.length;
    }

    public void removeValue(int value) {
        int ccFound = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            ++ccFound;
        }
        if (ccFound == 0) {
            return;
        }
        int newlen = this.size - ccFound;
        int[] arr = new int[newlen];
        int cc = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == value) continue;
            arr[cc++] = this.data[i];
        }
        this.data = arr;
        this.size = newlen;
    }

    public boolean equals(Object o) {
        IntArray ia = (IntArray)o;
        boolean eq = true;
        if (this.length() != ia.length()) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == ia.data[i]) continue;
            eq = false;
            break;
        }
        return eq;
    }

    public int hashCode() {
        return this.hash;
    }

    public int get(int i) {
        return this.data[i];
    }

    public int[] get() {
        this.resize(this.size);
        return this.data;
    }

    public int add(int v) {
        this.facultativeResize();
        this.data[this.size] = v;
        int index = this.size++;
        this.hash = -1;
        return index;
    }

    public int max() {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] <= max) continue;
            max = this.data[i];
        }
        return max;
    }

    private void facultativeResize() {
        if (this.size == this.data.length) {
            long newsize = (long)this.data.length + (long)this.delta_capacity;
            this.resize(newsize);
            if (this.delta_capacity < MAX_DELTA_CAPACITY) {
                this.delta_capacity *= 2;
            }
        }
    }

    public void add(int[] a) {
        int newsize = this.size + a.length;
        if (newsize > this.data.length) {
            this.resize(newsize);
        }
        System.arraycopy(a, 0, this.data, this.size, a.length);
        this.size = newsize;
        this.hash = -1;
    }

    public void add(List<Integer> li) {
        for (int v : li) {
            this.add(v);
        }
        this.calculateHashCode();
    }

    public void add(byte[] a) {
        for (int i = 0; i < a.length; ++i) {
            this.add(a[i]);
        }
    }

    public int length() {
        return this.size;
    }

    public int removeLast() {
        int last = this.get(this.size - 1);
        --this.size;
        return last;
    }

    private void resize(long newlen) {
        if ((long)this.data.length == newlen) {
            return;
        }
        int intNewlen = 0;
        long max = Integer.MAX_VALUE;
        if (newlen >= max) {
            intNewlen = Integer.MAX_VALUE;
            new RuntimeException("Warning! Maximum length of integer array reached.").printStackTrace();
        } else {
            intNewlen = (int)newlen;
        }
        int[] arr = new int[intNewlen];
        System.arraycopy(this.data, 0, arr, 0, Math.min(this.data.length, intNewlen));
        this.data = arr;
    }

    public void set(int index, int value) {
        this.data[index] = value;
    }

    public List<Integer> toList() {
        ArrayList<Integer> li = new ArrayList<Integer>(this.length());
        for (int i = 0; i < this.length(); ++i) {
            li.add(this.get(i));
        }
        return li;
    }

    public void clear() {
        this.reset();
    }

    public void reset() {
        this.size = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        DecimalFormat nf = new DecimalFormat("0");
        for (int i = 0; i < this.size; ++i) {
            sb.append(nf.format(this.data[i]) + " ");
        }
        return sb.toString();
    }

    public String toString(String seperator) {
        int types = this.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < types; ++i) {
            sb.append(this.get(i));
            if (i >= types - 1) continue;
            sb.append(seperator);
        }
        return sb.toString();
    }

    public static IntArray read(InputStream s) throws IOException {
        int size = IntArray.parseInteger(s);
        int delta_capacity = IntArray.parseInteger(s);
        int hash = IntArray.parseInteger(s);
        int[] a = new int[size];
        for (int i = 0; i < size; ++i) {
            a[i] = IntArray.parseInteger(s);
        }
        IntArray ia = new IntArray();
        ia.data = a;
        ia.size = size;
        ia.delta_capacity = delta_capacity;
        ia.hash = hash;
        return ia;
    }

    public String write2String() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.size);
        sb.append(" ");
        sb.append(this.delta_capacity);
        sb.append(" ");
        sb.append(this.hash);
        sb.append(" ");
        sb.append(this.toString());
        return sb.toString();
    }

    public static int parseInteger(InputStream s) throws IOException {
        int i = -1;
        StringBuilder sb = new StringBuilder();
        while (32 != (i = s.read()) && i != -1) {
            sb.append((char)i);
        }
        int val = Integer.parseInt(sb.toString());
        return val;
    }

    public void sort() {
        this.resize(this.size);
        Arrays.sort(this.data);
    }

    public static void shuffle(IntArray arr) {
        Random rnd = new Random();
        int cycles = 7;
        int size = arr.length();
        for (int i = 0; i < cycles; ++i) {
            for (int j = 0; j < size; ++j) {
                int dest = rnd.nextInt(size);
                if (dest == j) continue;
                int v = arr.get(j);
                arr.set(j, arr.get(dest));
                arr.set(dest, v);
            }
        }
    }

    public static IntArray read(String l) {
        IntArray ia = new IntArray();
        StringTokenizer st = new StringTokenizer(l, ", ;");
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            int i = Integer.parseInt(t);
            ia.add(i);
        }
        return ia;
    }

    public static boolean equals(int[] a, int[] b) {
        boolean eq = true;
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            eq = false;
            break;
        }
        return eq;
    }

    public static List<Integer> toList(int[] a) {
        ArrayList<Integer> li = new ArrayList<Integer>(a.length);
        for (int i = 0; i < a.length; ++i) {
            li.add(a[i]);
        }
        return li;
    }

    public static int[] resize(int[] data, int newlen) {
        int[] arr = null;
        if (data.length == newlen) {
            return arr;
        }
        int intNewlen = 0;
        long max = Integer.MAX_VALUE;
        if ((long)newlen >= max) {
            intNewlen = Integer.MAX_VALUE;
            new RuntimeException("Warning! Maximum length of integer array reached.").printStackTrace();
        } else {
            intNewlen = newlen;
        }
        arr = new int[intNewlen];
        System.arraycopy(data, 0, arr, 0, Math.min(data.length, intNewlen));
        return arr;
    }
}

