/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util.datamodel;

import com.actelion.research.util.BurtleHasher;
import com.actelion.research.util.datamodel.IntArray;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class IntVec
implements Comparable<IntVec> {
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    public static final int LEN_INTEGER_BYTES = 4;
    public static final int MASK_FIRST_BYTE = 255;
    public static final int MASK_SEC_BYTE = 65280;
    public static final int MASK_THIRD_BYTE = 0xFF0000;
    public static final int MASK_FOURTH_BYTE = -16777216;
    public static final int MASK_INVERSE_FIRST_BYTE = -256;
    public static final int MASK_INVERSE_SEC_BYTE = -65281;
    public static final int MASK_INVERSE_THIRD_BYTE = -16711681;
    public static final int MASK_INVERSE_FOURTH_BYTE = 0xFFFFFF;
    private int[] data;
    private int hash;

    public IntVec() {
    }

    public IntVec(IntVec iv) {
        this(iv.data);
    }

    public IntVec(int size) {
        this.init();
        this.data = new int[size];
    }

    public IntVec(int[] arr) {
        this.init();
        this.data = new int[arr.length];
        System.arraycopy(arr, 0, this.data, 0, arr.length);
        this.calculateHashCode();
    }

    public IntVec(int[] arr, boolean binary) {
        this.init();
        int len = (arr.length + 32 - 1) / 32;
        this.data = new int[len];
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == 1) {
                this.setBit(i);
                continue;
            }
            if (arr[i] <= 1 && arr[i] >= 0) continue;
            throw new RuntimeException("abs(value) in array larger than one, no binary data");
        }
    }

    public IntVec(boolean[] arr) {
        this.init();
        int len = (arr.length + 32 - 1) / 32;
        this.data = new int[len];
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i]) continue;
            this.setBit(i);
        }
    }

    public IntVec(List<Integer> vec) {
        this.init();
        this.data = new int[vec.size()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = vec.get(i);
        }
    }

    public IntVec add(IntVec dvVec) {
        IntVec ret = new IntVec(this.data.length);
        if (this.data.length != dvVec.data.length) {
            throw new RuntimeException();
        }
        for (int ii = 0; ii < ret.data.length; ++ii) {
            ret.data[ii] = this.data[ii] + dvVec.data[ii];
        }
        return ret;
    }

    public void copy(IntVec ivOrigin) {
        System.arraycopy(ivOrigin.data, 0, this.data, 0, this.data.length);
    }

    public void clear() {
        for (int ii = 0; ii < this.data.length; ++ii) {
            this.data[ii] = 0;
        }
        this.hash = -1;
    }

    @Override
    public int compareTo(IntVec iv) {
        int cmp = 0;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] > iv.data[i]) {
                cmp = 1;
                break;
            }
            if (this.data[i] >= iv.data[i]) continue;
            cmp = -1;
            break;
        }
        return cmp;
    }

    public static IntVec devide(IntVec iv1, IntVec iv2) {
        IntVec dVecDev = new IntVec(iv1.data.length);
        for (int i = 0; i < iv1.data.length; ++i) {
            dVecDev.data[i] = iv1.data[i] / iv2.data[i];
        }
        return dVecDev;
    }

    public boolean equal(IntVec iv) {
        boolean eq = true;
        if (this.size() != iv.size()) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == iv.data[i]) continue;
            eq = false;
            break;
        }
        return eq;
    }

    public boolean equals(Object o) {
        return this.equal((IntVec)o);
    }

    public static double getEuclidDist(IntVec iv1, IntVec iv2) {
        double dDist = 0.0;
        double dSum = 0.0;
        for (int i = 0; i < iv1.data.length; ++i) {
            dSum += (double)((iv1.data[i] - iv2.data[i]) * (iv1.data[i] - iv2.data[i]));
        }
        dDist = Math.sqrt(dSum);
        return dDist;
    }

    public static double getEuclidDistBitWise(IntVec iv1, IntVec iv2) {
        int bitsXOR = 0;
        for (int i = 0; i < iv1.data.length; ++i) {
            bitsXOR += Integer.bitCount(iv1.data[i] ^ iv2.data[i]);
        }
        return Math.sqrt(bitsXOR);
    }

    public static double getEuclidDistFast(IntVec dVec1, IntVec dVec2) throws ArrayIndexOutOfBoundsException {
        if (dVec1.data.length != dVec2.data.length) {
            String sMessage = "Length double vector 1: " + dVec1.data.length + "Length double vector 2: " + dVec2.data.length + "\n";
            throw new ArrayIndexOutOfBoundsException(sMessage);
        }
        double dSum = 0.0;
        for (int i = 0; i < dVec1.data.length; ++i) {
            dSum += (double)((dVec1.data[i] - dVec2.data[i]) * (dVec1.data[i] - dVec2.data[i]));
        }
        return dSum;
    }

    public static IntVec OR(IntVec iv1, IntVec iv2) {
        IntVec iv = new IntVec(iv1.data.length);
        for (int i = 0; i < iv1.data.length; ++i) {
            iv.data[i] = iv1.data[i] | iv2.data[i];
        }
        iv.calculateHashCode();
        return iv;
    }

    public static IntVec OR(List<IntVec> li) {
        IntVec iv = new IntVec(li.get(0));
        int len = iv.data.length;
        for (int i = 1; i < li.size(); ++i) {
            for (int j = 0; j < len; ++j) {
                iv.data[j] = iv.data[j] | li.get((int)i).data[j];
            }
        }
        iv.calculateHashCode();
        return iv;
    }

    public static IntVec AND(IntVec iv1, IntVec iv2) {
        IntVec iv = new IntVec(iv1.data.length);
        for (int i = 0; i < iv1.data.length; ++i) {
            iv.data[i] = iv1.data[i] & iv2.data[i];
        }
        iv.calculateHashCode();
        return iv;
    }

    public static int[] getRND(int size) {
        int[] arr = new int[size];
        return arr;
    }

    public int[] get() {
        return this.data;
    }

    public int getByte(int indexBytes) {
        return IntVec.getByte(this.data, indexBytes);
    }

    public static int getByte(int[] data, int indexBytes) {
        int val = 0;
        int ind = indexBytes / 4;
        int indInInt = indexBytes % 4;
        switch (indInInt) {
            case 3: {
                val = data[ind] & 0xFF;
                break;
            }
            case 2: {
                val = data[ind] & 0xFF00;
                val >>>= 8;
                break;
            }
            case 1: {
                val = data[ind] & 0xFF0000;
                val >>>= 16;
                break;
            }
            case 0: {
                val = data[ind] & 0xFF000000;
                val >>>= 24;
            }
        }
        return val;
    }

    public byte[] getByteVec() {
        return IntVec.getByteVec(this.data);
    }

    public static byte[] getByteVec(int intVal) {
        byte[] arr = new byte[4];
        int val = 0;
        arr[0] = (byte)(intVal & 0xFF);
        val = intVal & 0xFF00;
        arr[1] = (byte)(val >>> 8);
        val = intVal & 0xFF0000;
        arr[2] = (byte)(val >>> 16);
        val = intVal & 0xFF000000;
        arr[3] = (byte)(val >>> 24);
        return arr;
    }

    public static byte[] getByteVec(int[] a) {
        int fac = 4;
        byte[] arr = new byte[a.length * fac];
        for (int i = 0; i < a.length; ++i) {
            int intVal = a[i];
            int val = 0;
            int indexByteVec = i * fac;
            arr[indexByteVec + 0] = (byte)(intVal & 0xFF);
            val = intVal & 0xFF00;
            arr[indexByteVec + 1] = (byte)(val >>> 8);
            val = intVal & 0xFF0000;
            arr[indexByteVec + 2] = (byte)(val >>> 16);
            val = intVal & 0xFF000000;
            arr[indexByteVec + 3] = (byte)(val >>> 24);
        }
        return arr;
    }

    public static int getSizeForBits(int bits) {
        int sizeInteger = 0;
        sizeInteger = (bits + 32 - 1) / 32;
        return sizeInteger;
    }

    public static int getNumberAbove(int[] a, int val) {
        int n = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] <= val) continue;
            ++n;
        }
        return n;
    }

    public static int getInt(byte[] arr) {
        int t1 = 0xFF & arr[0];
        int t2 = 0xFF & arr[1];
        int t3 = 0xFF & arr[2];
        int t4 = 0xFF & arr[3];
        int v1 = t1;
        int v2 = v1 | (t2 <<= 8);
        int v3 = v2 | (t3 <<= 16);
        int v4 = v3 | (t4 <<= 24);
        return v4;
    }

    public int getBitsSet() {
        int sum = 0;
        for (int i = 0; i < this.data.length; ++i) {
            sum += Integer.bitCount(this.data[i]);
        }
        return sum;
    }

    public int[] getByteWise() {
        int bytes = this.size() * 4;
        int[] arr = new int[bytes];
        for (int i = 0; i < bytes; ++i) {
            arr[i] = this.getByte(i);
        }
        return arr;
    }

    public int[] getBitWise() {
        int bits = this.size() * 32;
        int[] arr = new int[bits];
        for (int i = 0; i < bits; ++i) {
            arr[i] = this.isBitSet(i) ? 1 : 0;
        }
        return arr;
    }

    public static int[] extractForGivenResolution(IntVec iv, int nValues, int bitsResolution) {
        int[] a = new int[nValues];
        int indexIntVec = 0;
        for (int i = 0; i < nValues; ++i) {
            int v = 0;
            for (int j = 0; j < bitsResolution; ++j) {
                if (!iv.isBitSet(indexIntVec++)) continue;
                v |= 1 << j;
            }
            a[i] = v;
        }
        return a;
    }

    public boolean allFieldsEquals(int v) {
        boolean b = true;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == v) continue;
            b = false;
            break;
        }
        return b;
    }

    public int get(int col) {
        return this.data[col];
    }

    public double getNorm() {
        double dNorm = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            dNorm += (double)(this.data[i] * this.data[i]);
        }
        dNorm = Math.sqrt(dNorm);
        return dNorm;
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.calculateHashCode();
        }
        return this.hash;
    }

    public void calculateHashCode() {
        this.hash = this.data.length == 1 ? this.data[0] : BurtleHasher.hashlittle(this.data, 13L);
    }

    public static double getCosine(IntVec iv1, IntVec iv2) {
        double ab = 0.0;
        double a = 0.0;
        double b = 0.0;
        for (int i = 0; i < iv1.data.length; ++i) {
            ab += (double)(iv1.data[i] * iv2.data[i]);
            a += (double)(iv1.data[i] * iv1.data[i]);
            b += (double)(iv2.data[i] * iv2.data[i]);
        }
        double c = Math.sqrt(ab) / (Math.sqrt(a) * Math.sqrt(b));
        return c;
    }

    public static double cubicDistance(IntVec dVec1, IntVec dVec2) {
        double dSum = 0.0;
        for (int i = 0; i < dVec1.data.length; ++i) {
            double dDist = Math.abs(dVec1.data[i] - dVec2.data[i]);
            dSum += dDist * dDist * dDist;
        }
        return dSum;
    }

    public static int calculateHashCode(IntVec iv) {
        int h = 0;
        int l = iv.size() * 4;
        byte[] a = new byte[l];
        for (int i = 0; i < l; ++i) {
            a[i] = (byte)iv.getByte(i);
        }
        h = BurtleHasher.hashlittle(a, 13L);
        return h;
    }

    private static int[] convert(String sLine) {
        StringTokenizer st = new StringTokenizer(sLine);
        int[] dArray = new int[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            String sNumber = st.nextToken();
            sNumber = sNumber.replaceAll("'", "");
            try {
                int val;
                dArray[i] = val = (int)Double.parseDouble(sNumber);
            }
            catch (NumberFormatException ex1) {
                System.err.println("No number: " + sNumber + ".");
                ex1.printStackTrace();
            }
            ++i;
        }
        return dArray;
    }

    public static IntVec readBitStringDense(String s) {
        int bits = s.length();
        if (bits % 32 != 0) {
            throw new RuntimeException("Wrong size (" + bits + ") of string for coversion.");
        }
        int size = bits / 32;
        IntVec iv = new IntVec(size);
        for (int i = 0; i < bits; ++i) {
            int index = bits - i - 1;
            if (s.charAt(index) == '1') {
                iv.setBit(i);
                continue;
            }
            if (s.charAt(index) == '0') continue;
            throw new RuntimeException("Illegal character.");
        }
        return iv;
    }

    private void init() {
        this.hash = -1;
    }

    public static double manhattanBlockDistance(IntVec iv1, IntVec iv2) {
        double dDist = 0.0;
        double dSum = 0.0;
        for (int i = 0; i < iv1.data.length; ++i) {
            dSum += (double)Math.abs(iv1.data[i] - iv2.data[i]);
        }
        dDist = Math.sqrt(dSum);
        return dDist;
    }

    public IntVec mult(double factor) {
        IntVec ret = new IntVec(this.data.length);
        for (int iv = 0; iv < ret.data.length; ++iv) {
            ret.data[iv] = (int)((double)this.data[iv] * factor);
        }
        return ret;
    }

    public static double mult(IntVec iv1, IntVec iv2) {
        double dSum = 0.0;
        for (int i = 0; i < iv1.data.length; ++i) {
            dSum += (double)(iv1.data[i] * iv2.data[i]);
        }
        return dSum;
    }

    public static double mult(int[] a, int[] b) {
        double dSum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            dSum += (double)(a[i] * b[i]);
        }
        return dSum;
    }

    public static double multByteWise(IntVec iv1, IntVec iv2) {
        return IntVec.multByteWise(iv1.data, iv2.data);
    }

    public static double multByteWise(int[] iv1, int[] iv2) {
        double dSum = 0.0;
        for (int i = 0; i < iv1.length; ++i) {
            int b11 = iv1[i] & 0xFF;
            int b12 = iv2[i] & 0xFF;
            int b21 = (iv1[i] & 0xFF00) >> 8;
            int b22 = (iv2[i] & 0xFF00) >> 8;
            int b31 = (iv1[i] & 0xFF0000) >> 16;
            int b32 = (iv2[i] & 0xFF0000) >> 16;
            int b41 = (iv1[i] & 0xFF000000) >> 24;
            int b42 = (iv2[i] & 0xFF000000) >> 24;
            dSum += (double)(b11 * b12 + b21 * b22 + b31 * b32 + b41 * b42);
        }
        return dSum;
    }

    public static double getSimilarityBytewiseOverlap(int[] a1, int[] a2) {
        float similarity = 0.0f;
        float ccOverlap = 0.0f;
        float ccTotal = 0.0f;
        for (int i = 0; i < a1.length; ++i) {
            int b11 = a1[i] & 0xFF;
            int b12 = a2[i] & 0xFF;
            int b21 = (a1[i] & 0xFF00) >>> 8;
            int b22 = (a2[i] & 0xFF00) >>> 8;
            int b31 = (a1[i] & 0xFF0000) >>> 16;
            int b32 = (a2[i] & 0xFF0000) >>> 16;
            int b41 = (a1[i] & 0xFF000000) >>> 24;
            int b42 = (a2[i] & 0xFF000000) >>> 24;
            ccOverlap += (float)Math.min(b11, b12);
            ccTotal += (float)Math.max(b11, b12);
            ccOverlap += (float)Math.min(b21, b22);
            ccTotal += (float)Math.max(b21, b22);
            ccOverlap += (float)Math.min(b31, b32);
            ccTotal += (float)Math.max(b31, b32);
            ccOverlap += (float)Math.min(b41, b42);
            ccTotal += (float)Math.max(b41, b42);
        }
        similarity = ccOverlap / ccTotal;
        return similarity;
    }

    public static IntVec subtractByteWise(IntVec iv1, IntVec iv2) {
        IntVec ivSub = new IntVec(iv1.size());
        for (int i = 0; i < iv1.sizeBytes(); ++i) {
            int sub = iv1.getByte(i) - iv2.getByte(i);
            ivSub.setByte(i, sub);
        }
        return ivSub;
    }

    public static IntVec maskByteWise(IntVec mask, IntVec query) {
        IntVec ivSub = new IntVec(query);
        for (int i = 0; i < mask.sizeBytes(); ++i) {
            if (mask.getByte(i) <= 0) continue;
            ivSub.setByte(i, 0);
        }
        return ivSub;
    }

    public static IntVec multEl(IntVec iv1, IntVec iv2) {
        IntVec dVecMult = new IntVec(iv1.data.length);
        for (int i = 0; i < iv1.data.length; ++i) {
            dVecMult.data[i] = iv1.data[i] * iv2.data[i];
        }
        return dVecMult;
    }

    public void norm2One() {
        double norm = this.getNorm();
        int i = 0;
        while (i < this.data.length) {
            int n = i++;
            this.data[n] = (int)((double)this.data[n] / norm);
        }
        this.hash = -1;
    }

    public static IntVec minus(IntVec dVec1, IntVec dVec2) {
        IntVec dVecSub = new IntVec(dVec1.data.length);
        for (int i = 0; i < dVec1.data.length; ++i) {
            dVecSub.data[i] = dVec1.data[i] - dVec2.data[i];
        }
        return dVecSub;
    }

    public void read(String s) {
        this.data = IntVec.convert(s);
        this.hash = -1;
    }

    public static IntVec[] read(File file) {
        ArrayList<IntVec> li = new ArrayList<IntVec>();
        try {
            BufferedReader buf = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while (buf.ready()) {
                String s = buf.readLine();
                int[] a = IntVec.convert(s);
                IntVec v = new IntVec(a);
                li.add(v);
            }
            buf.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        IntVec[] arrIV = new IntVec[li.size()];
        for (int i = 0; i < arrIV.length; ++i) {
            arrIV[i] = (IntVec)li.get(i);
        }
        return arrIV;
    }

    public void reduce(List<Integer> liIndices) {
        int[] arr = new int[liIndices.size()];
        for (int i = 0; i < liIndices.size(); ++i) {
            int iIndex = liIndices.get(i);
            arr[i] = this.data[iIndex];
        }
        this.data = arr;
    }

    public void resize(int newlen) {
        if (this.data.length == newlen) {
            return;
        }
        int intNewlen = 0;
        long max = Integer.MAX_VALUE;
        if ((long)newlen >= max) {
            intNewlen = Integer.MAX_VALUE;
            new RuntimeException("Warning! Maximum length of integer array reached.").printStackTrace();
        } else {
            intNewlen = newlen;
        }
        int[] arr = new int[intNewlen];
        System.arraycopy(this.data, 0, arr, 0, Math.min(this.data.length, intNewlen));
        this.data = arr;
    }

    public static IntVec plus(IntVec dVec1, IntVec dVec2) {
        IntVec dVecSum = new IntVec(dVec1.data.length);
        for (int i = 0; i < dVec1.data.length; ++i) {
            dVecSum.data[i] = dVec1.data[i] + dVec2.data[i];
        }
        return dVecSum;
    }

    public void set(int val) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = val;
        }
        this.hash = -1;
    }

    public void set(IntVec v) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = v.data[i];
        }
        this.hash = -1;
    }

    public void set(int col, int val) {
        this.data[col] = val;
        this.hash = -1;
    }

    public void setBit(int i) {
        int ind = this.data.length - i / 32 - 1;
        int indInInt = i % 32;
        int mask = 1;
        this.data[ind] = this.data[ind] | (mask <<= indInInt);
        this.hash = -1;
    }

    public void unsetBit(int i) {
        int ind = this.data.length - i / 32 - 1;
        int indInInt = i % 32;
        int mask = 1;
        this.data[ind] = this.data[ind] & ~(mask <<= indInInt);
        this.hash = -1;
    }

    public boolean isValidBitIndex(int i) {
        boolean valid = false;
        int ind = i / 32;
        if (ind < this.data.length) {
            valid = true;
        }
        return valid;
    }

    public void setByte(int i, int val) {
        IntVec.setByte(this.data, i, val);
        this.hash = -1;
    }

    public static void setBytes(int[] data, int val) {
        int n = data.length * 4;
        for (int i = 0; i < n; ++i) {
            IntVec.setByte(data, i, val);
        }
    }

    public static void setByte(int[] data, int i, int val) {
        int ind = i / 4;
        int indInInt = i % 4;
        int mask = 0;
        switch (indInInt) {
            case 3: {
                mask = -256;
                break;
            }
            case 2: {
                mask = -65281;
                val <<= 8;
                break;
            }
            case 1: {
                mask = -16711681;
                val <<= 16;
                break;
            }
            case 0: {
                mask = 0xFFFFFF;
                val <<= 24;
            }
        }
        data[ind] = data[ind] & mask | val;
    }

    public List<Integer> getIndicesBitsSet() {
        ArrayList<Integer> li = new ArrayList<Integer>();
        for (int i = 0; i < this.sizeBits(); ++i) {
            if (!this.isBitSet(i)) continue;
            li.add(new Integer(i));
        }
        return li;
    }

    public boolean isBitSet(int i) {
        return this.isBitSetNotStatic(this.data, i);
    }

    private boolean isBitSetNotStatic(int[] a, int i) {
        int ind = a.length - i / 32 - 1;
        int indInInt = i % 32;
        int mask = 1;
        return (a[ind] & (mask <<= indInInt)) != 0;
    }

    public void switchBit(int i) {
        int ind = this.data.length - i / 32 - 1;
        int indInInt = i % 32;
        int mask = 1;
        this.data[ind] = (this.data[ind] & (mask <<= indInInt)) != 0 ? this.data[ind] & ~mask : this.data[ind] | mask;
        this.hash = -1;
    }

    public void setBits(int iStart, int num) {
        for (int i = iStart; i < iStart + num; ++i) {
            this.setBit(i);
        }
    }

    public void setBytes(int iStart, int num, int val) {
        for (int i = iStart; i < iStart + num; ++i) {
            this.setByte(i, val);
        }
        this.hash = -1;
    }

    public void setRNDvalue(double dCenter, double dRange) {
        double dMin = dCenter - dRange / 2.0;
        for (int i = 0; i < this.data.length; ++i) {
            double dVal = dRange * Math.random();
            this.data[i] = (int)(dMin + dVal);
        }
        this.hash = -1;
    }

    public int size() {
        return this.data.length;
    }

    public int sizeBits() {
        return this.data.length * 32;
    }

    public int sizeBytes() {
        return this.data.length * 4;
    }

    public void setRNDvalue(double dRange) {
        for (int i = 0; i < this.data.length; ++i) {
            double dMin = (double)this.data[i] - dRange / 2.0;
            double dVal = dRange * Math.random();
            this.data[i] = (int)(dMin + dVal);
        }
        this.hash = -1;
    }

    public IntVec sub(IntVec dvSub) {
        IntVec ret = new IntVec(this.data.length);
        for (int i = 0; i < ret.data.length; ++i) {
            ret.data[i] = this.data[i] - dvSub.data[i];
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        DecimalFormat nf = new DecimalFormat("0");
        for (int i = 0; i < this.data.length; ++i) {
            sb.append(nf.format(this.data[i]));
            if (i >= this.data.length - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public String toStringHex() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.data.length; ++i) {
            sb.append(Integer.toHexString(this.data[i]));
            if (i >= this.data.length - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public String toStringBinary() {
        StringBuilder sb = new StringBuilder();
        int si = this.size();
        for (int i = 0; i < si; ++i) {
            String s = IntVec.toStringBinary(this.get(i)) + " ";
            sb.append(s);
        }
        return sb.toString().trim();
    }

    public String toStringBinaryDense() {
        StringBuilder sb = new StringBuilder();
        int si = this.size();
        for (int i = 0; i < si; ++i) {
            String s = IntVec.toStringBinary(this.get(i), false);
            sb.append(s);
        }
        return sb.toString().trim();
    }

    public String toStringBytes() {
        StringBuilder str = new StringBuilder();
        int si = this.sizeBytes();
        for (int ii = 0; ii < si; ++ii) {
            String s = this.getByte(ii) + " ";
            str.append(s);
        }
        return str.toString().trim();
    }

    public double[] toDoubleBitWise() {
        double[] arr = new double[this.size() * 32];
        int cc = 0;
        for (int i = 0; i < this.data.length; ++i) {
            int v = this.data[i];
            int mask = 1;
            for (int j = 0; j < 32; ++j) {
                arr[cc] = (v & mask) != 0 ? 1.0 : 0.0;
                mask <<= 1;
                ++cc;
            }
        }
        return arr;
    }

    public int[] toIntByteWise() {
        int[] arr = new int[this.size() * 4];
        for (int i = 0; i < this.sizeBytes(); ++i) {
            arr[i] = this.getByte(i);
        }
        return arr;
    }

    public String toString(int iNumDigits) {
        StringBuffer str = new StringBuffer();
        String sFormat = "0";
        for (int i = 0; i < iNumDigits; ++i) {
            sFormat = sFormat + "0";
        }
        DecimalFormat nf = new DecimalFormat(sFormat);
        for (int i = 0; i < this.data.length; ++i) {
            String sVal = nf.format(this.data[i]);
            str.append(sVal + " ");
        }
        return str.toString();
    }

    public String write2String() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.data.length);
        sb.append(" ");
        sb.append(this.hash);
        sb.append(" ");
        sb.append(this.toString());
        return sb.toString();
    }

    public int[] toArray() {
        return this.data;
    }

    public static double getTanimotoDistBitWise(IntVec iv1, IntVec iv2) {
        int bitsOR = 0;
        int bitsAND = 0;
        for (int i = 0; i < iv1.data.length; ++i) {
            bitsOR += Integer.bitCount(iv1.data[i] | iv2.data[i]);
            bitsAND += Integer.bitCount(iv1.data[i] & iv2.data[i]);
        }
        if (bitsAND == 0) {
            return 0.0;
        }
        double sum = (double)bitsAND / (double)bitsOR;
        return sum;
    }

    public static final double getTanimotoDistBitWise(int[] arr1, int[] arr2) {
        int bitsOR = 0;
        int bitsAND = 0;
        for (int i = 0; i < arr1.length; ++i) {
            bitsOR += Integer.bitCount(arr1[i] | arr2[i]);
            bitsAND += Integer.bitCount(arr1[i] & arr2[i]);
        }
        if (bitsAND == 0) {
            return 0.0;
        }
        double dSum = (double)bitsAND / (double)bitsOR;
        return dSum;
    }

    public static double getTanimotoDistInvBitWise(IntVec iv1, IntVec iv2) {
        return 1.0 - IntVec.getTanimotoDistBitWise(iv1, iv2);
    }

    public static double getTanimotoDistInvBitWise(int[] arr1, int[] arr2) {
        return 1.0 - IntVec.getTanimotoDistBitWise(arr1, arr2);
    }

    public static double getTanimotoDist(IntVec iv1, IntVec iv2) {
        double sum = 0.0;
        double dAtB = IntVec.mult(iv1, iv2);
        double dAtA = IntVec.mult(iv1, iv1);
        double dBtB = IntVec.mult(iv2, iv2);
        sum = dAtB / (dAtA + dBtB - dAtB);
        return sum;
    }

    public static double getTanimotoDist(int[] a, int[] b) {
        double sum = 0.0;
        double dAtB = IntVec.mult(a, b);
        double dAtA = IntVec.mult(a, a);
        double dBtB = IntVec.mult(b, b);
        sum = dAtB / (dAtA + dBtB - dAtB);
        return sum;
    }

    public static final double getTanimotoDistInv(IntVec iv1, IntVec iv2) {
        double sum = 0.0;
        double dAtB = IntVec.mult(iv1, iv2);
        double dAtA = IntVec.mult(iv1, iv1);
        double dBtB = IntVec.mult(iv2, iv2);
        sum = 1.0 - dAtB / (dAtA + dBtB - dAtB);
        return sum;
    }

    public static double getScoreQueryInBaseByteWise(IntVec query, IntVec base) {
        double dSumPosDiff = 0.0;
        double denominator = 0.0;
        for (int i = 0; i < query.data.length; ++i) {
            int b11 = query.data[i] & 0xFF;
            int b12 = base.data[i] & 0xFF;
            denominator += (double)b11;
            int diff = b11 - b12;
            if (diff > 0) {
                dSumPosDiff += (double)diff;
            }
            int b21 = (query.data[i] & 0xFF00) >> 8;
            int b22 = (base.data[i] & 0xFF00) >> 8;
            denominator += (double)b21;
            diff = b21 - b22;
            if (diff > 0) {
                dSumPosDiff += (double)diff;
            }
            int b31 = (query.data[i] & 0xFF0000) >> 16;
            int b32 = (base.data[i] & 0xFF0000) >> 16;
            denominator += (double)b31;
            diff = b31 - b32;
            if (diff > 0) {
                dSumPosDiff += (double)diff;
            }
            int b41 = (query.data[i] & 0xFF000000) >> 24;
            int b42 = (base.data[i] & 0xFF000000) >> 24;
            denominator += (double)b41;
            diff = b41 - b42;
            if (diff <= 0) continue;
            dSumPosDiff += (double)diff;
        }
        if (denominator > 0.0) {
            dSumPosDiff /= denominator;
        }
        return dSumPosDiff;
    }

    public static double getScoreQueryInBase(IntVec query, IntVec base) {
        double dSumPosDiff = 0.0;
        double denominator = 0.0;
        for (int i = 0; i < query.size(); ++i) {
            int diff = query.get(i) - base.get(i);
            denominator += (double)query.get(i);
            if (diff <= 0) continue;
            dSumPosDiff += (double)diff;
        }
        if (denominator > 0.0) {
            dSumPosDiff /= denominator;
        }
        return dSumPosDiff;
    }

    public static double getScoreQueryInBaseBitWise(IntVec query, IntVec base) {
        return IntVec.getScoreQueryInBaseBitWise(query.data, base.data);
    }

    public static double getScoreQueryInBaseBitWise(int[] query, int[] base) {
        double sc = 0.0;
        for (int i = 0; i < query.length; ++i) {
            int bitsCommon = 0;
            int bitsOnlyInQuery = 0;
            bitsCommon = query[i] | base[i];
            bitsOnlyInQuery = bitsCommon ^ base[i];
            sc += (double)Integer.bitCount(bitsOnlyInQuery) / (double)Integer.bitCount(query[i]);
        }
        return sc /= (double)query.length;
    }

    public static double getScoreFracBitsInCommonBitWise(IntVec v1, IntVec v2) {
        double sc = 0.0;
        double cc = 0.0;
        for (int i = 0; i < v1.data.length; ++i) {
            int bitsCommon = v1.data[i] & v2.data[i];
            int bitsTotalInV1 = v1.data[i] | v2.data[i];
            if (bitsTotalInV1 != 0) {
                sc += (double)Integer.bitCount(bitsCommon) / (double)Integer.bitCount(bitsTotalInV1);
            }
            cc += 1.0;
        }
        return 1.0 - (sc /= cc);
    }

    public static double getTanimotoDistInvByteWise(IntVec iv1, IntVec iv2) {
        double sum = 0.0;
        double dAtB = IntVec.multByteWise(iv1, iv2);
        double dAtA = IntVec.multByteWise(iv1, iv1);
        double dBtB = IntVec.multByteWise(iv2, iv2);
        sum = 1.0 - dAtB / (dAtA + dBtB - dAtB);
        return sum;
    }

    public static double getTanimotoDistInvByteWise(int[] iv1, int[] iv2) {
        double sum = 0.0;
        double dAtB = IntVec.multByteWise(iv1, iv2);
        double dAtA = IntVec.multByteWise(iv1, iv1);
        double dBtB = IntVec.multByteWise(iv2, iv2);
        sum = 1.0 - dAtB / (dAtA + dBtB - dAtB);
        return sum;
    }

    public static double getScoreFracBitsCommonQuery(IntVec query, IntVec base) {
        double sc = 0.0;
        for (int i = 0; i < query.data.length; ++i) {
            int bitsCommon = query.data[i] & base.data[i];
            if (query.data[i] == 0) continue;
            sc += (double)Integer.bitCount(bitsCommon) / (double)Integer.bitCount(query.data[i]);
        }
        return 1.0 - (sc /= (double)query.data.length);
    }

    public static int getOverlap(IntVec iv1, IntVec iv2) {
        IntVec iv = IntVec.AND(iv1, iv2);
        return iv.getBitsSet();
    }

    public static void incrementByte(int[] data, int i) {
        int ind = i / 4;
        int indInInt = i % 4;
        int valOld = 0;
        int increment = 1;
        int maskInverse = 0;
        switch (indInInt) {
            case 3: {
                maskInverse = -256;
                valOld = data[ind] & 0xFF;
                break;
            }
            case 2: {
                maskInverse = -65281;
                valOld = data[ind] & 0xFF00;
                increment <<= 8;
                break;
            }
            case 1: {
                maskInverse = -16711681;
                valOld = data[ind] & 0xFF0000;
                increment <<= 16;
                break;
            }
            case 0: {
                maskInverse = 0xFFFFFF;
                valOld = data[ind] & 0xFF000000;
                increment <<= 24;
            }
        }
        data[ind] = data[ind] & maskInverse | valOld + increment;
    }

    public static void writeBitStringDense(File fi, List<IntVec> li) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(fi));
        for (int i = 0; i < li.size(); ++i) {
            bw.append(li.get(i).toStringBinaryDense());
            if (i >= li.size() - 1) continue;
            bw.append("\n");
        }
        bw.close();
    }

    public static List<IntVec> readBitStringDense(File fi) throws IOException {
        ArrayList<IntVec> li = new ArrayList<IntVec>();
        BufferedReader br = new BufferedReader(new FileReader(fi));
        String line = "";
        int cc = 0;
        while ((line = br.readLine()) != null) {
            try {
                IntVec iv = IntVec.readBitStringDense(line);
                li.add(iv);
            }
            catch (Exception e) {
                System.err.println("Error in line " + cc + ".");
                e.printStackTrace();
            }
            ++cc;
        }
        br.close();
        return li;
    }

    public static IntVec read(InputStream s) throws IOException {
        int size = IntArray.parseInteger(s);
        int hash = IntArray.parseInteger(s);
        int[] a = new int[size];
        for (int i = 0; i < size; ++i) {
            a[i] = IntArray.parseInteger(s);
        }
        IntVec iv = new IntVec();
        iv.data = a;
        iv.hash = hash;
        return iv;
    }

    public static boolean isBitSet(int[] a, int i) {
        int ind = a.length - i / 32 - 1;
        int indInInt = i % 32;
        int mask = 1;
        return (a[ind] & (mask <<= indInInt)) != 0;
    }

    public static boolean isBitSet(int val, int index) {
        int indInInt = index % 32;
        int mask = 1;
        return (val & (mask <<= indInInt)) != 0;
    }

    public static void setBit(int[] data, int i) {
        int ind = data.length - i / 32 - 1;
        int indInInt = i % 32;
        int mask = 1;
        data[ind] = data[ind] | (mask <<= indInInt);
    }

    public static String toStringBinary(int v) {
        return IntVec.toStringBinary(v, true);
    }

    public static String toStringBinary(int v, boolean space) {
        StringBuilder sb = new StringBuilder();
        int len = 32;
        for (int i = 0; i < len; ++i) {
            if ((v & 1) == 1) {
                sb.insert(0, "1");
            } else {
                sb.insert(0, "0");
            }
            if (space) {
                sb.insert(0, " ");
            }
            v >>= 1;
        }
        return sb.toString().trim();
    }
}

