/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util.datamodel;

import com.actelion.research.util.Formatter;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class ScorePoint
extends Point {
    private static final long serialVersionUID = 24052013L;
    private double score;

    public ScorePoint() {
        super(-1, -1);
    }

    public ScorePoint(Point p) {
        super(p);
    }

    public ScorePoint(Point p, double value) {
        super(p);
        this.score = value;
    }

    public ScorePoint(int x, int y, double value) {
        super(x, y);
        this.score = value;
    }

    public ScorePoint(int x, int y) {
        super(x, y);
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("x " + this.x);
        sb.append(" y " + this.y);
        sb.append(" " + Formatter.format3(this.score));
        return sb.toString();
    }

    public static List<ScorePoint> read(File fiTxt) throws IOException {
        ArrayList<ScorePoint> li = new ArrayList<ScorePoint>();
        BufferedReader br = new BufferedReader(new FileReader(fiTxt));
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] arr = line.split("\\t");
            int x = Integer.parseInt(arr[0].trim());
            int y = Integer.parseInt(arr[1].trim());
            double v = Double.parseDouble(arr[2].trim());
            li.add(new ScorePoint(x, y, v));
        }
        br.close();
        return li;
    }

    public static int[] extractX(List<ScorePoint> li) {
        int[] a = new int[li.size()];
        for (int i = 0; i < li.size(); ++i) {
            a[i] = li.get((int)i).x;
        }
        return a;
    }

    public static Comparator<ScorePoint> getComparatorScore() {
        return new Comparator<ScorePoint>(){

            @Override
            public int compare(ScorePoint sp1, ScorePoint sp2) {
                if (sp1.score > sp2.score) {
                    return 1;
                }
                if (sp1.score < sp2.score) {
                    return -1;
                }
                return 0;
            }
        };
    }

    public static Comparator<ScorePoint> getComparatorX() {
        return new Comparator<ScorePoint>(){

            @Override
            public int compare(ScorePoint sp1, ScorePoint sp2) {
                if (sp1.x > sp2.x) {
                    return 1;
                }
                if (sp1.x < sp2.x) {
                    return -1;
                }
                return 0;
            }
        };
    }

    public static Comparator<ScorePoint> getComparatorY() {
        return new Comparator<ScorePoint>(){

            @Override
            public int compare(ScorePoint sp1, ScorePoint sp2) {
                if (sp1.y > sp2.y) {
                    return 1;
                }
                if (sp1.y < sp2.y) {
                    return -1;
                }
                return 0;
            }
        };
    }
}

