/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.chem;

import com.actelion.research.chem.Depictor2D;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.IsomericSmilesCreator;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.SmilesParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.CoordinateInventor;
import com.actelion.research.gui.JStructureView;
import com.actelion.research.gui.generic.GenericRectangle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.LineBorder;

public class ChemUtils {
    public static String idcodeToSmiles(String idcode) {
        StereoMolecule m = new StereoMolecule();
        IDCodeParser p = new IDCodeParser();
        p.parse(m, idcode);
        String smiles = "exception_in_smiles_creator";
        try {
            IsomericSmilesCreator smiles_creator = new IsomericSmilesCreator(m);
            smiles = smiles_creator.getSmiles();
        }
        catch (Exception ex) {
            System.out.println("Exception in idcodeToSmiles..");
        }
        return smiles;
    }

    public static String stereoMoleculeToSmiles(StereoMolecule sm) {
        IsomericSmilesCreator smiles_creator = new IsomericSmilesCreator(sm);
        return smiles_creator.getSmiles();
    }

    public static StereoMolecule parseIDCode(String idc) {
        IDCodeParser icp = new IDCodeParser();
        StereoMolecule mi = new StereoMolecule();
        icp.parse(mi, idc);
        mi.ensureHelperArrays(31);
        return mi;
    }

    public static StereoMolecule parseSmiles(String idc) {
        SmilesParser sp = new SmilesParser();
        StereoMolecule mi = new StereoMolecule();
        try {
            sp.parse(mi, idc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        mi.ensureHelperArrays(31);
        return mi;
    }

    public static List<StereoMolecule> parseIDCodes(List<String> idcodes) {
        ArrayList<StereoMolecule> parsed = new ArrayList<StereoMolecule>();
        IDCodeParser icp = new IDCodeParser();
        for (String si : idcodes) {
            StereoMolecule mi = new StereoMolecule();
            icp.parse(mi, si);
            mi.ensureHelperArrays(31);
            parsed.add(mi);
        }
        return parsed;
    }

    public static BitSet findAtomsWithAtomicNo(StereoMolecule mi, int ano) {
        BitSet bs = new BitSet();
        mi.ensureHelperArrays(1);
        for (int zi = 0; zi < mi.getAtoms(); ++zi) {
            if (mi.getAtomicNo(zi) != ano) continue;
            bs.set(zi);
        }
        return bs;
    }

    public static List<Integer> findNeighbors(StereoMolecule mi, int a) {
        ArrayList<Integer> neighbors = new ArrayList<Integer>();
        if (mi.getAtoms() <= a) {
            return new ArrayList<Integer>();
        }
        for (int za = 0; za < mi.getConnAtoms(a); ++za) {
            neighbors.add(mi.getConnAtom(a, za));
        }
        return neighbors;
    }

    public static BitSet findBondsInBetweenAtoms(StereoMolecule mol, BitSet atoms) {
        mol.ensureHelperArrays(31);
        BitSet bonds = new BitSet(mol.getBonds());
        for (int zi = 0; zi < mol.getBonds(); ++zi) {
            int baa = mol.getBondAtom(0, zi);
            int bab = mol.getBondAtom(1, zi);
            if (!atoms.get(baa) || !atoms.get(bab)) continue;
            bonds.set(zi, true);
        }
        return bonds;
    }

    public static void highlightBondsInBetweenAtoms(StereoMolecule mol, BitSet atoms) {
        for (int zb = 0; zb < mol.getBonds(); ++zb) {
            mol.setBondBackgroundHiliting(zb, false);
        }
        BitSet bs = ChemUtils.findBondsInBetweenAtoms(mol, atoms);
        for (int zb = 0; zb < mol.getBonds(); ++zb) {
            if (!bs.get(zb)) continue;
            mol.setBondBackgroundHiliting(zb, true);
        }
    }

    public static boolean checkForAdjacentBonds(StereoMolecule mol, int[] bonds) {
        boolean found_adj = false;
        BitSet found_atoms = new BitSet(mol.getAtoms());
        for (int zi = 0; zi < bonds.length; ++zi) {
            int ba = mol.getBondAtom(0, bonds[zi]);
            int bb = mol.getBondAtom(1, bonds[zi]);
            if (found_atoms.get(ba) || found_atoms.get(bb)) {
                found_adj = true;
                break;
            }
            found_atoms.set(ba, true);
            found_atoms.set(bb, true);
        }
        return found_adj;
    }

    public static StereoMolecule createProximalFragment(StereoMolecule mi_pre, List<Integer> seed_atoms, int region_size, boolean omit_connectors, boolean[] neglectAtom) {
        StereoMolecule mi_conn = new StereoMolecule(mi_pre);
        mi_conn.ensureHelperArrays(31);
        boolean[] keep_atoms = new boolean[mi_conn.getAtoms()];
        block0: for (int zi = 0; zi < mi_conn.getAtoms(); ++zi) {
            for (int ci : seed_atoms) {
                int path_length;
                if (zi == ci) {
                    keep_atoms[zi] = true;
                    continue block0;
                }
                if (omit_connectors && mi_conn.getAtomicNo(zi) >= 88 || (path_length = mi_conn.getPathLength(ci, zi, region_size, neglectAtom)) < 0 || path_length > region_size) continue;
                keep_atoms[zi] = true;
            }
        }
        StereoMolecule mi_cut = new StereoMolecule();
        mi_cut.setFragment(true);
        mi_conn.copyMoleculeByAtoms(mi_cut, keep_atoms, true, null);
        mi_cut.ensureHelperArrays(31);
        return mi_cut;
    }

    public static int hac(StereoMolecule m) {
        m.ensureHelperArrays(1);
        return m.getAtoms();
    }

    public static int countRingAtoms(StereoMolecule m) {
        m.ensureHelperArrays(1);
        int ra = 0;
        for (int zi = 0; zi < m.getAtoms(); ++zi) {
            if (!m.isRingAtom(zi)) continue;
            ++ra;
        }
        return ra;
    }

    public static int countAromaticAtoms(StereoMolecule m) {
        m.ensureHelperArrays(1);
        int ra = 0;
        for (int zi = 0; zi < m.getAtoms(); ++zi) {
            if (!m.isAromaticAtom(zi)) continue;
            ++ra;
        }
        return ra;
    }

    public static int countAtoms(StereoMolecule m, List<Integer> atomic_numbers) {
        m.ensureHelperArrays(1);
        int ra = 0;
        for (int zi = 0; zi < m.getAtoms(); ++zi) {
            if (!atomic_numbers.contains(m.getAtomicNo(zi))) continue;
            ++ra;
        }
        return ra;
    }

    public static int countRings(StereoMolecule m) {
        m.ensureHelperArrays(31);
        RingCollection rings = m.getRingSet();
        return rings.getSize();
    }

    public static int countRingsAromatic(StereoMolecule m) {
        m.ensureHelperArrays(31);
        RingCollection rings = m.getRingSet();
        int ra = 0;
        for (int zi = 0; zi < rings.getSize(); ++zi) {
            if (!rings.isAromatic(zi)) continue;
            ++ra;
        }
        return ra;
    }

    public static int countRingsHeteroaromatic(StereoMolecule m) {
        m.ensureHelperArrays(31);
        RingCollection rings = m.getRingSet();
        int ra = 0;
        for (int zi = 0; zi < rings.getSize(); ++zi) {
            if (!rings.isAromatic(zi) || rings.getHeteroPosition(zi) < 0) continue;
            ++ra;
        }
        return ra;
    }

    public static boolean checkIfAllAtomsAreInSameFragment(StereoMolecule mi, List<Integer> atoms) {
        mi.ensureHelperArrays(31);
        if (atoms.size() == 0) {
            return true;
        }
        if (atoms.size() == 1) {
            return true;
        }
        int[] frag = mi.getFragmentAtoms(atoms.get(0));
        BitSet bsi = ChemUtils.toBitSet(frag);
        BitSet bs_atoms = ChemUtils.toBitSet(atoms);
        BitSet bsi_and_bsa = (BitSet)bs_atoms.clone();
        bsi_and_bsa.and(bs_atoms);
        return bs_atoms.cardinality() == bsi_and_bsa.cardinality();
    }

    public static List<Integer> getSelectedAtoms(StereoMolecule m) {
        ArrayList<Integer> sel = new ArrayList<Integer>();
        m.ensureHelperArrays(31);
        for (int zi = 0; zi < m.getAtoms(); ++zi) {
            if (!m.isSelectedAtom(zi)) continue;
            sel.add(zi);
        }
        return sel;
    }

    public static List<Integer> getSelectedBonds(StereoMolecule m) {
        ArrayList<Integer> sel = new ArrayList<Integer>();
        m.ensureHelperArrays(31);
        for (int zi = 0; zi < m.getBonds(); ++zi) {
            if (!m.isSelectedBond(zi)) continue;
            sel.add(zi);
        }
        return sel;
    }

    public static BitSet toBitSet(int[] arr) {
        BitSet bs = new BitSet();
        for (int zi = 0; zi < arr.length; ++zi) {
            if (arr[zi] < 0) continue;
            bs.set(arr[zi], true);
        }
        return bs;
    }

    public static BitSet toBitSet(List<Integer> val) {
        BitSet bsi = new BitSet();
        for (int zi = 0; zi < val.size(); ++zi) {
            bsi.set((int)val.get(zi), true);
        }
        return bsi;
    }

    public static boolean[] toBooleanArray(BitSet bs) {
        boolean[] ba = new boolean[bs.size()];
        for (int zi : bs.stream().toArray()) {
            ba[zi] = true;
        }
        return ba;
    }

    public static boolean[] toBooleanArray(BitSet bs, int length) {
        boolean[] ba = new boolean[length];
        for (int zi : bs.stream().toArray()) {
            if (zi >= length) continue;
            ba[zi] = true;
        }
        return ba;
    }

    public static int[] toIntArray(BitSet bs) {
        return bs.stream().toArray();
    }

    public static int[] toIntArray(List<Integer> list) {
        int[] arr = new int[list.size()];
        for (int zi = 0; zi < arr.length; ++zi) {
            arr[zi] = list.get(zi);
        }
        return arr;
    }

    public static List<Integer> toIntList(BitSet bsi) {
        ArrayList<Integer> li = new ArrayList<Integer>();
        bsi.stream().forEach(ii -> li.add(ii));
        return li;
    }

    public static Map<Integer, Integer> inverseMap(int[] map) {
        HashMap<Integer, Integer> inv = new HashMap<Integer, Integer>();
        for (int zi = 0; zi < map.length; ++zi) {
            inv.put(map[zi], zi);
        }
        return inv;
    }

    public static StereoMolecule tryParseChemistry(String str_data) {
        StereoMolecule m = new StereoMolecule();
        boolean parsing_success = false;
        try {
            IDCodeParser icp = new IDCodeParser();
            icp.parse(m, str_data);
            parsing_success = true;
        }
        catch (Exception icp) {
            // empty catch block
        }
        if (!parsing_success) {
            try {
                SmilesParser smi = new SmilesParser();
                smi.parse(m, str_data);
                parsing_success = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!parsing_success) {
            return null;
        }
        m.ensureHelperArrays(31);
        return m;
    }

    public static void createPNGFromStructure(StereoMolecule mi, String path, int width, int height) throws IOException, InvocationTargetException, InterruptedException {
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g_1 = bi.createGraphics();
        g_1.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g_1.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g_1.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        Depictor2D pic = new Depictor2D(mi);
        GenericRectangle rect = new GenericRectangle(0.0, 0.0, width, height);
        pic.validateView(g_1, rect, 65568);
        pic.paint(g_1);
        GenericRectangle bounds = new GenericRectangle(pic.getBoundingRect().x, pic.getBoundingRect().y, pic.getBoundingRect().width, pic.getBoundingRect().height);
        g_1.setColor(Color.blue);
        g_1.drawRect((int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height);
        Depictor2D pic2 = new Depictor2D(mi);
        GenericRectangle bounds_extended = new GenericRectangle(0.0, 0.0, bounds.width + 1.0, bounds.height + 1.0);
        BufferedImage bi_2 = new BufferedImage((int)Math.ceil(bounds.width) + 1, (int)Math.ceil(bounds.height) + 1, 2);
        Graphics2D g_2 = bi_2.createGraphics();
        g_2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g_2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g_2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        pic2.validateView(g_2, bounds_extended, 65568);
        pic2.paint(g_2);
        g_1.dispose();
        g_2.dispose();
        try {
            ImageIO.write((RenderedImage)bi, "png", new File(path.replace(".png", "_a.png")));
            ImageIO.write((RenderedImage)bi_2, "png", new File(path));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class DebugOutput {
        static JFrame frame = null;
        static JTabbedPane tp = null;

        public static void plotMolecules(String title, List<String> idcodes, int sx, int sy) {
            DebugOutput.plotMolecules(title, (String[])idcodes.stream().toArray(String[]::new), sx, sy);
        }

        public static void plotMolecules(String title, String[] idcodes, int sx, int sy) {
            DebugOutput.plotMolecules(title, ChemUtils.parseIDCodes(Arrays.asList(idcodes)).toArray(new StereoMolecule[0]), sx, sy);
        }

        public static void plotMolecules(String title, StereoMolecule[] mols, int sx, int sy) {
            DebugOutput.plotMolecules(title, mols, sx, sy, true);
        }

        public static void plotMolecules(String title, StereoMolecule[] mols, int sx, int sy, boolean inventCoordinates) {
            if (frame == null) {
                JFrame f;
                frame = f = new JFrame();
                tp = new JTabbedPane();
                f.getContentPane().setLayout(new BorderLayout());
                f.getContentPane().add(tp);
                f.setVisible(true);
                int w = Math.min(800, sx * 300);
                int h = Math.min(800, sx * 300);
                f.setSize(w, h);
                f.setDefaultCloseOperation(2);
            }
            JScrollPane sp = new JScrollPane();
            JPanel pi = new JPanel();
            pi.setLayout(new GridLayout(sx, sy));
            sp.setViewportView(pi);
            CoordinateInventor ci = new CoordinateInventor();
            for (int zi = 0; zi < mols.length; ++zi) {
                StereoMolecule si = mols[zi];
                if (inventCoordinates) {
                    ci.invent(si);
                }
                JStructureView sv = new JStructureView(si);
                pi.add(sv);
                sv.setBorder(new LineBorder(Color.black));
            }
            tp.add(title, pi);
        }

        public static void main(String[] args) {
            String sa = "didHPD@zxHR[Y^FZZX@`";
            String sb = "dmuHPHF`neNdefuQfjjj`B";
            String[] idcodes = new String[]{sa, sb};
            DebugOutput.plotMolecules("Out_A", idcodes, 2, 2);
            DebugOutput.plotMolecules("Out_b", idcodes, 2, 2);
            DebugOutput.plotMolecules("Out_c", idcodes, 2, 2);
        }
    }
}

