/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.chem;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;

public class LeetSerialization {
    public static final LeetObjectMapper OBJECT_MAPPER = new LeetObjectMapper();

    public static class StereoMoleculeDeserializer
    extends JsonDeserializer<StereoMolecule> {
        @Override
        public StereoMolecule deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            StereoMolecule mi = new StereoMolecule();
            IDCodeParser icp = new IDCodeParser();
            ObjectCodec codec = p.getCodec();
            JsonNode node = (JsonNode)codec.readTree(p);
            String idc = node.get("M").asText();
            String idc_coords = node.get("C").asText("");
            icp.parse(mi, idc, idc_coords);
            mi.ensureHelperArrays(31);
            return mi;
        }
    }

    public static class StereoMoleculeSerializer
    extends JsonSerializer<StereoMolecule> {
        @Override
        public void serialize(StereoMolecule o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("M", o.getIDCode());
            jsonGenerator.writeStringField("C", o.getIDCoordinates());
            jsonGenerator.writeEndObject();
        }
    }

    public static class OCLModule
    extends SimpleModule {
        private static final String NAME = "OpenChemLibModule";
        private static final VersionUtil VERSION_UTIL = new VersionUtil(){};
        public static final String STEREOMOLECULE_FIELD_IDC = "M";
        public static final String STEREOMOLECULE_FIELD_IDC_COORDS = "C";

        public OCLModule() {
            super(NAME, VERSION_UTIL.version());
            this.addSerializer(StereoMolecule.class, new StereoMoleculeSerializer());
            this.addDeserializer(StereoMolecule.class, new StereoMoleculeDeserializer());
        }
    }

    public static class LeetObjectMapper
    extends ObjectMapper {
        public LeetObjectMapper() {
            this.registerModule(new OCLModule());
        }
    }
}

