/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.chem;

import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.StereoMolecule;

public class QueryFeatureUtils {
    public static void removeNarrowingQueryFeatures(ExtendedMolecule mol) {
        if (!mol.isFragment()) {
            return;
        }
        for (int atom = 0; atom < mol.getAllAtoms(); ++atom) {
            mol.setAtomQueryFeature(atom, 239060990L, false);
            mol.setAtomQueryFeature(atom, 2048L, false);
        }
        for (int bond = 0; bond < mol.getAllBonds(); ++bond) {
            mol.setBondQueryFeature(bond, 1572960, false);
        }
    }

    public static void addBridgeBond(StereoMolecule mi, int atom_a, int atom_b, int minlength, int maxlength) {
        int bi = mi.addBond(atom_a, atom_b);
        QueryFeatureUtils.setBridgeBondQF(mi, bi, minlength, maxlength);
    }

    public static void setBridgeBondQF(StereoMolecule mi, int bond, int minlength, int maxlength) {
        int minAtoms = minlength;
        int atomSpan = maxlength - minlength;
        int queryFeatures = 0;
        queryFeatures |= minAtoms << 7;
        queryFeatures |= atomSpan << 11;
        mi.setBondQueryFeature(bond, queryFeatures &= 0xFFFFFFE0, true);
    }
}

