/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.chem.dataimport;

import com.actelion.research.chem.StereoMolecule;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import tech.molecules.leet.chem.ChemUtils;
import tech.molecules.leet.chem.CombinatoricsUtils;
import tech.molecules.leet.chem.LeetSerialization;
import tech.molecules.leet.chem.mutator.SimpleSynthonWithContext;
import tech.molecules.leet.chem.shredder.FragmentDecomposition;
import tech.molecules.leet.chem.shredder.FragmentDecompositionShredder;
import tech.molecules.leet.io.CSVIterator;

public class FragmentDBCreator {
    private List<Pair<String, String>> molecules = new ArrayList<Pair<String, String>>();
    private Map<String, Map<String, List<String>>> decompositions_SortedByBidir1AndByCF = new HashMap<String, Map<String, List<String>>>();

    public FragmentDBCreator(List<Pair<String, String>> molecules) {
        this.molecules = molecules;
    }

    public void init() {
        for (int zi = 0; zi < this.molecules.size(); ++zi) {
            StereoMolecule mi = ChemUtils.parseIDCode(this.molecules.get(zi).getRight());
            this.processStructure(this.molecules.get(zi).getLeft(), mi);
            if (zi % 200 != 0) continue;
            System.gc();
        }
    }

    public void writeToCSV(String path) throws IOException {
        try (BufferedWriter out = new BufferedWriter(new FileWriter(path + File.separator + "fragdb.csv"));){
            ArrayList<String> header = new ArrayList<String>();
            header.add("Fragment[idcode]");
            header.add("bdir1[idcode]");
            header.add("count");
            out.write(String.join((CharSequence)",", header) + "\n");
            for (String bdir1 : this.decompositions_SortedByBidir1AndByCF.keySet()) {
                for (String cf : this.decompositions_SortedByBidir1AndByCF.get(bdir1).keySet()) {
                    ArrayList<String> cols = new ArrayList<String>();
                    cols.add(cf);
                    cols.add(bdir1);
                    cols.add("" + this.decompositions_SortedByBidir1AndByCF.get(bdir1).get(cf).size());
                    out.write(String.join((CharSequence)",", cols) + "\n");
                }
            }
            out.flush();
        }
    }

    private void processStructure(String id, StereoMolecule mi) {
        List<FragmentDecomposition> decompositions = FragmentDecompositionShredder.computeFragmentDecompositions(mi, id, 18, 0.4, 3, 3);
        for (FragmentDecomposition fdi : decompositions) {
            if (!fdi.getInnerNeighborAtomicNos().stream().allMatch(ci -> ci == 6)) continue;
            this.addDecomposition(fdi);
        }
    }

    private synchronized void addDecomposition(FragmentDecomposition decomp) {
        String bidir1_idc = decomp.getBidirectionalConnectorProximalRegion(1).getIDCode();
        String cf_idc = decomp.getCentralFrag().getIDCode();
        if (!this.decompositions_SortedByBidir1AndByCF.containsKey(bidir1_idc)) {
            this.decompositions_SortedByBidir1AndByCF.put(bidir1_idc, new HashMap());
        }
        if (!this.decompositions_SortedByBidir1AndByCF.get(bidir1_idc).containsKey(cf_idc)) {
            this.decompositions_SortedByBidir1AndByCF.get(bidir1_idc).put(cf_idc, new ArrayList());
        }
        String str_decomp = null;
        try {
            str_decomp = LeetSerialization.OBJECT_MAPPER.writeValueAsString(decomp);
        }
        catch (JsonProcessingException e) {
            System.out.println("[ERROR] problem with serializatino of decomposition");
        }
        this.decompositions_SortedByBidir1AndByCF.get(bidir1_idc).get(cf_idc).add(str_decomp);
    }

    public static void main(String[] args) {
        ArrayList<Integer> fields = new ArrayList<Integer>();
        fields.add(0);
        fields.add(1);
        CSVIterator iter = null;
        try {
            iter = new CSVIterator("C:\\Temp\\leet\\chembl_structures_short.csv", true, fields);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int cnt = 0;
        ArrayList<Pair<String, String>> molecules = new ArrayList<Pair<String, String>>();
        while (iter.hasNext()) {
            Object di = iter.next();
            molecules.add(Pair.of((String)di.get(0), (String)di.get(1)));
            ++cnt;
        }
        FragmentDBCreator fdbc = new FragmentDBCreator(molecules);
        fdbc.init();
        try {
            fdbc.writeToCSV("C:\\Temp\\leet");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, List<Pair<String, Integer>>> loadFragments() {
        HashMap<String, List<Pair<String, Integer>>> fragdb = new HashMap<String, List<Pair<String, Integer>>>();
        String file = "C:\\Temp\\leet\\fragdb.csv";
        ArrayList cols = new ArrayList();
        CSVIterator it = null;
        try {
            it = new CSVIterator(file, true, CombinatoricsUtils.intSeq(3));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        while (it.hasNext()) {
            try {
                Object line = it.next();
                if (!fragdb.containsKey(line.get(1))) {
                    fragdb.put((String)line.get(1), new ArrayList());
                }
                ((List)fragdb.get(line.get(1))).add(Pair.of((String)line.get(0), Integer.parseInt((String)line.get(2))));
            }
            catch (Exception ex) {
                System.out.println("[WARN] skip line, error parsing..");
            }
        }
        return fragdb;
    }

    public static List<Pair<String, Integer>> loadFragments2() {
        ArrayList<Pair<String, Integer>> fragmentdb = new ArrayList<Pair<String, Integer>>();
        String file = "C:\\Temp\\leet\\fragdb.csv";
        ArrayList cols = new ArrayList();
        CSVIterator it = null;
        try {
            it = new CSVIterator(file, true, CombinatoricsUtils.intSeq(3));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        while (it.hasNext()) {
            try {
                Object line = it.next();
                StereoMolecule synthon = ChemUtils.parseIDCode((String)line.get(0));
                StereoMolecule context = ChemUtils.parseIDCode((String)line.get(1));
                List<SimpleSynthonWithContext> synthons = SimpleSynthonWithContext.createAllPossibleFromSynthonAndBidirectionalContext(synthon, context);
                fragmentdb.addAll(synthons.stream().map(arg_0 -> FragmentDBCreator.lambda$loadFragments2$1((List)line, arg_0)).collect(Collectors.toList()));
            }
            catch (Exception ex) {
                System.out.println("[WARN] skip line, error parsing..");
                ex.printStackTrace();
            }
        }
        return fragmentdb;
    }

    private static /* synthetic */ Pair lambda$loadFragments2$1(List line, SimpleSynthonWithContext si) {
        try {
            return Pair.of(LeetSerialization.OBJECT_MAPPER.writeValueAsString(si), Integer.parseInt((String)line.get(2)));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

