/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.chem.injector;

import com.actelion.research.chem.StereoMolecule;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import tech.molecules.leet.chem.ChemUtils;
import tech.molecules.leet.chem.shredder.FragmentDecomposition;
import tech.molecules.leet.chem.shredder.SynthonShredder;

public class InjectorTools {
    public static FragmentDecomposition computeFragmentDecompositionFromSelection(StereoMolecule mi) throws InvalidSelectionException {
        mi.ensureHelperArrays(31);
        ArrayList<Integer> bonds_to_cut = new ArrayList<Integer>();
        for (int zi = 0; zi < mi.getBonds(); ++zi) {
            boolean bb_in;
            int ba = mi.getBondAtom(0, zi);
            int bb = mi.getBondAtom(1, zi);
            boolean ba_in = mi.isSelectedAtom(ba);
            if (!(ba_in ^ (bb_in = mi.isSelectedAtom(bb)))) continue;
            bonds_to_cut.add(zi);
        }
        StereoMolecule m2 = new StereoMolecule(mi);
        m2.ensureHelperArrays(31);
        for (int zi = 0; zi < bonds_to_cut.size(); ++zi) {
            m2.markBondForDeletion(zi);
        }
        int[] amap = m2.deleteMarkedAtomsAndBonds();
        List<Integer> fragatoms = ChemUtils.getSelectedAtoms(mi);
        List<Integer> fragatoms2 = fragatoms.stream().mapToInt(fi -> amap[fi]).boxed().collect(Collectors.toList());
        boolean same_frag = ChemUtils.checkIfAllAtomsAreInSameFragment(m2, fragatoms2);
        if (!same_frag) {
            throw new InvalidSelectionException("Invalid selection containing unconnected atoms");
        }
        SynthonShredder.SplitResult sr = SynthonShredder.trySplit(mi, ChemUtils.toIntArray(bonds_to_cut), 10);
        if (sr == null) {
            throw new InvalidSelectionException("Invalid selection, split did not work..");
        }
        int central_frag = sr.fragment_positions[fragatoms2.get(0)];
        boolean sanity_a = true;
        for (int pa : fragatoms2) {
            if (sanity_a &= sr.fragment_positions[pa] == central_frag) continue;
            throw new Error("fragment positions wrong.. :(");
        }
        FragmentDecomposition fd = new FragmentDecomposition("test", sr, central_frag);
        return fd;
    }

    public static class InvalidSelectionException
    extends Exception {
        public InvalidSelectionException(String msg) {
            super(msg);
        }
    }
}

