/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.chem.mutator;

import com.actelion.research.chem.StereoMolecule;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.ArrayList;
import java.util.List;
import tech.molecules.leet.chem.ChemUtils;
import tech.molecules.leet.chem.mutator.SynthonWithContext;
import tech.molecules.leet.chem.shredder.FragmentDecomposition;
import tech.molecules.leet.chem.shredder.SynthonUtils;

public class FragmentDecompositionSynthon
implements SynthonWithContext {
    @JsonPropertyDescription(value="underlying fragment decomposition")
    @JsonProperty(value="decomp")
    private FragmentDecomposition decomp;
    @JsonPropertyDescription(value="synthon")
    @JsonProperty(value="synthon")
    private StereoMolecule synthon;
    @JsonPropertyDescription(value="context")
    @JsonProperty(value="context")
    private StereoMolecule context;
    @JsonPropertyDescription(value="map from synthon connectors to context connectors")
    @JsonProperty(value="connectorMap")
    private int[][] mapSynthonConnectorsToContextConnectors;

    public FragmentDecompositionSynthon(FragmentDecomposition decomp) {
        int[][] cpos = new int[decomp.getNumberOfConnectors()][2];
        ArrayList<int[]> frag_amaps = new ArrayList<int[]>();
        StereoMolecule combined = decomp.createCombinedFragmentsMoleculeWithLinkerConnectors(cpos, false, frag_amaps);
        this.synthon = new StereoMolecule();
        this.synthon.setFragment(combined.isFragment());
        int[] map_central = new int[combined.getAtoms()];
        this.synthon.addFragment(combined, cpos[0][0], map_central);
        this.synthon.ensureHelperArrays(31);
        this.context = new StereoMolecule();
        this.context.setFragment(combined.isFragment());
        ArrayList<int[]> maps_context = new ArrayList<int[]>();
        for (int zi = 0; zi < cpos.length; ++zi) {
            int[] map_cont_i = new int[combined.getAtoms()];
            this.context.addFragment(combined, cpos[zi][1], map_cont_i);
            maps_context.add(map_cont_i);
        }
        this.context.ensureHelperArrays(31);
        this.mapSynthonConnectorsToContextConnectors = new int[cpos.length][2];
        for (int ci = 0; ci < cpos.length; ++ci) {
            int pos_a = map_central[cpos[ci][0]];
            int pos_b = ((int[])maps_context.get(ci))[cpos[ci][1]];
            this.mapSynthonConnectorsToContextConnectors[ci][0] = pos_a;
            this.mapSynthonConnectorsToContextConnectors[ci][1] = pos_b;
        }
        this.decomp = decomp;
    }

    @Override
    public StereoMolecule getSynthon() {
        return this.synthon;
    }

    @Override
    public StereoMolecule getContext() {
        return this.context;
    }

    @Override
    public StereoMolecule getContext(int depthInBonds) {
        StereoMolecule mi = new StereoMolecule();
        mi.ensureHelperArrays(31);
        StereoMolecule ci = ChemUtils.createProximalFragment(mi, ChemUtils.toIntList(SynthonUtils.findConnectorAtoms(mi)), depthInBonds, false, null);
        ci.ensureHelperArrays(31);
        return ci;
    }

    @Override
    public StereoMolecule getContextBidirectirectional(int depthInBondsSynthon, int depthInBondsContext) {
        int[][] cp_pair_positions = new int[this.decomp.getSplitResult().connector_positions.get(0).length][2];
        ArrayList<int[]> sr_atom_maps = new ArrayList<int[]>();
        StereoMolecule lc = this.decomp.createCombinedFragmentsMoleculeWithLinkerConnectors(cp_pair_positions, true, sr_atom_maps);
        return SynthonUtils.cutBidirectionalContext(lc, cp_pair_positions, depthInBondsSynthon, depthInBondsContext, null);
    }

    @Override
    public int[][] getMapFromSynthonConnectorsToContextConnectors() {
        return this.mapSynthonConnectorsToContextConnectors;
    }

    @Override
    public List<int[][]> computePossibleAssemblies(SynthonWithContext other) {
        return SynthonWithContext.computeAssemblies_MatchingBondAndFirstAtom(this, other);
    }
}

