/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.chem.mutator;

import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.chemicalspaces.synthon.SynthonReactor;
import java.util.ArrayList;
import java.util.List;
import tech.molecules.leet.chem.shredder.SynthonUtils;

public interface SynthonWithContext {
    public StereoMolecule getSynthon();

    public StereoMolecule getContext();

    public StereoMolecule getContext(int var1);

    public StereoMolecule getContextBidirectirectional(int var1, int var2);

    public int[][] getMapFromSynthonConnectorsToContextConnectors();

    public List<int[][]> computePossibleAssemblies(SynthonWithContext var1);

    public static List<int[][]> computeAssemblies_MatchingBondAndFirstAtom(SynthonWithContext a, SynthonWithContext b) {
        int[] map_a = new int[a.getContext().getAtoms()];
        int[] map_b = new int[b.getContext().getAtoms()];
        StereoMolecule ca = SynthonUtils.createConnectorProximalFragment(a.getContext(), 1, map_a);
        StereoMolecule cb = SynthonUtils.createConnectorProximalFragment(b.getContext(), 1, map_b);
        SSSearcher ss = new SSSearcher();
        ss.setMol(ca, cb);
        ss.findFragmentInMolecule();
        ArrayList<int[]> matches = ss.getMatchList();
        ArrayList<int[][]> assemblies = new ArrayList<int[][]>();
        for (int[] mi : matches) {
            int[][] assembly_i = new int[a.getMapFromSynthonConnectorsToContextConnectors().length][];
            for (int zs = 0; zs < assembly_i.length; ++zs) {
                int[] ci = a.getMapFromSynthonConnectorsToContextConnectors()[zs];
                int found = -1;
                for (int zi = 0; zi < mi.length; ++zi) {
                    if (ci[0] != mi[zi]) continue;
                    found = zi;
                    break;
                }
                if (found < 0) {
                    throw new Error("Something wrong..");
                }
                assembly_i[zs] = new int[]{ci[0], found};
            }
            assemblies.add(assembly_i);
        }
        return assemblies;
    }

    public static StereoMolecule annealSynthons(SynthonWithContext a, SynthonWithContext b, int[][] assembly) {
        StereoMolecule a1 = new StereoMolecule(a.getSynthon());
        a1.ensureHelperArrays(31);
        StereoMolecule a2 = new StereoMolecule(b.getSynthon());
        a2.ensureHelperArrays(31);
        for (int zi = 0; zi < assembly.length; ++zi) {
            a1.setAtomicNo(assembly[zi][0], 92 + zi);
            a2.setAtomicNo(assembly[zi][1], 92 + zi);
        }
        ArrayList<StereoMolecule> frags = new ArrayList<StereoMolecule>();
        frags.add(a1);
        frags.add(a2);
        StereoMolecule assembled = SynthonReactor.react(frags);
        assembled.ensureHelperArrays(31);
        return assembled;
    }
}

