/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.chem.shredder;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.CoordinateInventor;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import tech.molecules.leet.chem.ChemUtils;
import tech.molecules.leet.chem.CombinatoricsUtils;
import tech.molecules.leet.chem.mutator.SimpleSynthonWithContext;
import tech.molecules.leet.chem.shredder.SynthonShredder;
import tech.molecules.leet.chem.shredder.SynthonUtils;

public class FragmentDecomposition
implements Serializable {
    @JsonPropertyDescription(value="molecule id")
    @JsonProperty(value="id")
    private String molid;
    @JsonPropertyDescription(value="split result")
    @JsonProperty(value="sr")
    private SynthonShredder.SplitResult splitResult;
    @JsonPropertyDescription(value="central fragment")
    @JsonProperty(value="cf")
    private int centralFrag;

    public FragmentDecomposition(String molid, SynthonShredder.SplitResult si, int central_frag) {
        this.molid = molid;
        this.splitResult = si;
        this.centralFrag = central_frag;
        this.init();
    }

    private void init() {
    }

    public SynthonShredder.SplitResult getSplitResult() {
        return this.splitResult;
    }

    public int getNumberOfConnectors() {
        return this.splitResult.connector_positions.get(0).length;
    }

    public boolean isFragmentDecomposition() {
        return FragmentDecomposition.checkIsFragmentDecomposition(this.splitResult, this.centralFrag);
    }

    public int getMinExtensionSize() {
        List<Integer> to_check = CombinatoricsUtils.intSeq(this.splitResult.fragments.length, Collections.singletonList(this.centralFrag));
        return to_check.stream().mapToInt(ci -> this.splitResult.fragments[ci].getAtoms() - 1).min().getAsInt();
    }

    public List<Integer> getInnerNeighborAtomicNos() {
        StereoMolecule cf = this.getCentralFrag();
        BitSet bs = SynthonUtils.findConnectorAtoms(cf);
        ArrayList<Integer> nbs = new ArrayList<Integer>();
        for (int ci : bs.stream().toArray()) {
            nbs.add(cf.getAtomicNo(cf.getConnAtom(ci, 0)));
        }
        return nbs;
    }

    public StereoMolecule getCentralFrag() {
        return this.splitResult.fragments[this.centralFrag];
    }

    public static boolean checkIsFragmentDecomposition(SynthonShredder.SplitResult si, int central_frag) {
        return Arrays.stream(si.connector_positions.get(central_frag)).allMatch(pi -> pi >= 0);
    }

    public SimpleSynthonWithContext toSimpleSynthonWithContext() {
        StereoMolecule synthon = new StereoMolecule();
        this.getCentralFrag().copyMolecule(synthon);
        int[][] cp_pair_positions = new int[this.getNumberOfConnectors()][];
        ArrayList<int[]> atom_maps = new ArrayList<int[]>();
        StereoMolecule combined = this.createCombinedFragmentsMoleculeWithLinkerConnectors(cp_pair_positions, true, atom_maps);
        int[] map_old_to_new_outer = new int[combined.getAtoms()];
        int[] map_old_to_new_inner = new int[combined.getAtoms()];
        StereoMolecule cut_outer = SynthonUtils.cutBidirectionalContext(combined, cp_pair_positions, 0, 1, map_old_to_new_outer);
        StereoMolecule cut_inner = SynthonUtils.cutBidirectionalContext(combined, cp_pair_positions, 100000, 0, map_old_to_new_inner);
        List<Integer> outer_toRemove = ChemUtils.toIntList(ChemUtils.findAtomsWithAtomicNo(cut_outer, 92));
        List<Integer> inner_toRemove = ChemUtils.toIntList(ChemUtils.findAtomsWithAtomicNo(cut_inner, 93));
        for (int ori : outer_toRemove) {
            cut_outer.markAtomForDeletion(ori);
        }
        for (int iri : inner_toRemove) {
            cut_inner.markAtomForDeletion(iri);
        }
        int[] outer_amap = cut_outer.deleteMarkedAtomsAndBonds();
        int[] inner_amap = cut_inner.deleteMarkedAtomsAndBonds();
        cut_inner.ensureHelperArrays(31);
        cut_outer.ensureHelperArrays(1);
        for (int ci : ChemUtils.findAtomsWithAtomicNo(cut_outer, 93).stream().toArray()) {
            cut_outer.setAtomicNo(ci, 92);
        }
        cut_outer.ensureHelperArrays(31);
        int[][] cp_pair_positions_2 = new int[this.getNumberOfConnectors()][];
        for (int zi = 0; zi < cp_pair_positions.length; ++zi) {
            cp_pair_positions_2[zi] = new int[]{inner_amap[map_old_to_new_inner[cp_pair_positions[zi][0]]], outer_amap[map_old_to_new_outer[cp_pair_positions[zi][1]]]};
        }
        return new SimpleSynthonWithContext(cut_inner, cut_outer, cp_pair_positions_2);
    }

    public int[][] getConnectorPairs() {
        List<Integer> rfrags = CombinatoricsUtils.intSeq(0, this.splitResult.fragments.length, Collections.singletonList(this.centralFrag));
        int[][] connectorPairs = new int[rfrags.size()][];
        for (int zi = 0; zi < rfrags.size(); ++zi) {
            int cxi = -1;
            for (int zj = 0; zj < this.splitResult.connector_positions.get(rfrags.get(zi)).length; ++zj) {
                if (this.splitResult.connector_positions.get(rfrags.get(zi))[zj] < 0) continue;
                cxi = zj;
                break;
            }
            int pos_cf = this.splitResult.connector_positions.get(this.centralFrag)[cxi];
            connectorPairs[zi] = new int[]{pos_cf, this.splitResult.connector_positions.get(rfrags.get(zi))[cxi]};
        }
        return connectorPairs;
    }

    public StereoMolecule createCombinedFragmentsMolecule() {
        StereoMolecule ma = new StereoMolecule();
        for (int zf = 0; zf < this.splitResult.fragments.length; ++zf) {
            StereoMolecule fi = this.splitResult.fragments[zf];
            StereoMolecule fi_copy = new StereoMolecule(fi);
            fi_copy.ensureHelperArrays(31);
            int[] amap = new int[fi_copy.getAtoms()];
            ma.addFragment(fi_copy, 0, amap);
        }
        ma.ensureHelperArrays(31);
        return ma;
    }

    public StereoMolecule createCombinedFragmentsMoleculeWithLinkerConnectors(int[][] cp_pair_positions, boolean addConnectorConnectorBonds, List<int[]> atom_maps) {
        StereoMolecule ma = new StereoMolecule();
        ArrayList<int[]> amaps = new ArrayList<int[]>();
        for (int zf = 0; zf < this.splitResult.fragments.length; ++zf) {
            StereoMolecule fi = this.splitResult.fragments[zf];
            StereoMolecule fi_copy = new StereoMolecule(fi);
            fi_copy.ensureHelperArrays(31);
            int[] amap = new int[fi_copy.getAtoms()];
            ma.addFragment(fi_copy, 0, amap);
            amaps.add(amap);
            atom_maps.add(amap);
        }
        int num_connectors = this.splitResult.connector_positions.get(this.centralFrag).length;
        if (num_connectors > 1) {
            // empty if block
        }
        for (int zc = 0; zc < num_connectors; ++zc) {
            int cfpos = this.splitResult.connector_positions.get(this.centralFrag)[zc];
            for (int zo : CombinatoricsUtils.intSeq(this.splitResult.fragments.length, Collections.singletonList(this.centralFrag))) {
                if (this.splitResult.connector_positions.get(zo)[zc] < 0) continue;
                int cfposnew = ((int[])amaps.get(this.centralFrag))[cfpos];
                int oposnew = ((int[])amaps.get(zo))[this.splitResult.connector_positions.get(zo)[zc]];
                if (cp_pair_positions != null && cp_pair_positions.length > zc) {
                    cp_pair_positions[zc] = new int[]{cfposnew, oposnew};
                }
                if (addConnectorConnectorBonds) {
                    ma.addBond(cfposnew, oposnew, 1);
                }
                ma.setAtomicNo(oposnew, 93);
            }
        }
        ma.ensureHelperArrays(31);
        return ma;
    }

    public StereoMolecule getBidirectionalConnectorProximalRegion(int region_size) {
        int[][] cp_pair_positions = new int[this.splitResult.connector_positions.get(0).length][2];
        ArrayList<int[]> atom_maps = new ArrayList<int[]>();
        StereoMolecule lc = this.createCombinedFragmentsMoleculeWithLinkerConnectors(cp_pair_positions, true, atom_maps);
        StereoMolecule all_prs = new StereoMolecule();
        all_prs.setFragment(true);
        for (int zp = 0; zp < cp_pair_positions.length; ++zp) {
            List<Integer> seed_atoms = Arrays.stream(cp_pair_positions[zp]).boxed().collect(Collectors.toList());
            StereoMolecule mi_a = ChemUtils.createProximalFragment(lc, seed_atoms, region_size, true, null);
            all_prs.addFragment(mi_a, 0, null);
        }
        all_prs.ensureHelperArrays(31);
        return all_prs;
    }

    public StereoMolecule getFragmentsWithHighlighting() {
        StereoMolecule ma = new StereoMolecule();
        int[] map_highlighting = null;
        for (int zf = 0; zf < this.splitResult.fragments.length; ++zf) {
            StereoMolecule fi = this.splitResult.fragments[zf];
            StereoMolecule fi_copy = new StereoMolecule(fi);
            fi_copy.ensureHelperArrays(31);
            int[] amap = new int[fi_copy.getAtoms()];
            ma.addFragment(fi_copy, 0, amap);
            if (zf != this.centralFrag) continue;
            map_highlighting = amap;
        }
        ChemUtils.highlightBondsInBetweenAtoms(ma, ChemUtils.toBitSet(map_highlighting));
        ma.ensureHelperArrays(31);
        CoordinateInventor ci = new CoordinateInventor();
        ci.invent(ma);
        return ma;
    }
}

