/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.chem.shredder;

import com.actelion.research.calc.combinatorics.CombinationGenerator;
import com.actelion.research.chem.StereoMolecule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import tech.molecules.leet.chem.ChemUtils;
import tech.molecules.leet.chem.mutator.FragmentDecompositionSynthon;
import tech.molecules.leet.chem.shredder.FragmentDecomposition;
import tech.molecules.leet.chem.shredder.SynthonShredder;
import tech.molecules.leet.chem.shredder.SynthonUtils;

public class FragmentDecompositionShredder {
    public static List<SynthonShredder.SplitResult> computeSplitResults(StereoMolecule m, int min_splits, int max_splits, int max_fragments, Set<List<Integer>> atom_pairs_to_cut, boolean prevent_adjacent_cuts, boolean cut_ring_bonds, boolean cut_single_bonds, boolean cut_double_bonds, boolean cut_triple_bonds) {
        m.ensureHelperArrays(31);
        ArrayList<Integer> bonds_for_cuts = new ArrayList<Integer>();
        for (int zi = 0; zi < m.getBonds(); ++zi) {
            int abb;
            ArrayList<Integer> bi = new ArrayList<Integer>();
            int aba = m.getAtomicNo(m.getBondAtom(0, zi));
            if (aba < (abb = m.getAtomicNo(m.getBondAtom(1, zi)))) {
                bi.add(aba);
                bi.add(abb);
            } else {
                bi.add(abb);
                bi.add(aba);
            }
            if (!atom_pairs_to_cut.contains(bi) || !cut_ring_bonds && m.isRingBond(zi)) continue;
            int bond_order = m.getBondOrder(zi);
            if (!cut_single_bonds && bond_order == 1 || !cut_double_bonds && bond_order == 2 || !cut_triple_bonds && bond_order == 3) continue;
            bonds_for_cuts.add(zi);
        }
        ArrayList<SynthonShredder.SplitResult> all_split_results = new ArrayList<SynthonShredder.SplitResult>();
        for (int splits = min_splits; splits <= max_splits; ++splits) {
            if (bonds_for_cuts.size() < splits) continue;
            List<int[]> all_cuts = CombinationGenerator.getAllOutOf(bonds_for_cuts.size(), splits);
            List all_edge_cuts = all_cuts.parallelStream().map(aci -> Arrays.stream(aci).map(ei -> (Integer)bonds_for_cuts.get(ei)).toArray()).collect(Collectors.toList());
            if (prevent_adjacent_cuts) {
                all_edge_cuts = all_edge_cuts.parallelStream().filter(ei -> !ChemUtils.checkForAdjacentBonds(m, ei)).collect(Collectors.toList());
            }
            List split_results = all_edge_cuts.parallelStream().map(xi -> SynthonShredder.trySplit(m, xi, max_fragments)).filter(si -> si != null).collect(Collectors.toList());
            all_split_results.addAll(split_results);
        }
        return all_split_results;
    }

    public static List<FragmentDecomposition> computeFragmentDecompositions(StereoMolecule m, String moleculeId, int max_fragment_size, double max_relative_fragment_size, int min_extension_size, int max_splits) {
        Set<List<Integer>> edgesToConsider = FragmentDecompositionShredder.createIntPairList(new int[][]{{6, 6}, {6, 7}, {6, 8}, {6, 9}, {6, 16}, {6, 17}, {6, 35}});
        List<SynthonShredder.SplitResult> splits = FragmentDecompositionShredder.computeSplitResults(m, 1, max_splits, max_splits + 1, edgesToConsider, true, false, true, false, false);
        ArrayList<FragmentDecomposition> decompositions = new ArrayList<FragmentDecomposition>();
        for (int zi = 0; zi < splits.size(); ++zi) {
            SynthonShredder.SplitResult sri = splits.get(zi);
            for (int zf = 0; zf < sri.fragments.length; ++zf) {
                FragmentDecomposition fdi;
                if (!FragmentDecomposition.checkIsFragmentDecomposition(sri, zf)) continue;
                double total_size = Arrays.stream(sri.fragments).mapToInt(fi -> SynthonUtils.countNonConnectorAtoms(fi)).sum();
                double size_i = SynthonUtils.countNonConnectorAtoms(sri.fragments[zf]);
                double rel_frag_size = size_i / total_size;
                if (!(size_i <= (double)max_fragment_size) || !(rel_frag_size < max_relative_fragment_size) || (fdi = new FragmentDecomposition(moleculeId, sri, zf)).getMinExtensionSize() < min_extension_size) continue;
                decompositions.add(fdi);
            }
        }
        return decompositions;
    }

    public static Set<List<Integer>> createIntPairList(int[][] pairs) {
        HashSet<List<Integer>> set = new HashSet<List<Integer>>();
        for (int zi = 0; zi < pairs.length; ++zi) {
            ArrayList<Integer> li = new ArrayList<Integer>();
            li.add(pairs[zi][0]);
            li.add(pairs[zi][1]);
            set.add(li);
        }
        return set;
    }

    public static void main(String[] args) {
        String ma = "";
        StereoMolecule mi = ChemUtils.parseIDCode(ma);
        List<FragmentDecomposition> decompositions = FragmentDecompositionShredder.computeFragmentDecompositions(mi, "test", 16, 0.4, 3, 4);
        List<StereoMolecule> mols = decompositions.stream().map(di -> di.getFragmentsWithHighlighting()).collect(Collectors.toList());
        List<StereoMolecule> mols_1 = decompositions.stream().map(di -> di.getBidirectionalConnectorProximalRegion(1)).collect(Collectors.toList());
        List<StereoMolecule> mols_2 = decompositions.stream().map(di -> di.getBidirectionalConnectorProximalRegion(2)).collect(Collectors.toList());
        List<StereoMolecule> mols_3 = decompositions.stream().map(di -> new FragmentDecompositionSynthon((FragmentDecomposition)di).getContextBidirectirectional(3, 2)).collect(Collectors.toList());
        List<StereoMolecule> mols_4 = decompositions.stream().map(di -> new FragmentDecompositionSynthon((FragmentDecomposition)di).getContextBidirectirectional(1, 1)).collect(Collectors.toList());
        ChemUtils.DebugOutput.plotMolecules("test", mols.toArray(new StereoMolecule[0]), 8, 8);
        ChemUtils.DebugOutput.plotMolecules("test1", mols_1.toArray(new StereoMolecule[0]), 8, 8);
        ChemUtils.DebugOutput.plotMolecules("test2", mols_2.toArray(new StereoMolecule[0]), 8, 8);
        ChemUtils.DebugOutput.plotMolecules("test3", mols_3.toArray(new StereoMolecule[0]), 8, 8);
        ChemUtils.DebugOutput.plotMolecules("test4", mols_4.toArray(new StereoMolecule[0]), 8, 8);
        System.out.println("mkay");
    }
}

