/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.chem.shredder;

import com.actelion.research.calc.combinatorics.CombinationGenerator;
import com.actelion.research.chem.SmilesParser;
import com.actelion.research.chem.StereoMolecule;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import tech.molecules.leet.chem.ChemUtils;
import tech.molecules.leet.chem.CombinatoricsUtils;

public class SynthonShredder {
    public static int MAX_CONNECTORS = 8;
    public static int logLevel_A = 0;

    public static List<SplitResult> getAllSplitVariations(SplitResult si, int num_connectors) {
        ArrayList<SplitResult> results = new ArrayList<SplitResult>();
        ArrayList<Integer> connectors = new ArrayList<Integer>();
        for (int zi = 0; zi < num_connectors; ++zi) {
            connectors.add(zi);
        }
        List<List<Integer>> connector_permutations = CombinatoricsUtils.all_permutations(connectors);
        int[] connector_atoms = new int[]{92, 93, 94, 95};
        for (List<Integer> connector_perm : connector_permutations) {
            String cutset_perm_hash = connector_perm.stream().map(xi -> "" + xi).collect(Collectors.joining(";"));
            StereoMolecule[] frag_copy = new StereoMolecule[si.fragments.length];
            ArrayList<Set<Integer>> connector_config = new ArrayList<Set<Integer>>();
            for (int fi = 0; fi < si.fragments.length; ++fi) {
                StereoMolecule frag_i = si.fragments[fi];
                HashSet<Integer> connectors_i = new HashSet<Integer>();
                for (int zi = 0; zi < frag_i.getAtoms(); ++zi) {
                    if (frag_i.getAtomicNo(zi) != 92 && frag_i.getAtomicNo(zi) != 93 && frag_i.getAtomicNo(zi) != 94 && frag_i.getAtomicNo(zi) != 95) continue;
                    if (frag_i.getAtomColor(zi) == 64) {
                        frag_i.setAtomicNo(zi, connector_atoms[connector_perm.get(0)]);
                        connectors_i.add(connector_atoms[connector_perm.get(0)]);
                        continue;
                    }
                    if (frag_i.getAtomColor(zi) == 128) {
                        frag_i.setAtomicNo(zi, connector_atoms[connector_perm.get(1)]);
                        connectors_i.add(connector_atoms[connector_perm.get(1)]);
                        continue;
                    }
                    if (frag_i.getAtomColor(zi) == 320) {
                        frag_i.setAtomicNo(zi, connector_atoms[connector_perm.get(2)]);
                        connectors_i.add(connector_atoms[connector_perm.get(2)]);
                        continue;
                    }
                    if (frag_i.getAtomColor(zi) == 256) {
                        frag_i.setAtomicNo(zi, connector_atoms[connector_perm.get(3)]);
                        connectors_i.add(connector_atoms[connector_perm.get(3)]);
                        continue;
                    }
                    System.out.println("something wrong?..");
                }
                connector_config.add(connectors_i);
                StereoMolecule sm_cfi = new StereoMolecule(frag_i);
                sm_cfi.ensureHelperArrays(31);
                frag_copy[fi] = sm_cfi;
            }
            results.add(new SplitResult(frag_copy, connector_config, si.cutset_hash + "_p_" + cutset_perm_hash, si.connector_positions, si.fragment_positions));
        }
        return results;
    }

    public static SplitResult trySplit(StereoMolecule mol, int[] bond_cutset, int max_fragments) {
        StereoMolecule[] frags;
        int zi;
        int BOND_HANDLING_MODE = 2;
        int[] si = bond_cutset;
        int num_splits = bond_cutset.length;
        StereoMolecule mi = new StereoMolecule(mol);
        mi.ensureHelperArrays(1);
        HashMap<Integer, int[]> bond_atom_indices = new HashMap<Integer, int[]>();
        HashMap<Integer, Integer> bond_types = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> bond_qfs = new HashMap<Integer, Integer>();
        for (zi = 0; zi < si.length; ++zi) {
            int[] ai = new int[]{mi.getBondAtom(0, si[zi]), mi.getBondAtom(1, si[zi])};
            bond_atom_indices.put(zi, ai);
            bond_types.put(zi, mi.getBondType(si[zi]));
            bond_qfs.put(zi, mi.getBondQueryFeatures(zi));
        }
        for (zi = 0; zi < si.length; ++zi) {
            mi.markBondForDeletion(si[zi]);
        }
        int[] new_atom_pos = mi.deleteMarkedAtomsAndBonds();
        for (int zi2 = 0; zi2 < si.length; ++zi2) {
            int ba = new_atom_pos[((int[])bond_atom_indices.get(zi2))[0]];
            int bb = new_atom_pos[((int[])bond_atom_indices.get(zi2))[1]];
            int a_new = -1;
            int b_new = -1;
            if (BOND_HANDLING_MODE == 1) {
                int bond_type = (Integer)bond_types.get(zi2);
                a_new = mi.addAtom(92);
                b_new = mi.addAtom(92);
                mi.addBond(ba, a_new, bond_type);
                mi.addBond(bb, b_new, bond_type);
            } else if (BOND_HANDLING_MODE == 2) {
                a_new = mi.addAtom(92);
                b_new = mi.addAtom(92);
                mol.copyBond(mi, si[zi2], -1, -1, ba, a_new, true);
                mol.copyBond(mi, si[zi2], -1, -1, bb, b_new, true);
            } else if (BOND_HANDLING_MODE == 3) {
                // empty if block
            }
            if (zi2 == 0) {
                mi.setAtomColor(a_new, 64);
                mi.setAtomColor(b_new, 64);
            }
            if (zi2 == 1) {
                mi.setAtomColor(a_new, 128);
                mi.setAtomColor(b_new, 128);
            }
            if (zi2 == 2) {
                mi.setAtomColor(a_new, 320);
                mi.setAtomColor(b_new, 320);
            }
            if (zi2 != 3) continue;
            mi.setAtomColor(a_new, 256);
            mi.setAtomColor(b_new, 256);
        }
        mi.ensureHelperArrays(1);
        int[] fragmentNo = new int[mi.getAllAtoms()];
        int fragments = mi.getFragmentNumbers(fragmentNo, false, false);
        for (StereoMolecule fi : frags = mi.getFragments(fragmentNo, fragments)) {
            fi.ensureHelperArrays(31);
        }
        if (num_splits > 0 && frags.length == 1) {
            return null;
        }
        if (max_fragments < frags.length) {
            return null;
        }
        ArrayList<int[]> connector_positions = new ArrayList<int[]>();
        boolean split_unsuccessful = false;
        for (StereoMolecule fi : frags) {
            int[] connector_positions_i = new int[num_splits];
            Arrays.fill(connector_positions_i, -1);
            int cb = 0;
            int cr = 0;
            int co = 0;
            int cm = 0;
            for (int zi3 = 0; zi3 < fi.getAtoms(); ++zi3) {
                if (fi.getAtomColor(zi3) == 64) {
                    connector_positions_i[0] = zi3;
                    ++cb;
                }
                if (fi.getAtomColor(zi3) == 128) {
                    connector_positions_i[1] = zi3;
                    ++cr;
                }
                if (fi.getAtomColor(zi3) == 320) {
                    connector_positions_i[2] = zi3;
                    ++co;
                }
                if (fi.getAtomColor(zi3) != 256) continue;
                connector_positions_i[3] = zi3;
                ++cm;
            }
            if (cb >= 2 || cr >= 2 || co >= 2 || cm >= 2) {
                split_unsuccessful = true;
                continue;
            }
            connector_positions.add(connector_positions_i);
        }
        if (split_unsuccessful) {
            return null;
        }
        if (logLevel_A > 1) {
            System.out.println("Split OK!");
            if (logLevel_A > 2) {
                System.out.println(Arrays.stream(frags).map(mxi -> ChemUtils.idcodeToSmiles(mxi.getIDCode())).reduce((x, y) -> x + "." + y));
                System.out.println("ok");
            }
        }
        if (logLevel_A > 0) {
            System.out.println("split: " + num_splits + " -> frags: " + frags.length);
            if (logLevel_A > 2) {
                for (int zi4 = 0; zi4 < frags.length; ++zi4) {
                    System.out.println(ChemUtils.idcodeToSmiles(frags[zi4].getIDCode()));
                    if (logLevel_A <= 1 || !ChemUtils.idcodeToSmiles(frags[zi4].getIDCode()).equals("Cc1ccc(C(c(cccc2)c2C([U])=O)[U])cc1")) continue;
                    System.out.println("ok");
                }
            }
        }
        HashMap<StereoMolecule, Integer> frag_order_before_sort = new HashMap<StereoMolecule, Integer>();
        for (int zi5 = 0; zi5 < frags.length; ++zi5) {
            frags[zi5].ensureHelperArrays(1);
            frag_order_before_sort.put(frags[zi5], zi5);
        }
        List<Integer> fraglist = CombinatoricsUtils.intSeq(frags.length);
        fraglist.sort((x, y) -> -Integer.compare(frags[x].getBonds(), frags[y].getBonds()) != 0 ? -Integer.compare(frags[x].getBonds(), frags[y].getBonds()) : frags[x].getIDCode().compareTo(frags[y].getIDCode()));
        StereoMolecule[] frags_sorted = new StereoMolecule[frags.length];
        for (int zi6 = 0; zi6 < frags_sorted.length; ++zi6) {
            frags_sorted[zi6] = frags[fraglist.get(zi6)];
        }
        int[] fragmentNo_sorted = new int[fragmentNo.length];
        for (int zi7 = 0; zi7 < fragmentNo_sorted.length; ++zi7) {
            fragmentNo_sorted[zi7] = fraglist.get(fragmentNo[zi7]);
        }
        ArrayList<int[]> sorted_connector_pos = new ArrayList<int[]>();
        for (StereoMolecule fi : frags_sorted) {
            sorted_connector_pos.add((int[])connector_positions.get((Integer)frag_order_before_sort.get(fi)));
        }
        String hash_bond_cutset = "cs_" + Arrays.stream(bond_cutset).mapToObj(xi -> "" + xi).collect(Collectors.joining(","));
        return new SplitResult(frags_sorted, null, hash_bond_cutset, sorted_connector_pos, fragmentNo_sorted);
    }

    public static List<SplitResult> computeAllSplitResults(StereoMolecule mi, int num_splits, int max_fragments) {
        mi.ensureHelperArrays(31);
        int nb = mi.getBonds();
        List<int[]> combi_list = CombinationGenerator.getAllOutOf(nb, num_splits);
        if (combi_list == null) {
            return new ArrayList<SplitResult>();
        }
        List splits = combi_list.stream().filter(ci -> ((int[])ci).length == num_splits).collect(Collectors.toList());
        ArrayList<SplitResult> split_results = new ArrayList<SplitResult>();
        for (int[] split_pattern : splits) {
            SplitResult split_result = SynthonShredder.trySplit(mi, split_pattern, max_fragments);
            if (split_result == null) continue;
            split_results.add(split_result);
        }
        return split_results;
    }

    public static void main(String[] args) {
        SynthonShredder.run_test_01();
    }

    private static void run_test_01() {
        SmilesParser spa = new SmilesParser();
        StereoMolecule ma = new StereoMolecule();
        try {
            spa.parse(ma, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int max_splits = 5;
        int max_fragments = 6;
        long ts_2_a = System.currentTimeMillis();
        HashMap split_results_via_binary_splits = new HashMap();
        long ts_2_b = System.currentTimeMillis();
        System.out.println("Time= " + (ts_2_b - ts_2_a) + " ms");
        long ts_a = System.currentTimeMillis();
        ArrayList<int[]> combi_list = new ArrayList<int[]>();
        for (int zs = 1; zs <= max_splits; ++zs) {
            combi_list.addAll(CombinationGenerator.getAllOutOf(ma.getBonds(), zs));
        }
        ArrayList<SplitResult> good_splits = new ArrayList<SplitResult>();
        HashMap split_results_conventional = new HashMap();
        ArrayList<int[]> splits = combi_list;
        for (int[] si : splits) {
            SplitResult split_result = SynthonShredder.trySplit(ma, si, max_fragments);
            Set sis = Arrays.stream(si).mapToObj(ii -> ii).collect(Collectors.toSet());
            if (split_result == null) continue;
            good_splits.add(split_result);
            split_results_conventional.put(sis, split_result);
        }
        long ts_b = System.currentTimeMillis();
        System.out.println("time= " + (ts_b - ts_a) + " ms");
        System.out.println("Bye!");
        HashSet combined = new HashSet();
        combined.addAll(split_results_conventional.keySet());
        combined.addAll(split_results_via_binary_splits.keySet());
        for (Set si : combined) {
            System.out.println();
            System.out.println("si= " + si.toString());
            boolean in_a = split_results_via_binary_splits.containsKey(si);
            boolean in_b = split_results_conventional.containsKey(si);
            System.out.println("A: " + in_a + "  B: " + in_b);
            if (!in_a && in_b) {
                System.out.println(((SplitResult)split_results_conventional.get(si)).toString());
            }
            if (!in_a || in_b) continue;
            System.out.println(((SplitResult)split_results_via_binary_splits.get(si)).toString());
        }
        System.out.println("ok!");
    }

    public static String encodeConnectorConfig(List<BitSet> connector_sets) {
        connector_sets.sort((ba, bb) -> SynthonShredder.compareBitsets(ba, bb));
        List ssets = connector_sets.stream().map(bi -> SynthonShredder.createBitSetString(bi, MAX_CONNECTORS)).collect(Collectors.toList());
        return String.join((CharSequence)";", ssets);
    }

    public static List<BitSet> decodeConnectorConfig(String cc) {
        String[] splits = cc.split(";");
        ArrayList<BitSet> result = new ArrayList<BitSet>();
        for (String si : splits) {
            BitSet bsi = SynthonShredder.parseBitSetString(si);
            result.add(bsi);
        }
        return result;
    }

    public static int compareBitsets(BitSet lhs, BitSet rhs) {
        if (lhs.equals(rhs)) {
            return 0;
        }
        BitSet xor = (BitSet)lhs.clone();
        xor.xor(rhs);
        int firstDifferent = xor.length() - 1;
        if (firstDifferent == -1) {
            return 0;
        }
        return rhs.get(firstDifferent) ? 1 : -1;
    }

    public static String createBitSetString(BitSet bs, int length) {
        StringBuilder sb = new StringBuilder();
        for (int zi = 0; zi < length; ++zi) {
            sb.append(bs.get(zi) ? "1" : "0");
        }
        return sb.toString();
    }

    public static BitSet parseBitSetString(String si) {
        char[] seq = si.toCharArray();
        BitSet bsi = new BitSet(si.length());
        for (int zi = 0; zi < si.length(); ++zi) {
            if (seq[zi] == '1') {
                bsi.set(zi);
                continue;
            }
            if (seq[zi] == '0') continue;
            System.out.println("ERROR: problem parsing BitSetString, encountered character: " + seq[zi]);
        }
        return bsi;
    }

    public static final class SplitResult
    implements Serializable {
        @JsonPropertyDescription(value="fragments sorted by largest first")
        @JsonProperty(value="fragments")
        public final StereoMolecule[] fragments;
        @JsonPropertyDescription(value="connector counts")
        @JsonProperty(value="ccounts")
        public final List<Integer> connector_counts;
        @JsonPropertyDescription(value="connector config")
        @JsonProperty(value="cconfig")
        public final String connector_config;
        @JsonPropertyDescription(value="cutest hash")
        @JsonProperty(value="cutsethash")
        public final String cutset_hash;
        @JsonPropertyDescription(value="connector positions")
        @JsonProperty(value="cpos")
        public final List<int[]> connector_positions;
        @JsonPropertyDescription(value="fragment positions, i.e. map from original molecule atoms to fragment no")
        @JsonProperty(value="fragpos")
        public final int[] fragment_positions;

        public SplitResult(StereoMolecule[] fragments, List<Set<Integer>> connector_config_pre, String cutset_hash, List<int[]> connector_positions, int[] fragmentPos) {
            ArrayList<BitSet> connector_config = new ArrayList<BitSet>();
            if (connector_config_pre != null) {
                for (Set<Integer> si : connector_config_pre) {
                    BitSet bsi = new BitSet();
                    si.stream().forEach(zi -> bsi.set(zi >= 92 ? zi - 92 : zi));
                    connector_config.add(bsi);
                }
            }
            this.connector_config = connector_config == null ? null : SynthonShredder.encodeConnectorConfig(connector_config);
            this.connector_counts = new ArrayList<Integer>();
            for (int[] cpi : connector_positions) {
                int cnt_a = 0;
                for (int zi2 = 0; zi2 < cpi.length; ++zi2) {
                    if (cpi[zi2] < 0) continue;
                    ++cnt_a;
                }
                this.connector_counts.add(cnt_a);
            }
            this.connector_counts.sort((x, y) -> -Integer.compare(x, y));
            this.fragments = fragments;
            this.cutset_hash = cutset_hash;
            this.connector_positions = connector_positions;
            this.fragment_positions = fragmentPos;
        }

        public List<StereoMolecule[]> getAllSplitsWithUniqueConnectors() {
            int num_connectors = this.connector_positions.iterator().next().length;
            ArrayList<Integer> connectors_to_use = new ArrayList<Integer>();
            for (int zi = 92; zi < 92 + num_connectors; ++zi) {
                connectors_to_use.add(zi);
            }
            return this.getAllSplitsWithUniqueConnectors(connectors_to_use);
        }

        public List<StereoMolecule[]> getAllSplitsWithUniqueConnectors(List<Integer> connectors_to_use) {
            int num_connectors = this.connector_positions.iterator().next().length;
            ArrayList<StereoMolecule[]> results = new ArrayList<StereoMolecule[]>();
            List<List<Integer>> all_conni_perms = CombinatoricsUtils.all_permutations(connectors_to_use);
            for (List<Integer> pi : all_conni_perms) {
                StereoMolecule[] si = new StereoMolecule[this.fragments.length];
                for (int zi = 0; zi < this.fragments.length; ++zi) {
                    StereoMolecule fi = new StereoMolecule(this.fragments[zi]);
                    fi.ensureHelperArrays(1);
                    for (int zj = 0; zj < num_connectors; ++zj) {
                        int cpij = this.connector_positions.get(zi)[zj];
                        if (cpij < 0) continue;
                        fi.setAtomicNo(cpij, pi.get(zj));
                    }
                    fi.ensureHelperArrays(31);
                    si[zi] = fi;
                }
                results.add(si);
            }
            return results;
        }

        public String toString() {
            String smiles = "Smiles= " + Arrays.stream(this.fragments).map(fi -> ChemUtils.idcodeToSmiles(fi.getIDCode())).collect(Collectors.joining("."));
            String idc = "idcode= " + Arrays.stream(this.fragments).map(fi -> ChemUtils.idcodeToSmiles(fi.getIDCode())).collect(Collectors.joining(" ::: "));
            return smiles + " ;; " + idc;
        }
    }
}

