/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.chem.shredder;

import com.actelion.research.chem.StereoMolecule;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import tech.molecules.leet.chem.QueryFeatureUtils;
import tech.molecules.leet.chem.shredder.SynthonShredder;

public class SynthonUtils {
    public static int countNonConnectorAtoms(StereoMolecule mi) {
        mi.ensureHelperArrays(1);
        int count = 0;
        for (int zi = 0; zi < mi.getAtoms(); ++zi) {
            count += mi.getAtomicNo(zi) > 88 ? 0 : 1;
        }
        return count;
    }

    public static BitSet findConnectorAtoms(StereoMolecule mi) {
        BitSet bs = new BitSet();
        mi.ensureHelperArrays(1);
        for (int zi = 0; zi < mi.getAtoms(); ++zi) {
            if (mi.getAtomicNo(zi) < 88) continue;
            bs.set(zi);
        }
        return bs;
    }

    public static void removeConnectors(StereoMolecule m) {
        m.ensureHelperArrays(1);
        for (int zi = 0; zi < m.getAtoms(); ++zi) {
            if (m.getAtomicNo(zi) < 88) continue;
            m.markAtomForDeletion(zi);
        }
        m.deleteMarkedAtomsAndBonds();
        m.ensureHelperArrays(31);
    }

    public static StereoMolecule createConnectorProximalFragment(StereoMolecule mi_pre, int connector_region_size, int[] atommap) {
        StereoMolecule mi_conn = new StereoMolecule(mi_pre);
        QueryFeatureUtils.removeNarrowingQueryFeatures(mi_conn);
        mi_conn.ensureHelperArrays(31);
        ArrayList<Integer> connector_positions = new ArrayList<Integer>();
        for (int zi = 0; zi < mi_conn.getAtoms(); ++zi) {
            int an = mi_conn.getAtomicNo(zi);
            if (an < 92 || an >= 92 + SynthonShredder.MAX_CONNECTORS) continue;
            connector_positions.add(zi);
            mi_conn.setAtomicNo(zi, 92);
        }
        boolean[] keep_atoms = new boolean[mi_conn.getAtoms()];
        for (int zi = 0; zi < mi_conn.getAtoms(); ++zi) {
            Iterator iterator = connector_positions.iterator();
            while (iterator.hasNext()) {
                int ci = (Integer)iterator.next();
                int path_length = mi_conn.getPathLength(ci, zi, connector_region_size, null);
                if (path_length < 0 || path_length > connector_region_size) continue;
                keep_atoms[zi] = true;
            }
        }
        StereoMolecule mi_cut = new StereoMolecule();
        mi_conn.copyMoleculeByAtoms(mi_cut, keep_atoms, true, atommap);
        mi_cut.ensureHelperArrays(31);
        return mi_cut;
    }

    public static StereoMolecule cutBidirectionalContext(StereoMolecule bdc, int[][] cp_pair_positions, int depthInBondsSynthon, int depthInBondsContext, int[] map_old_to_new) {
        StereoMolecule all_prs = new StereoMolecule();
        all_prs.setFragment(true);
        if (map_old_to_new != null) {
            for (int zi = 0; zi < map_old_to_new.length; ++zi) {
                map_old_to_new[zi] = -1;
            }
        }
        for (int zp = 0; zp < cp_pair_positions.length; ++zp) {
            int pos_inner = cp_pair_positions[zp][0];
            int pos_outer = cp_pair_positions[zp][1];
            StereoMolecule mi_conn = bdc;
            mi_conn.ensureHelperArrays(31);
            boolean[] keep_atoms = new boolean[mi_conn.getAtoms()];
            for (int zi = 0; zi < mi_conn.getAtoms(); ++zi) {
                if (zi == pos_inner) {
                    keep_atoms[zi] = true;
                    continue;
                }
                if (zi == pos_outer) {
                    keep_atoms[zi] = true;
                    continue;
                }
                int path_length_inner = mi_conn.getPathLength(pos_inner, zi);
                int path_length_outer = mi_conn.getPathLength(pos_outer, zi);
                if (path_length_inner < 0 && path_length_outer < 0) continue;
                if (path_length_inner >= 0 && path_length_inner < path_length_outer && path_length_inner <= depthInBondsSynthon) {
                    keep_atoms[zi] = true;
                }
                if (path_length_outer < 0 || path_length_outer >= path_length_inner || path_length_outer > depthInBondsContext) continue;
                keep_atoms[zi] = true;
            }
            int[] c_amap1 = new int[mi_conn.getAtoms()];
            StereoMolecule mi_cut = new StereoMolecule();
            mi_cut.setFragment(true);
            mi_conn.copyMoleculeByAtoms(mi_cut, keep_atoms, true, c_amap1);
            mi_cut.ensureHelperArrays(31);
            int[] c_amap2 = new int[mi_cut.getAtoms()];
            all_prs.addFragment(mi_cut, 0, c_amap2);
            for (int zi = 0; zi < bdc.getAtoms(); ++zi) {
                if (map_old_to_new == null || map_old_to_new.length <= zi || c_amap1[zi] < 0) continue;
                map_old_to_new[zi] = c_amap2[c_amap1[zi]];
            }
        }
        all_prs.ensureHelperArrays(31);
        return all_prs;
    }
}

