/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.io;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CSVIterator
implements Iterator<List<String>> {
    String file;
    BufferedReader in;
    boolean skip_first;
    List<Integer> col_idx;
    boolean next_line_fetched = false;
    String last_line = null;
    List<String> last_extracted = new ArrayList<String>();
    int idx;

    public CSVIterator(String file, boolean skip_first, List<Integer> col_idx) throws IOException {
        this.file = file;
        this.skip_first = skip_first;
        this.col_idx = col_idx;
        this.in = new BufferedReader(new FileReader(this.file));
        this.init();
    }

    public CSVIterator(BufferedReader in, boolean skip_first, List<Integer> col_idx) throws IOException {
        this.in = in;
        this.file = this.file;
        this.skip_first = skip_first;
        this.col_idx = col_idx;
        this.init();
    }

    private void init() throws IOException {
        this.last_line = this.skip_first ? this.in.readLine() : "";
        this.next_line_fetched = false;
    }

    @Override
    public boolean hasNext() {
        if (!this.next_line_fetched) {
            this.fetchNextLine();
        }
        return this.last_line != null;
    }

    private boolean fetchNextLine() {
        try {
            this.last_line = this.in.readLine();
            if (this.last_line == null) {
                return false;
            }
            String[] splits = this.last_line.split(",");
            this.last_extracted = new ArrayList<String>();
            for (int zi = 0; zi < this.col_idx.size(); ++zi) {
                this.last_extracted.add(splits[this.col_idx.get(zi)]);
            }
        }
        catch (IOException e) {
            System.out.println("[WARN] IOException in CSVIterator..");
            this.last_line = null;
            return false;
        }
        return true;
    }

    @Override
    public List<String> next() {
        if (!this.next_line_fetched) {
            this.fetchNextLine();
        }
        this.next_line_fetched = false;
        return this.last_extracted;
    }
}

