/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table;

import java.awt.Color;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.table.AbstractTableModel;

public interface NClassification {
    public List<NClass> getClasses();

    public void addClass(NClass var1);

    public void removeClass(NClass var1);

    public void addClassificationListener(ClassificationListener var1);

    public void removeClassificationListener(ClassificationListener var1);

    public List<NClass> getClassesForRow(String var1);

    public static class ClassificationTableModel
    extends AbstractTableModel {
        private NClassification nc;

        public ClassificationTableModel(NClassification nc) {
            this.nc = nc;
            nc.addClassificationListener(new ClassificationListener(){

                @Override
                public void classificationChanged() {
                    this.fireClustersChanged();
                }

                @Override
                public void classChanged(NClass ci) {
                    this.fireClustersChanged();
                }
            });
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Size";
                }
                case 2: {
                    return "Color";
                }
            }
            return "<ERROR>";
        }

        @Override
        public int getRowCount() {
            return this.nc.getClasses().size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= this.nc.getClasses().size()) {
                return null;
            }
            NClass ci = this.nc.getClasses().get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return ci.getName();
                }
                case 1: {
                    return ci.getMembers().size();
                }
                case 2: {
                    return ci.getColor();
                }
            }
            return null;
        }

        public void fireClustersChanged() {
            this.fireTableDataChanged();
        }
    }

    public static interface ClassificationListener {
        public void classificationChanged();

        public void classChanged(NClass var1);
    }

    public static interface NClassWithTimestamp {
        public Date getTimestamp(String var1);
    }

    public static interface NClass {
        public String getName();

        public String getDescription();

        public Color getColor();

        public void setColor(Color var1);

        public boolean isMember(String var1);

        public Set<String> getMembers();
    }
}

