/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table;

import java.io.Serializable;
import java.util.List;
import tech.molecules.leet.table.NClassification;
import tech.molecules.leet.table.NColumn;
import tech.molecules.leet.table.NStructureDataProvider;

public interface NDataProvider {

    public static interface NMultiNumericDataProvider
    extends NDataProvider,
    MultiNumericDataProvider {
    }

    public static interface MultiNumericDataProvider {
        public double[] getMultiNumericData(String var1);
    }

    public static interface NStringDataProvider
    extends NDataProvider,
    StringDataProvider {
    }

    public static interface ClassificationProvider<C extends NClassification> {
        public C getClassification();
    }

    public static interface StringDataProvider {
        public String getStringData(String var1);
    }

    public static interface NClassificationProvider<C extends NClassification>
    extends NDataProvider,
    ClassificationProvider<C> {
    }

    public static interface ClassificationDataProvider
    extends NDataProvider {
        public List<NClassification.NClass> getClassificationData(String var1);
    }

    public static class StructureDataProviderFromColumn<U>
    implements NStructureDataProvider {
        private U dataProvider;
        private NColumn<U, StructureWithID> col;

        public StructureDataProviderFromColumn(U dataprovider, NColumn<U, StructureWithID> col) {
            this.dataProvider = dataprovider;
            this.col = col;
        }

        @Override
        public StructureWithID getStructureData(String rowid) {
            return this.col.getData(rowid);
        }
    }

    public static interface StructureDataProvider {
        public StructureWithID getStructureData(String var1);
    }

    public static class StructureWithID
    implements Serializable {
        public final String[] structure;
        public final String molid;
        public final String batchid;

        public StructureWithID(String molid, String batchid, String[] struc) {
            this.structure = struc;
            this.molid = molid;
            this.batchid = batchid;
        }
    }
}

