/*
 * Decompiled with CFR 0.152.
 */
package tech.msop.mybatis.config;

import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import tech.msop.core.launch.properties.MsPropertySource;
import tech.msop.core.tool.utils.ObjectUtil;
import tech.msop.mybatis.injector.MsSqlInjector;
import tech.msop.mybatis.intercept.QueryInterceptor;
import tech.msop.mybatis.plugins.MsPaginationInterceptor;
import tech.msop.mybatis.plugins.SqlLogInterceptor;
import tech.msop.mybatis.properties.MybatisPlusProperties;
import tech.msop.mybatis.resolver.PageArgumentResolver;

@AutoConfiguration
@MapperScan(value={"tech.msop.**.mapper.**"})
@EnableConfigurationProperties(value={MybatisPlusProperties.class})
@MsPropertySource(value="classpath:/ms-mybatis.yml")
public class MybatisPlusConfiguration
implements WebMvcConfigurer {
    @Bean
    @ConditionalOnMissingBean(value={TenantLineInnerInterceptor.class})
    public TenantLineInnerInterceptor tenantLineInnerInterceptor() {
        return new TenantLineInnerInterceptor(new TenantLineHandler(){

            public Expression getTenantId() {
                return null;
            }

            public boolean ignoreTable(String tableName) {
                return true;
            }
        });
    }

    @Bean
    @ConditionalOnMissingBean(value={MybatisPlusInterceptor.class})
    public MybatisPlusInterceptor mybatisPlusInterceptor(ObjectProvider<QueryInterceptor[]> queryInterceptors, TenantLineInnerInterceptor tenantLineInnerInterceptor, MybatisPlusProperties mybatisPlusProperties) {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        if (mybatisPlusProperties.getTenantMode().booleanValue()) {
            interceptor.addInnerInterceptor((InnerInterceptor)tenantLineInnerInterceptor);
        }
        MsPaginationInterceptor paginationInterceptor = new MsPaginationInterceptor();
        Object[] queryInterceptorArray = (QueryInterceptor[])queryInterceptors.getIfAvailable();
        if (ObjectUtil.isNotEmpty((Object)queryInterceptorArray)) {
            AnnotationAwareOrderComparator.sort((Object[])queryInterceptorArray);
            paginationInterceptor.setQueryInterceptors((QueryInterceptor[])queryInterceptorArray);
        }
        paginationInterceptor.setMaxLimit(mybatisPlusProperties.getPageLimit());
        paginationInterceptor.setOverflow(mybatisPlusProperties.getOverflow());
        paginationInterceptor.setOptimizeJoin(mybatisPlusProperties.getOptimizeJoin());
        interceptor.addInnerInterceptor((InnerInterceptor)paginationInterceptor);
        return interceptor;
    }

    @Bean
    public SqlLogInterceptor sqlLogInterceptor(MybatisPlusProperties mybatisPlusProperties) {
        return new SqlLogInterceptor(mybatisPlusProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={ISqlInjector.class})
    public ISqlInjector sqlInjector() {
        return new MsSqlInjector();
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(new PageArgumentResolver());
    }
}

