/*
 * Decompiled with CFR 0.152.
 */
package tech.msop.mybatis.resolver;

import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.core.MethodParameter;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import tech.msop.core.tool.utils.ObjectUtil;
import tech.msop.core.tool.utils.StringUtil;

public class PageArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final String ORDER_ASC = "asc";

    public boolean supportsParameter(MethodParameter methodParameter) {
        return Page.class.equals((Object)methodParameter.getParameterType());
    }

    public Object resolveArgument(@NonNull MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest, WebDataBinderFactory webDataBinderFactory) throws Exception {
        String pageParam = nativeWebRequest.getParameter("page");
        String sizeParam = nativeWebRequest.getParameter("size");
        Object[] sortParam = nativeWebRequest.getParameterValues("sort");
        Page page = new Page();
        if (StringUtil.isNotBlank((CharSequence)pageParam)) {
            page.setCurrent(Long.parseLong(pageParam));
        }
        if (StringUtil.isNotBlank((CharSequence)sizeParam)) {
            page.setSize(Long.parseLong(sizeParam));
        }
        if (ObjectUtil.isEmpty((Object[])sortParam)) {
            return page;
        }
        for (Object param : sortParam) {
            if (StringUtil.isBlank((CharSequence)param)) continue;
            String[] split = ((String)param).split(",");
            OrderItem orderItem = new OrderItem();
            orderItem.setColumn(split[0]);
            orderItem.setAsc(split[1].equals(ORDER_ASC));
            page.addOrder(new OrderItem[]{orderItem});
        }
        return page;
    }

    private static boolean isOrderASC(String[] split) {
        if (split.length < 2) {
            return false;
        }
        return ORDER_ASC.equalsIgnoreCase(split[1]);
    }
}

