/*
 * Decompiled with CFR 0.152.
 */
package tech.msop.mybatis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotEmpty;
import org.springframework.transaction.annotation.Transactional;
import tech.msop.core.tool.constant.MsConstant;
import tech.msop.core.tool.exception.IdempotencyException;
import tech.msop.core.tool.exception.LockException;
import tech.msop.core.tool.lock.DistributedLock;
import tech.msop.core.tool.lock.LockType;
import tech.msop.core.tool.lock.MLock;
import tech.msop.core.tool.utils.BeanUtil;
import tech.msop.core.tool.utils.ClassUtil;
import tech.msop.core.tool.utils.DateUtil;
import tech.msop.core.tool.utils.ObjectUtil;
import tech.msop.core.tool.utils.ReflectUtil;
import tech.msop.core.tool.utils.StringUtil;
import tech.msop.mybatis.injector.MsSqlMethod;
import tech.msop.mybatis.mapper.SuperMapper;
import tech.msop.mybatis.model.BaseEntity;
import tech.msop.mybatis.service.ISuperService;

public class SuperServiceImpl<M extends SuperMapper<T>, T extends BaseEntity>
extends ServiceImpl<M, T>
implements ISuperService<T> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean saveIdempotency(T entity, DistributedLock locker, String lockKey, Wrapper<T> countWrapper, String msg) throws Exception {
        if (locker == null) {
            throw new LockException("DistributedLock is null", "\u5206\u5e03\u5f0f\u9501\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isBlank((CharSequence)lockKey)) {
            throw new LockException("lockKey is null", "\u9501\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Throwable throwable = null;
        try (MLock lock = locker.tryLock(lockKey, 10L, 60L, TimeUnit.SECONDS, LockType.FAIR);){
            if (ObjectUtil.isEmpty((Object)lock)) throw new LockException("\u9501\u7b49\u5f85\u8d85\u65f6");
            long count = super.count(countWrapper);
            if (count == 0L) {
                boolean bl = super.save(entity);
                return bl;
            }
            try {
                if (!StringUtil.isBlank((CharSequence)msg)) throw new IdempotencyException(msg);
                msg = "\u5df2\u5b58\u5728";
                throw new IdempotencyException(msg);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public boolean saveIdempotency(T entity, DistributedLock lock, String lockKey, Wrapper<T> countWrapper) throws Exception {
        return this.saveIdempotency(entity, lock, lockKey, countWrapper, (String)null);
    }

    @Override
    public boolean saveOrUpdateIdempotency(T entity, DistributedLock lock, String lockKey, Wrapper<T> countWrapper, String msg) throws Exception {
        if (null != entity) {
            Class<?> cls = entity.getClass();
            TableInfo tableInfo = TableInfoHelper.getTableInfo(cls);
            if (null != tableInfo && StringUtil.isBlank((CharSequence)tableInfo.getKeyProperty())) {
                Object idVal = ReflectionKit.getFieldValue(entity, (String)tableInfo.getKeyProperty());
                if (StringUtils.checkValNull((Object)idVal) || Objects.isNull(this.getById((Serializable)idVal))) {
                    if (StringUtil.isBlank((CharSequence)msg)) {
                        msg = "\u5df2\u5b58\u5728";
                    }
                    return this.saveIdempotency(entity, lock, lockKey, countWrapper, msg);
                }
                return this.updateById(entity);
            }
            throw ExceptionUtils.mpe((String)"Error:  Can not execute. Could not find @TableId.", (Object[])new Object[0]);
        }
        return false;
    }

    @Override
    public boolean saveOrUpdateIdempotency(T entity, DistributedLock lock, String lockKey, Wrapper<T> countWrapper) throws Exception {
        return this.saveOrUpdateIdempotency(entity, lock, lockKey, countWrapper, (String)null);
    }

    public boolean save(T entity) {
        this.resolveEntity(entity);
        return super.save(entity);
    }

    public boolean saveBatch(Collection<T> entityList, int batchSize) {
        entityList.forEach(this::resolveEntity);
        return super.saveBatch(entityList, batchSize);
    }

    public boolean updateById(T entity) {
        this.resolveEntity(entity);
        return super.updateById(entity);
    }

    public boolean updateBatchById(Collection<T> entityList, int batchSize) {
        entityList.forEach(this::resolveEntity);
        return super.updateBatchById(entityList, batchSize);
    }

    public boolean saveOrUpdate(T entity) {
        if (((BaseEntity)entity).getId() == null) {
            return this.save(entity);
        }
        return this.updateById(entity);
    }

    public boolean saveOrUpdateBatch(Collection<T> entityList, int batchSize) {
        entityList.forEach(this::resolveEntity);
        return super.saveOrUpdateBatch(entityList, batchSize);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteLogic(@NotEmpty List<Long> ids) {
        ArrayList list = new ArrayList();
        ids.forEach(id -> {
            BaseEntity entity = (BaseEntity)BeanUtil.newInstance((Class)this.currentModelClass());
            entity.setUpdateTime(DateUtil.now());
            entity.setId((Long)id);
            list.add(entity);
        });
        return super.updateBatchById(list) && super.removeByIds(ids);
    }

    @Override
    public boolean changeStatus(@NotEmpty List<Long> ids, Integer status) {
        ArrayList list = new ArrayList();
        ids.forEach(id -> {
            BaseEntity entity = (BaseEntity)BeanUtil.newInstance((Class)this.currentModelClass());
            entity.setUpdateTime(DateUtil.now());
            entity.setId((Long)id);
            entity.setStatus(status);
            list.add(entity);
        });
        return super.updateBatchById(list);
    }

    private void resolveEntity(T entity) {
        Method getTenantId;
        String tenantId;
        Date now = DateUtil.now();
        if (((BaseEntity)entity).getId() == null) {
            if (((BaseEntity)entity).getStatus() == null) {
                ((BaseEntity)entity).setStatus(MsConstant.STATUS_NORMAL);
            }
            ((BaseEntity)entity).setCreateTime(now);
        }
        ((BaseEntity)entity).setUpdateTime(now);
        ((BaseEntity)entity).setIsDeleted(MsConstant.DB_NOT_DELETED);
        Field field = ReflectUtil.getField(entity.getClass(), (String)"tenantId");
        if (ObjectUtil.isNotEmpty((Object)field) && ObjectUtil.isEmpty((Object)(tenantId = String.valueOf((getTenantId = ClassUtil.getMethod(entity.getClass(), (String)"getTenantId", (Class[])new Class[0])).invoke(entity, new Object[0]))))) {
            Method setTenantId = ClassUtil.getMethod(entity.getClass(), (String)"setTenantId", (Class[])new Class[]{String.class});
            setTenantId.invoke(entity, new Object[]{null});
        }
    }

    @Override
    public boolean saveIgnore(T entity) {
        return SqlHelper.retBool((Integer)((SuperMapper)this.baseMapper).insertIgnore(entity));
    }

    @Override
    public boolean saveReplace(T entity) {
        return SqlHelper.retBool((Integer)((SuperMapper)this.baseMapper).replace(entity));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveIgnoreBatch(Collection<T> entityList, int batchSize) {
        return this.saveBatch(entityList, batchSize, MsSqlMethod.INSERT_IGNORE_ONE);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveReplaceBatch(Collection<T> entityList, int batchSize) {
        return this.saveBatch(entityList, batchSize, MsSqlMethod.REPLACE_ONE);
    }

    private boolean saveBatch(Collection<T> entityList, int batchSize, MsSqlMethod sqlMethod) {
        String sqlStatement = this.msSqlStatement(sqlMethod);
        this.executeBatch(entityList, batchSize, (sqlSession, entity) -> sqlSession.insert(sqlStatement, entity));
        return true;
    }

    protected String msSqlStatement(MsSqlMethod sqlMethod) {
        return SqlHelper.table((Class)this.currentModelClass()).getSqlStatement(sqlMethod.getMethod());
    }
}

