/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.bilibili.client;

import cn.hutool.core.util.StrUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.bilibili.config.BilibiliLiveChatClientConfig;
import tech.ordinaryroad.live.chat.client.bilibili.listener.IBilibiliConnectionListener;
import tech.ordinaryroad.live.chat.client.bilibili.listener.IBilibiliMsgListener;
import tech.ordinaryroad.live.chat.client.bilibili.listener.impl.BilibiliForwardMsgListener;
import tech.ordinaryroad.live.chat.client.bilibili.netty.handler.BilibiliBinaryFrameHandler;
import tech.ordinaryroad.live.chat.client.bilibili.netty.handler.BilibiliConnectionHandler;
import tech.ordinaryroad.live.chat.client.bilibili.netty.handler.BilibiliLiveChatClientChannelInitializer;
import tech.ordinaryroad.live.chat.client.codec.bilibili.api.BilibiliApis;
import tech.ordinaryroad.live.chat.client.codec.bilibili.constant.BilibiliCmdEnum;
import tech.ordinaryroad.live.chat.client.codec.bilibili.msg.base.IBilibiliMsg;
import tech.ordinaryroad.live.chat.client.commons.base.exception.BaseException;
import tech.ordinaryroad.live.chat.client.commons.base.listener.IBaseConnectionListener;
import tech.ordinaryroad.live.chat.client.commons.client.enums.ClientStatusEnums;
import tech.ordinaryroad.live.chat.client.commons.util.OrLiveChatCollUtil;
import tech.ordinaryroad.live.chat.client.servers.netty.client.base.BaseNettyClient;
import tech.ordinaryroad.live.chat.client.servers.netty.client.config.BaseNettyClientConfig;

public class BilibiliLiveChatClient
extends BaseNettyClient<BilibiliLiveChatClientConfig, BilibiliCmdEnum, IBilibiliMsg, IBilibiliMsgListener, BilibiliConnectionHandler, BilibiliBinaryFrameHandler> {
    private static final Logger log = LoggerFactory.getLogger(BilibiliLiveChatClient.class);
    private BilibiliApis.RoomInitResult roomInitResult = new BilibiliApis.RoomInitResult();

    public BilibiliLiveChatClient(BilibiliLiveChatClientConfig config, List<IBilibiliMsgListener> msgListeners, IBilibiliConnectionListener connectionListener, EventLoopGroup workerGroup) {
        super((BaseNettyClientConfig)config, workerGroup, (IBaseConnectionListener)connectionListener);
        this.addMsgListeners(msgListeners);
        this.init();
    }

    public BilibiliLiveChatClient(BilibiliLiveChatClientConfig config, IBilibiliMsgListener msgListener, IBilibiliConnectionListener connectionListener, EventLoopGroup workerGroup) {
        super((BaseNettyClientConfig)config, workerGroup, (IBaseConnectionListener)connectionListener);
        this.addMsgListener(msgListener);
        this.init();
    }

    public BilibiliLiveChatClient(BilibiliLiveChatClientConfig config, IBilibiliMsgListener msgListener, IBilibiliConnectionListener connectionListener) {
        this(config, msgListener, connectionListener, (EventLoopGroup)new NioEventLoopGroup());
    }

    public BilibiliLiveChatClient(BilibiliLiveChatClientConfig config, IBilibiliMsgListener msgListener) {
        this(config, msgListener, null, (EventLoopGroup)new NioEventLoopGroup());
    }

    public BilibiliLiveChatClient(BilibiliLiveChatClientConfig config) {
        this(config, null);
    }

    public void init() {
        this.roomInitResult = BilibiliApis.roomInit((long)((BilibiliLiveChatClientConfig)this.getConfig()).getRoomId(), (String)((BilibiliLiveChatClientConfig)this.getConfig()).getCookie());
        if (StrUtil.isNotBlank((CharSequence)((BilibiliLiveChatClientConfig)this.getConfig()).getForwardWebsocketUri())) {
            BilibiliForwardMsgListener forwardMsgListener = new BilibiliForwardMsgListener(((BilibiliLiveChatClientConfig)this.getConfig()).getForwardWebsocketUri());
            this.addMsgListener(forwardMsgListener);
            this.addStatusChangeListener((evt, oldStatus, newStatus) -> {
                if (newStatus == ClientStatusEnums.DESTROYED) {
                    forwardMsgListener.destroyForwardClient();
                }
            });
        }
        super.init();
    }

    protected void initChannel(SocketChannel channel) {
        channel.pipeline().addLast(new ChannelHandler[]{new BilibiliLiveChatClientChannelInitializer(this)});
    }

    public BilibiliConnectionHandler initConnectionHandler(IBaseConnectionListener<BilibiliConnectionHandler> clientConnectionListener) {
        return new BilibiliConnectionHandler(() -> new WebSocketClientProtocolHandler(WebSocketClientProtocolConfig.newBuilder().webSocketUri(this.getWebsocketUri()).version(WebSocketVersion.V13).subprotocol(null).allowExtensions(true).customHeaders((HttpHeaders)new DefaultHttpHeaders()).maxFramePayloadLength(((BilibiliLiveChatClientConfig)this.getConfig()).getMaxFramePayloadLength()).handshakeTimeoutMillis(((BilibiliLiveChatClientConfig)this.getConfig()).getHandshakeTimeoutMillis()).build()), this, clientConnectionListener);
    }

    protected String getWebSocketUriString() {
        String webSocketUriString = super.getWebSocketUriString();
        if (StrUtil.isNotBlank((CharSequence)webSocketUriString)) {
            return webSocketUriString;
        }
        BilibiliApis.Host_list hostList = (BilibiliApis.Host_list)OrLiveChatCollUtil.getRandom((List)this.roomInitResult.getDanmuinfoResult().getHost_list());
        return StrUtil.format((CharSequence)"wss://{}:{}/sub", (Object[])new Object[]{hostList.getHost(), hostList.getWss_port()});
    }

    public void sendDanmu(Object danmu, Runnable success, Consumer<Throwable> failed) {
        block12: {
            if (!this.checkCanSendDanmu(false)) {
                return;
            }
            if (danmu instanceof String) {
                String msg = (String)danmu;
                try {
                    boolean sendSuccess;
                    block11: {
                        if (log.isDebugEnabled()) {
                            log.debug("{} bilibili\u53d1\u9001\u5f39\u5e55 {}", (Object)((BilibiliLiveChatClientConfig)this.getConfig()).getRoomId(), danmu);
                        }
                        sendSuccess = false;
                        try {
                            BilibiliApis.sendMsg((String)msg, (long)this.roomInitResult.getRoomPlayInfoResult().getRoom_id(), (String)((BilibiliLiveChatClientConfig)this.getConfig()).getCookie());
                            sendSuccess = true;
                        }
                        catch (Exception e) {
                            log.error("bilibili\u5f39\u5e55\u53d1\u9001\u5931\u8d25", (Throwable)e);
                            if (failed == null) break block11;
                            failed.accept(e);
                        }
                    }
                    if (!sendSuccess) {
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("bilibili\u5f39\u5e55\u53d1\u9001\u6210\u529f {}", danmu);
                    }
                    if (success != null) {
                        success.run();
                    }
                    this.finishSendDanmu();
                }
                catch (Exception e) {
                    log.error("bilibili\u5f39\u5e55\u53d1\u9001\u5931\u8d25", (Throwable)e);
                    if (failed != null) {
                        failed.accept(e);
                    }
                    break block12;
                }
            }
            super.sendDanmu(danmu, success, failed);
        }
    }

    public void clickLike(int count, Runnable success, Consumer<Throwable> failed) {
        boolean successfullyClicked;
        block6: {
            if (count <= 0) {
                throw new BaseException("\u70b9\u8d5e\u6b21\u6570\u5fc5\u987b\u5927\u4e8e0");
            }
            successfullyClicked = false;
            try {
                BilibiliApis.likeReportV3((long)this.roomInitResult.getRoomPlayInfoResult().getUid(), (long)this.roomInitResult.getRoomPlayInfoResult().getRoom_id(), (String)((BilibiliLiveChatClientConfig)this.getConfig()).getCookie());
                successfullyClicked = true;
            }
            catch (Exception e) {
                log.error("Bilibili\u4e3a\u76f4\u64ad\u95f4\u70b9\u8d5e\u5931\u8d25", (Throwable)e);
                if (failed == null) break block6;
                failed.accept(e);
            }
        }
        if (!successfullyClicked) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Bilibili\u4e3a\u76f4\u64ad\u95f4\u70b9\u8d5e\u6210\u529f");
        }
        if (success != null) {
            success.run();
        }
    }

    public BilibiliApis.RoomInitResult getRoomInitResult() {
        return this.roomInitResult;
    }
}

