/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.bilibili.netty.handler;

import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.core.TreeNode;
import io.netty.channel.ChannelHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.bilibili.client.BilibiliLiveChatClient;
import tech.ordinaryroad.live.chat.client.bilibili.listener.IBilibiliMsgListener;
import tech.ordinaryroad.live.chat.client.codec.bilibili.constant.BilibiliCmdEnum;
import tech.ordinaryroad.live.chat.client.codec.bilibili.msg.BilibiliLiveStatusChangeMsg;
import tech.ordinaryroad.live.chat.client.codec.bilibili.msg.BilibiliRoomStatsMsg;
import tech.ordinaryroad.live.chat.client.codec.bilibili.msg.DanmuMsgMsg;
import tech.ordinaryroad.live.chat.client.codec.bilibili.msg.InteractWordMsg;
import tech.ordinaryroad.live.chat.client.codec.bilibili.msg.LikeInfoV3ClickMsg;
import tech.ordinaryroad.live.chat.client.codec.bilibili.msg.MessageMsg;
import tech.ordinaryroad.live.chat.client.codec.bilibili.msg.SendGiftMsg;
import tech.ordinaryroad.live.chat.client.codec.bilibili.msg.SuperChatMessageMsg;
import tech.ordinaryroad.live.chat.client.codec.bilibili.msg.base.BaseBilibiliMsg;
import tech.ordinaryroad.live.chat.client.codec.bilibili.msg.base.IBilibiliMsg;
import tech.ordinaryroad.live.chat.client.commons.base.msg.ICmdMsg;
import tech.ordinaryroad.live.chat.client.servers.netty.client.base.BaseNettyClient;
import tech.ordinaryroad.live.chat.client.servers.netty.client.handler.BaseNettyClientBinaryFrameHandler;

@ChannelHandler.Sharable
public class BilibiliBinaryFrameHandler
extends BaseNettyClientBinaryFrameHandler<BilibiliLiveChatClient, BilibiliBinaryFrameHandler, BilibiliCmdEnum, IBilibiliMsg, IBilibiliMsgListener> {
    private static final Logger log = LoggerFactory.getLogger(BilibiliBinaryFrameHandler.class);
    private final Pair<Object, Object> roomIdPair;

    public BilibiliBinaryFrameHandler(List<IBilibiliMsgListener> msgListeners, BilibiliLiveChatClient client) {
        super(msgListeners, (BaseNettyClient)client);
        this.roomIdPair = Pair.of((Object)client.getRoomInitResult().getRoomPlayInfoResult().getRoom_id(), (Object)client.getRoomInitResult().getRoomPlayInfoResult().getShort_id());
    }

    public BilibiliBinaryFrameHandler(List<IBilibiliMsgListener> msgListeners, long roomId, Pair<Object, Object> roomIdPair) {
        super(msgListeners, roomId);
        this.roomIdPair = roomIdPair;
    }

    public void onCmdMsg(BilibiliCmdEnum cmd, ICmdMsg<BilibiliCmdEnum> cmdMsg) {
        if (this.msgListeners.isEmpty()) {
            return;
        }
        MessageMsg messageMsg = (MessageMsg)cmdMsg;
        switch (cmd) {
            case DANMU_MSG: {
                DanmuMsgMsg danmuMsgMsg = new DanmuMsgMsg();
                danmuMsgMsg.setProtover(messageMsg.getProtover());
                danmuMsgMsg.setInfo(messageMsg.getInfo());
                danmuMsgMsg.setDm_v2(StrUtil.toStringOrNull(messageMsg.getUnknownProperties().get("dm_v2")));
                this.iteratorMsgListeners(msgListener -> msgListener.onDanmuMsg((Object)this, danmuMsgMsg));
                break;
            }
            case SEND_GIFT: {
                SendGiftMsg sendGiftMsg = new SendGiftMsg();
                sendGiftMsg.setRoomId(this.getRoomIdAsLong());
                sendGiftMsg.setProtover(messageMsg.getProtover());
                SendGiftMsg.Data data = (SendGiftMsg.Data)BaseBilibiliMsg.OBJECT_MAPPER.treeToValue((TreeNode)messageMsg.getData(), SendGiftMsg.Data.class);
                sendGiftMsg.setData(data);
                this.iteratorMsgListeners(msgListener -> msgListener.onGiftMsg((Object)this, sendGiftMsg));
                break;
            }
            case SUPER_CHAT_MESSAGE: {
                SuperChatMessageMsg superChatMessageMsg = new SuperChatMessageMsg();
                superChatMessageMsg.setProtover(messageMsg.getProtover());
                superChatMessageMsg.setRoomid(messageMsg.getRoomid());
                SuperChatMessageMsg.Data data = (SuperChatMessageMsg.Data)BaseBilibiliMsg.OBJECT_MAPPER.treeToValue((TreeNode)messageMsg.getData(), SuperChatMessageMsg.Data.class);
                superChatMessageMsg.setData(data);
                this.iteratorMsgListeners(msgListener -> msgListener.onSuperChatMsg((Object)this, superChatMessageMsg));
                break;
            }
            case INTERACT_WORD: {
                InteractWordMsg interactWordMsg = new InteractWordMsg();
                interactWordMsg.setProtover(messageMsg.getProtover());
                InteractWordMsg.Data data = (InteractWordMsg.Data)BaseBilibiliMsg.OBJECT_MAPPER.treeToValue((TreeNode)messageMsg.getData(), InteractWordMsg.Data.class);
                interactWordMsg.setData(data);
                this.iteratorMsgListeners(msgListener -> msgListener.onEnterRoomMsg((Object)this, interactWordMsg));
                break;
            }
            case ENTRY_EFFECT: {
                this.iteratorMsgListeners(msgListener -> msgListener.onEntryEffect(this, messageMsg));
                break;
            }
            case ONLINE_RANK_COUNT: 
            case WATCHED_CHANGE: 
            case LIKE_INFO_V3_UPDATE: {
                BilibiliRoomStatsMsg bilibiliRoomStatsMsg = (BilibiliRoomStatsMsg)BaseBilibiliMsg.OBJECT_MAPPER.convertValue((Object)messageMsg, BilibiliRoomStatsMsg.class);
                this.iteratorMsgListeners(msgListener -> msgListener.onRoomStatsMsg((Object)this, bilibiliRoomStatsMsg));
                break;
            }
            case LIKE_INFO_V3_CLICK: {
                LikeInfoV3ClickMsg likeInfoV3ClickMsg = new LikeInfoV3ClickMsg();
                likeInfoV3ClickMsg.setProtover(messageMsg.getProtover());
                LikeInfoV3ClickMsg.Data data = (LikeInfoV3ClickMsg.Data)BaseBilibiliMsg.OBJECT_MAPPER.treeToValue((TreeNode)messageMsg.getData(), LikeInfoV3ClickMsg.Data.class);
                likeInfoV3ClickMsg.setData(data);
                this.iteratorMsgListeners(msgListener -> msgListener.onLikeMsg((Object)this, likeInfoV3ClickMsg));
                break;
            }
            case LIVE: 
            case STOP_LIVE_ROOM_LIST: {
                BilibiliLiveStatusChangeMsg bilibiliLiveStatusChangeMsg = (BilibiliLiveStatusChangeMsg)BaseBilibiliMsg.OBJECT_MAPPER.convertValue((Object)messageMsg, BilibiliLiveStatusChangeMsg.class);
                bilibiliLiveStatusChangeMsg.setRoomIdPair(this.getRoomIdPair());
                this.iteratorMsgListeners(msgListener -> msgListener.onLiveStatusMsg((Object)this, bilibiliLiveStatusChangeMsg));
                break;
            }
            default: {
                this.iteratorMsgListeners(msgListener -> msgListener.onOtherCmdMsg((Object)this, (Enum)cmd, cmdMsg));
                break;
            }
        }
    }

    public Pair<Object, Object> getRoomIdPair() {
        return this.roomIdPair;
    }
}

