/*
 * Decompiled with CFR 0.152.
 */
package tech.petrepopescu.logging.masker;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import tech.petrepopescu.logging.masker.LogMasker;

public class IbanMasker
implements LogMasker {
    protected char maskChar = (char)42;
    private Map<Character, Map<Character, Integer>> countriesToCheck = new HashMap<Character, Map<Character, Integer>>(COUNTRIES_DICTIONARY);
    private static final Map<Character, Map<Character, Integer>> COUNTRIES_DICTIONARY = IbanMasker.buildCountriesDictionary("AL", 28, "AD", 24, "AT", 20, "AZ", 28, "BH", 22, "BY", 28, "BE", 16, "BA", 20, "BR", 29, "BG", 22, "CR", 22, "HR", 21, "CY", 28, "CZ", 24, "DK", 18, "DO", 28, "EG", 29, "SV", 28, "EE", 20, "FO", 18, "FI", 18, "FR", 27, "GE", 22, "DE", 22, "GI", 23, "GR", 27, "GL", 18, "GT", 28, "VA", 22, "HU", 28, "IS", 28, "IQ", 23, "IE", 22, "IL", 23, "IT", 27, "JO", 30, "KZ", 20, "XK", 20, "KW", 30, "LV", 21, "LB", 28, "LY", 25, "LI", 21, "LT", 20, "LU", 20, "MT", 31, "MR", 27, "MU", 30, "MD", 24, "MC", 27, "ME", 22, "NL", 18, "MK", 19, "NO", 15, "PK", 24, "PS", 29, "PL", 28, "PT", 25, "QA", 29, "RO", 24, "LC", 32, "SM", 27, "ST", 25, "SA", 24, "RS", 22, "SC", 31, "SK", 24, "SI", 19, "ES", 24, "SD", 18, "SE", 24, "CH", 21, "TL", 23, "TN", 24, "TR", 26, "UA", 29, "AE", 23, "GB", 22, "VG", 24);

    @Override
    public void initialize(String params) {
        if (StringUtils.isBlank((CharSequence)params)) {
            this.countriesToCheck = new HashMap<Character, Map<Character, Integer>>(COUNTRIES_DICTIONARY);
            return;
        }
        String[] countryCodes = StringUtils.split((String)params.toUpperCase(Locale.ROOT), (char)'|');
        this.populateCountriesToCheck(countryCodes);
    }

    protected void populateCountriesToCheck(String[] countryCodes) {
        this.countriesToCheck = new HashMap<Character, Map<Character, Integer>>();
        for (String cc : countryCodes) {
            Integer ibanLength;
            Map<Character, Integer> alreadyInDictionary;
            Map<Character, Integer> countries = COUNTRIES_DICTIONARY.get(Character.valueOf(cc.charAt(0)));
            if (countries != null) {
                alreadyInDictionary = this.countriesToCheck.get(Character.valueOf(cc.charAt(0)));
                ibanLength = countries.get(Character.valueOf(cc.charAt(1)));
                if (alreadyInDictionary == null && ibanLength != null) {
                    alreadyInDictionary = new HashMap<Character, Integer>();
                    this.countriesToCheck.put(Character.valueOf(cc.charAt(0)), alreadyInDictionary);
                }
                if (ibanLength == null) {
                    throw new ExceptionInInitializerError("Invalid country provided: " + cc);
                }
            } else {
                throw new ExceptionInInitializerError("Invalid country provided: " + cc);
            }
            alreadyInDictionary.put(Character.valueOf(cc.charAt(1)), ibanLength);
        }
    }

    @Override
    public int maskData(StringBuilder builder, int startPos, int buffLength) {
        Integer ibanLength;
        Map<Character, Integer> potential = this.countriesToCheck.get(Character.valueOf(builder.charAt(startPos)));
        if (potential != null && this.shouldMask(builder, buffLength, startPos, ibanLength = potential.get(Character.valueOf(builder.charAt(startPos + 1))))) {
            builder.replace(startPos + 3, startPos + ibanLength - 4, StringUtils.repeat((char)this.maskChar, (int)(ibanLength - 7)));
            return startPos + ibanLength;
        }
        return startPos;
    }

    @Override
    public void setMaskChar(char maskChar) {
        this.maskChar = maskChar;
    }

    private boolean shouldMask(StringBuilder builder, int buffLength, int start, Integer ibanLength) {
        if (ibanLength == null) {
            return false;
        }
        if (builder.length() < start + ibanLength) {
            return false;
        }
        if (!Character.isDigit(builder.charAt(start + 2))) {
            return false;
        }
        return buffLength == start + ibanLength || LogMasker.indexOfNextDelimiter(builder, start, buffLength) == start + ibanLength;
    }

    private static final Map<Character, Map<Character, Integer>> buildCountriesDictionary(Object ... args) {
        HashMap<Character, Map<Character, Integer>> countries = new HashMap<Character, Map<Character, Integer>>();
        for (int count = 0; count < args.length; count += 2) {
            Character firstChar = Character.valueOf(((String)args[count]).charAt(0));
            HashMap<Character, Integer> lengths = (HashMap<Character, Integer>)countries.get(firstChar);
            if (lengths == null) {
                lengths = new HashMap<Character, Integer>();
                countries.put(firstChar, lengths);
            }
            lengths.put(Character.valueOf(((String)args[count]).charAt(1)), (Integer)args[count + 1]);
        }
        return countries;
    }
}

