package tech.picnic.errorprone.refasterrules;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.AssertJFloatRules}.
 */
@SuppressWarnings("all")
public class AssertJFloatRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public AssertJFloatRulesRecipes() {}

    @Override
    public String getDisplayName() {
        return "`AssertJFloatRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJFloatRules`. [Source](https://error-prone.picnic.tech/refasterrules/AssertJFloatRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new AbstractFloatAssertIsCloseToWithOffsetRecipe(),
                new AbstractFloatAssertIsEqualToRecipe(),
                new AbstractFloatAssertIsNotEqualToRecipe(),
                new AbstractFloatAssertIsZeroRecipe(),
                new AbstractFloatAssertIsNotZeroRecipe(),
                new AbstractFloatAssertIsOneRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJFloatRules.AbstractFloatAssertIsCloseToWithOffset}.
     */
    @SuppressWarnings("all")
    @NonNullApi
    public static class AbstractFloatAssertIsCloseToWithOffsetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractFloatAssertIsCloseToWithOffsetRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJFloatRules.AbstractFloatAssertIsCloseToWithOffset`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractFloatAssertIsCloseToWithOffset {\n    \n    @BeforeTemplate\n    AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert, float n, Offset<Float> offset) {\n        return floatAssert.isEqualTo(n, offset);\n    }\n    \n    @BeforeTemplate\n    AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert, Float n, Offset<Float> offset) {\n        return floatAssert.isEqualTo(n, offset);\n    }\n    \n    @AfterTemplate\n    AbstractFloatAssert<?> after(AbstractFloatAssert<?> floatAssert, float n, Offset<Float> offset) {\n        return floatAssert.isCloseTo(n, offset);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isEqualTo(#{n:any(float)}, #{offset:any(org.assertj.core.data.Offset<java.lang.Float>)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate before0 = JavaTemplate
                        .builder("#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isEqualTo(#{n:any(java.lang.Float)}, #{offset:any(org.assertj.core.data.Offset<java.lang.Float>)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isCloseTo(#{n:any(float)}, #{offset:any(org.assertj.core.data.Offset<java.lang.Float>)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractFloatAssert", true),
                        new UsesType<>("org.assertj.core.data.Offset", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractFloatAssert isEqualTo(..)")
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJFloatRules.AbstractFloatAssertIsEqualTo}.
     */
    @SuppressWarnings("all")
    @NonNullApi
    public static class AbstractFloatAssertIsEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractFloatAssertIsEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJFloatRules.AbstractFloatAssertIsEqualTo`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractFloatAssertIsEqualTo {\n    \n    @BeforeTemplate\n    AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert, float n) {\n        return Refaster.anyOf(floatAssert.isCloseTo(n, offset(0.0F)), floatAssert.isCloseTo(n, withPercentage(0)));\n    }\n    \n    @AfterTemplate\n    AbstractFloatAssert<?> after(AbstractFloatAssert<?> floatAssert, float n) {\n        return floatAssert.isEqualTo(n);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isCloseTo(#{n:any(float)}, org.assertj.core.data.Offset.offset(0.0F))")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isCloseTo(#{n:any(float)}, org.assertj.core.data.Percentage.withPercentage(0))")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isEqualTo(#{n:any(float)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractFloatAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractFloatAssert isCloseTo(..)"),
                        Preconditions.or(
                            new UsesMethod<>("org.assertj.core.data.Offset offset(..)"),
                            new UsesMethod<>("org.assertj.core.data.Percentage withPercentage(..)")
                        )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJFloatRules.AbstractFloatAssertIsNotEqualTo}.
     */
    @SuppressWarnings("all")
    @NonNullApi
    public static class AbstractFloatAssertIsNotEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractFloatAssertIsNotEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJFloatRules.AbstractFloatAssertIsNotEqualTo`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractFloatAssertIsNotEqualTo {\n    \n    @BeforeTemplate\n    AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert, float n) {\n        return Refaster.anyOf(floatAssert.isNotCloseTo(n, offset(0.0F)), floatAssert.isNotCloseTo(n, withPercentage(0)));\n    }\n    \n    @AfterTemplate\n    AbstractFloatAssert<?> after(AbstractFloatAssert<?> floatAssert, float n) {\n        return floatAssert.isNotEqualTo(n);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isNotCloseTo(#{n:any(float)}, org.assertj.core.data.Offset.offset(0.0F))")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isNotCloseTo(#{n:any(float)}, org.assertj.core.data.Percentage.withPercentage(0))")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isNotEqualTo(#{n:any(float)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractFloatAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractFloatAssert isNotCloseTo(..)"),
                        Preconditions.or(
                            new UsesMethod<>("org.assertj.core.data.Offset offset(..)"),
                            new UsesMethod<>("org.assertj.core.data.Percentage withPercentage(..)")
                        )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJFloatRules.AbstractFloatAssertIsZero}.
     */
    @SuppressWarnings("all")
    @NonNullApi
    public static class AbstractFloatAssertIsZeroRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractFloatAssertIsZeroRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJFloatRules.AbstractFloatAssertIsZero`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractFloatAssertIsZero {\n    \n    @BeforeTemplate\n    AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert) {\n        return floatAssert.isZero();\n    }\n    \n    @AfterTemplate\n    AbstractFloatAssert<?> after(AbstractFloatAssert<?> floatAssert) {\n        return floatAssert.isEqualTo(0);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isZero()")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isEqualTo(0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractFloatAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractFloatAssert isZero(..)")
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJFloatRules.AbstractFloatAssertIsNotZero}.
     */
    @SuppressWarnings("all")
    @NonNullApi
    public static class AbstractFloatAssertIsNotZeroRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractFloatAssertIsNotZeroRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJFloatRules.AbstractFloatAssertIsNotZero`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractFloatAssertIsNotZero {\n    \n    @BeforeTemplate\n    AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert) {\n        return floatAssert.isNotZero();\n    }\n    \n    @AfterTemplate\n    AbstractFloatAssert<?> after(AbstractFloatAssert<?> floatAssert) {\n        return floatAssert.isNotEqualTo(0);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isNotZero()")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isNotEqualTo(0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractFloatAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractFloatAssert isNotZero(..)")
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJFloatRules.AbstractFloatAssertIsOne}.
     */
    @SuppressWarnings("all")
    @NonNullApi
    public static class AbstractFloatAssertIsOneRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractFloatAssertIsOneRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJFloatRules.AbstractFloatAssertIsOne`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractFloatAssertIsOne {\n    \n    @BeforeTemplate\n    AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert) {\n        return floatAssert.isOne();\n    }\n    \n    @AfterTemplate\n    AbstractFloatAssert<?> after(AbstractFloatAssert<?> floatAssert) {\n        return floatAssert.isEqualTo(1);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isOne()")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isEqualTo(1)")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractFloatAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractFloatAssert isOne(..)")
                    ),
                    javaVisitor
            );
        }
    }

}
