package tech.picnic.errorprone.refasterrules;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.AssertJIntegerRules}.
 */
@SuppressWarnings("all")
public class AssertJIntegerRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public AssertJIntegerRulesRecipes() {}

    @Override
    public String getDisplayName() {
        return "`AssertJIntegerRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJIntegerRules`. [Source](https://error-prone.picnic.tech/refasterrules/AssertJIntegerRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new AbstractIntegerAssertIsEqualToRecipe(),
                new AbstractIntegerAssertIsNotEqualToRecipe(),
                new AbstractIntegerAssertIsZeroRecipe(),
                new AbstractIntegerAssertIsNotZeroRecipe(),
                new AbstractIntegerAssertIsOneRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJIntegerRules.AbstractIntegerAssertIsEqualTo}.
     */
    @SuppressWarnings("all")
    @NonNullApi
    public static class AbstractIntegerAssertIsEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractIntegerAssertIsEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJIntegerRules.AbstractIntegerAssertIsEqualTo`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractIntegerAssertIsEqualTo {\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(AbstractIntegerAssert<?> intAssert, int n) {\n        return Refaster.anyOf(intAssert.isCloseTo(n, offset(0)), intAssert.isCloseTo(n, withPercentage(0)));\n    }\n    \n    @AfterTemplate\n    AbstractIntegerAssert<?> after(AbstractIntegerAssert<?> intAssert, int n) {\n        return intAssert.isEqualTo(n);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("#{intAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isCloseTo(#{n:any(int)}, org.assertj.core.data.Offset.offset(0))")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("#{intAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isCloseTo(#{n:any(int)}, org.assertj.core.data.Percentage.withPercentage(0))")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{intAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isEqualTo(#{n:any(int)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractIntegerAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isCloseTo(..)"),
                        Preconditions.or(
                            new UsesMethod<>("org.assertj.core.data.Offset offset(..)"),
                            new UsesMethod<>("org.assertj.core.data.Percentage withPercentage(..)")
                        )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJIntegerRules.AbstractIntegerAssertIsNotEqualTo}.
     */
    @SuppressWarnings("all")
    @NonNullApi
    public static class AbstractIntegerAssertIsNotEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractIntegerAssertIsNotEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJIntegerRules.AbstractIntegerAssertIsNotEqualTo`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractIntegerAssertIsNotEqualTo {\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(AbstractIntegerAssert<?> intAssert, int n) {\n        return Refaster.anyOf(intAssert.isNotCloseTo(n, offset(0)), intAssert.isNotCloseTo(n, withPercentage(0)));\n    }\n    \n    @AfterTemplate\n    AbstractIntegerAssert<?> after(AbstractIntegerAssert<?> intAssert, int n) {\n        return intAssert.isNotEqualTo(n);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("#{intAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isNotCloseTo(#{n:any(int)}, org.assertj.core.data.Offset.offset(0))")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("#{intAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isNotCloseTo(#{n:any(int)}, org.assertj.core.data.Percentage.withPercentage(0))")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{intAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isNotEqualTo(#{n:any(int)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractIntegerAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isNotCloseTo(..)"),
                        Preconditions.or(
                            new UsesMethod<>("org.assertj.core.data.Offset offset(..)"),
                            new UsesMethod<>("org.assertj.core.data.Percentage withPercentage(..)")
                        )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJIntegerRules.AbstractIntegerAssertIsZero}.
     */
    @SuppressWarnings("all")
    @NonNullApi
    public static class AbstractIntegerAssertIsZeroRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractIntegerAssertIsZeroRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJIntegerRules.AbstractIntegerAssertIsZero`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractIntegerAssertIsZero {\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(AbstractIntegerAssert<?> intAssert) {\n        return intAssert.isZero();\n    }\n    \n    @AfterTemplate\n    AbstractIntegerAssert<?> after(AbstractIntegerAssert<?> intAssert) {\n        return intAssert.isEqualTo(0);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("#{intAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isZero()")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{intAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isEqualTo(0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractIntegerAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isZero(..)")
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJIntegerRules.AbstractIntegerAssertIsNotZero}.
     */
    @SuppressWarnings("all")
    @NonNullApi
    public static class AbstractIntegerAssertIsNotZeroRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractIntegerAssertIsNotZeroRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJIntegerRules.AbstractIntegerAssertIsNotZero`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractIntegerAssertIsNotZero {\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(AbstractIntegerAssert<?> intAssert) {\n        return intAssert.isNotZero();\n    }\n    \n    @AfterTemplate\n    AbstractIntegerAssert<?> after(AbstractIntegerAssert<?> intAssert) {\n        return intAssert.isNotEqualTo(0);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("#{intAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isNotZero()")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{intAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isNotEqualTo(0)")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractIntegerAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isNotZero(..)")
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJIntegerRules.AbstractIntegerAssertIsOne}.
     */
    @SuppressWarnings("all")
    @NonNullApi
    public static class AbstractIntegerAssertIsOneRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractIntegerAssertIsOneRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJIntegerRules.AbstractIntegerAssertIsOne`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractIntegerAssertIsOne {\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(AbstractIntegerAssert<?> intAssert) {\n        return intAssert.isOne();\n    }\n    \n    @AfterTemplate\n    AbstractIntegerAssert<?> after(AbstractIntegerAssert<?> intAssert) {\n        return intAssert.isEqualTo(1);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before = JavaTemplate
                        .builder("#{intAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isOne()")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("#{intAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isEqualTo(1)")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractIntegerAssert", true),
                        new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isOne(..)")
                    ),
                    javaVisitor
            );
        }
    }

}
