package tech.picnic.errorprone.refasterrules;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.AssertJPrimitiveRules}.
 */
@SuppressWarnings("all")
public class AssertJPrimitiveRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public AssertJPrimitiveRulesRecipes() {}

    @Override
    public String getDisplayName() {
        return "`AssertJPrimitiveRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJPrimitiveRules`. [Source](https://error-prone.picnic.tech/refasterrules/AssertJPrimitiveRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new AssertThatIsEqualToRecipe(),
                new AssertThatIsNotEqualToRecipe(),
                new AssertThatIsLessThanRecipe(),
                new AssertThatIsLessThanOrEqualToRecipe(),
                new AssertThatIsGreaterThanRecipe(),
                new AssertThatIsGreaterThanOrEqualToRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJPrimitiveRules.AssertThatIsEqualTo}.
     */
    @SuppressWarnings("all")
    @NonNullApi
    public static class AssertThatIsEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJPrimitiveRules.AssertThatIsEqualTo`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsEqualTo {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(boolean actual, boolean expected) {\n        return Refaster.anyOf(assertThat(actual == expected).isTrue(), assertThat(actual != expected).isFalse());\n    }\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S1244\")\n    AbstractBooleanAssert<?> before(double actual, double expected) {\n        return Refaster.anyOf(assertThat(actual == expected).isTrue(), assertThat(actual != expected).isFalse());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractBooleanAssert<?> after(boolean actual, boolean expected) {\n        return assertThat(actual).isEqualTo(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)} == #{expected:any(boolean)}).isTrue()")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)} != #{expected:any(boolean)}).isFalse()")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate before0$0 = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)} == #{expected:any(double)}).isTrue()")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate before0$1 = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)} != #{expected:any(double)}).isFalse()")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isEqualTo(#{expected:any(boolean)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before0$0.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before0$1.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                        new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)"),
                        Preconditions.or(
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)"),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)")
                        )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJPrimitiveRules.AssertThatIsNotEqualTo}.
     */
    @SuppressWarnings("all")
    @NonNullApi
    public static class AssertThatIsNotEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsNotEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJPrimitiveRules.AssertThatIsNotEqualTo`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsNotEqualTo {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(boolean actual, boolean expected) {\n        return Refaster.anyOf(assertThat(actual != expected).isTrue(), assertThat(actual == expected).isFalse());\n    }\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S1244\")\n    AbstractBooleanAssert<?> before(double actual, double expected) {\n        return Refaster.anyOf(assertThat(actual != expected).isTrue(), assertThat(actual == expected).isFalse());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractBooleanAssert<?> after(boolean actual, boolean expected) {\n        return assertThat(actual).isNotEqualTo(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)} != #{expected:any(boolean)}).isTrue()")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)} == #{expected:any(boolean)}).isFalse()")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate before0$0 = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)} != #{expected:any(double)}).isTrue()")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate before0$1 = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)} == #{expected:any(double)}).isFalse()")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(boolean)}).isNotEqualTo(#{expected:any(boolean)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before0$0.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before0$1.matcher(getCursor())).find()) {
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                        new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)"),
                        Preconditions.or(
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)"),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)")
                        )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJPrimitiveRules.AssertThatIsLessThan}.
     */
    @SuppressWarnings("all")
    @NonNullApi
    public static class AssertThatIsLessThanRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsLessThanRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJPrimitiveRules.AssertThatIsLessThan`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsLessThan {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(double actual, double expected) {\n        return Refaster.anyOf(assertThat(actual < expected).isTrue(), assertThat(actual >= expected).isFalse());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractDoubleAssert<?> after(double actual, double expected) {\n        return assertThat(actual).isLessThan(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)} < #{expected:any(double)}).isTrue()")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)} >= #{expected:any(double)}).isFalse()")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)}).isLessThan(#{expected:any(double)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                        new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)"),
                        Preconditions.or(
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)"),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)")
                        )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJPrimitiveRules.AssertThatIsLessThanOrEqualTo}.
     */
    @SuppressWarnings("all")
    @NonNullApi
    public static class AssertThatIsLessThanOrEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsLessThanOrEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJPrimitiveRules.AssertThatIsLessThanOrEqualTo`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsLessThanOrEqualTo {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(double actual, double expected) {\n        return Refaster.anyOf(assertThat(actual <= expected).isTrue(), assertThat(actual > expected).isFalse());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractDoubleAssert<?> after(double actual, double expected) {\n        return assertThat(actual).isLessThanOrEqualTo(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)} <= #{expected:any(double)}).isTrue()")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)} > #{expected:any(double)}).isFalse()")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)}).isLessThanOrEqualTo(#{expected:any(double)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                        new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)"),
                        Preconditions.or(
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)"),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)")
                        )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJPrimitiveRules.AssertThatIsGreaterThan}.
     */
    @SuppressWarnings("all")
    @NonNullApi
    public static class AssertThatIsGreaterThanRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsGreaterThanRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJPrimitiveRules.AssertThatIsGreaterThan`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsGreaterThan {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(double actual, double expected) {\n        return Refaster.anyOf(assertThat(actual > expected).isTrue(), assertThat(actual <= expected).isFalse());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractDoubleAssert<?> after(double actual, double expected) {\n        return assertThat(actual).isGreaterThan(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)} > #{expected:any(double)}).isTrue()")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)} <= #{expected:any(double)}).isFalse()")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)}).isGreaterThan(#{expected:any(double)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                        new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)"),
                        Preconditions.or(
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)"),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)")
                        )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJPrimitiveRules.AssertThatIsGreaterThanOrEqualTo}.
     */
    @SuppressWarnings("all")
    @NonNullApi
    public static class AssertThatIsGreaterThanOrEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsGreaterThanOrEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            return "Refaster template `AssertJPrimitiveRules.AssertThatIsGreaterThanOrEqualTo`";
        }

        @Override
        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsGreaterThanOrEqualTo {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(double actual, double expected) {\n        return Refaster.anyOf(assertThat(actual >= expected).isTrue(), assertThat(actual < expected).isFalse());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractDoubleAssert<?> after(double actual, double expected) {\n        return assertThat(actual).isGreaterThanOrEqualTo(expected);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                final JavaTemplate before$0 = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)} >= #{expected:any(double)}).isTrue()")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate before$1 = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)} < #{expected:any(double)}).isFalse()")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();
                final JavaTemplate after = JavaTemplate
                        .builder("org.assertj.core.api.Assertions.assertThat(#{actual:any(double)}).isGreaterThanOrEqualTo(#{expected:any(double)})")
                        .javaParser(JavaParser.fromJavaVersion().classpath("assertj-core"))
                        .build();

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                        new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                        new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)"),
                        Preconditions.or(
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)"),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)")
                        )
                    ),
                    javaVisitor
            );
        }
    }

}
