/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.guidelines.bugpatterns;

import com.google.errorprone.BugCheckerRefactoringTestHelper;
import com.google.errorprone.CompilationTestHelper;
import org.junit.jupiter.api.Test;
import tech.picnic.errorprone.guidelines.bugpatterns.RefasterAnyOfUsage;

final class RefasterAnyOfUsageTest {
    RefasterAnyOfUsageTest() {
    }

    @Test
    void identification() {
        CompilationTestHelper.newInstance(RefasterAnyOfUsage.class, this.getClass()).addSourceLines("A.java", new String[]{"import com.google.errorprone.refaster.Refaster;", "import com.google.errorprone.refaster.annotation.BeforeTemplate;", "", "class A {", "  @BeforeTemplate", "  String before(String str) {", "    // BUG: Diagnostic contains:", "    Refaster.anyOf();", "    // BUG: Diagnostic contains:", "    return Refaster.anyOf(str);", "  }", "", "  @BeforeTemplate", "  Object before2(String str, Object obj) {", "    return Refaster.anyOf(str, obj);", "  }", "}"}).doTest();
    }

    @Test
    void replacement() {
        BugCheckerRefactoringTestHelper.newInstance(RefasterAnyOfUsage.class, this.getClass()).addInputLines("A.java", new String[]{"import com.google.errorprone.refaster.Refaster;", "import com.google.errorprone.refaster.annotation.BeforeTemplate;", "", "class A {", "  @BeforeTemplate", "  String before(String str) {", "    Refaster.anyOf();", "    return Refaster.anyOf(str);", "  }", "}"}).addOutputLines("A.java", new String[]{"import com.google.errorprone.refaster.Refaster;", "import com.google.errorprone.refaster.annotation.BeforeTemplate;", "", "class A {", "  @BeforeTemplate", "  String before(String str) {", "    Refaster.anyOf();", "    return str;", "  }", "}"}).doTest(BugCheckerRefactoringTestHelper.TestMode.TEXT_MATCH);
    }
}

