/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.common.utils;

import java.lang.reflect.Method;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class AOPUtils {
    private static final Logger log = LoggerFactory.getLogger(AOPUtils.class);
    private static final ExpressionParser PARSER = new SpelExpressionParser();
    private static final ParameterNameDiscoverer DISCOVERER = new LocalVariableTableParameterNameDiscoverer();

    public static String parseRealClassName(JoinPoint joinPoint) {
        return joinPoint.getSignature().getDeclaringType().getSimpleName();
    }

    public static Method parseMethod(ProceedingJoinPoint joinPoint) {
        Signature pointSignature = joinPoint.getSignature();
        if (!(pointSignature instanceof MethodSignature)) {
            throw new IllegalArgumentException("this annotation should be used on a method!");
        }
        MethodSignature signature = (MethodSignature)pointSignature;
        Method method = signature.getMethod();
        if (method.getDeclaringClass().isInterface()) {
            try {
                method = joinPoint.getTarget().getClass().getDeclaredMethod(pointSignature.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException | SecurityException e) {
                ExceptionUtils.rethrow((Throwable)e);
            }
        }
        return method;
    }

    public static <T> T parseSpEl(Method method, Object[] arguments, String spEl, Class<T> clazz, T defaultResult) {
        String[] params = DISCOVERER.getParameterNames(method);
        assert (params != null);
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int len = 0; len < params.length; ++len) {
            context.setVariable(params[len], arguments[len]);
        }
        try {
            Expression expression = PARSER.parseExpression(spEl);
            return (T)expression.getValue((EvaluationContext)context, clazz);
        }
        catch (Exception e) {
            log.error("[AOPUtils] parse SpEL failed for method[{}], please concat @tjq to fix the bug!", (Object)method.getName(), (Object)e);
            return defaultResult;
        }
    }
}

