package tech.prodigio.core.libeventproducer.event;


import lombok.Builder;
import lombok.Getter;
import lombok.NonNull;
import lombok.experimental.SuperBuilder;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Optional;


@Getter
@SuperBuilder
public class  EventHandlerPlatform extends PubSubEvent {

    @Builder.Default
    private int maxAttempts = 3;
    @NonNull
    private  String event;

    private  Object metadata;

    private  int delayInSecond;

    private  int maxRetry;

    private LocalDateTime date;

    @Override
    public String getEventId() {
        return event;
    }

    @Override
    public Object getData() {
        return Map.of(
                "event", event,
                "currentGuid", getEventId(),
                "date", getDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss")),
                "delayInSecond", delayInSecond,
                "maxRetry", maxRetry,
                "metadata", metadata
        );

    }



    public LocalDateTime getDate() {
        return Optional.ofNullable(date)
                .orElse(LocalDateTime.now());
    }

    public void setDate(LocalDateTime datetime) {
        this.date = datetime;
    }
}

