package tech.prodigio.core.libeventproducer.factory;

import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.pubsub.v1.Publisher;
import com.google.pubsub.v1.TopicName;
import org.threeten.bp.Duration;
import tech.prodigio.core.libeventproducer.event.PubSubEvent;
import tech.prodigio.core.libeventproducer.exception.PublishEventException;

import java.io.IOException;

public class GenericPubSubEvent extends PubSubFactory {
    private final Integer maxAttempts;
    private final PubSubEvent event;

    public GenericPubSubEvent(PubSubEvent event, Integer maxAttempts) {
        this.event = event;
        this.maxAttempts = maxAttempts;
    }


    @Override
    public Publisher getPublisher() {
        try {
            return Publisher.newBuilder(TopicName.of(event.getProjectId(), event.getTopicId()))
                    .setRetrySettings(retrySettings())
                    .build();
        } catch (IOException e) {
            throw new PublishEventException(e);
        }
    }

    @Override
    public PubSubEvent event() {
        return event;
    }


    private RetrySettings retrySettings() {
        Duration initialRetryDelay = Duration.ofMillis(100);
        double retryDelayMultiplier = 2.0;
        Duration maxRetryDelay = Duration.ofSeconds(60);
        Duration initialRpcTimeout = Duration.ofSeconds(1);
        double rpcTimeoutMultiplier = 1.0;
        Duration maxRpcTimeout = Duration.ofSeconds(60);
        Duration totalTimeout = Duration.ofSeconds(60);

        return RetrySettings.newBuilder()
                .setInitialRetryDelay(initialRetryDelay)
                .setMaxAttempts(maxAttempts + 1)
                .setInitialRpcTimeout(initialRpcTimeout)
                .setMaxRpcTimeout(maxRpcTimeout)
                .setRpcTimeoutMultiplier(rpcTimeoutMultiplier)
                .setRetryDelayMultiplier(retryDelayMultiplier)
                .setMaxRetryDelay(maxRetryDelay)
                .setTotalTimeout(totalTimeout)
                .build();
    }
}
