package tech.prodigio.core.libeventproducer.handler;

import lombok.Builder;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;


@Builder
public class DefaultPublisherEventHandler<P, R> implements PublisherEventHandlerTemplate<P, R> {
    private Consumer<R> onSuccess;
    private Consumer<Exception> onError;
    private Consumer<P> whenFinallyThen;
    private Function<P, R> publishFunction;
    private P publisher;

    public DefaultPublisherEventHandler<P, R> publisher(P publisher) {
        this.publisher = publisher;
        return this;
    }

    public DefaultPublisherEventHandler<P, R> handleOnSuccess(Consumer<R> onSuccess) {
        this.onSuccess = onSuccess;
        return this;
    }

    public DefaultPublisherEventHandler<P, R> handlerOnError(Consumer<Exception> errorHandler) {
        this.onError = errorHandler;
        return this;
    }

    public DefaultPublisherEventHandler<P, R> handleOnFinal(Consumer<P> onFinal) {
        this.whenFinallyThen = onFinal;
        return this;
    }


    public void publishEvent() {
        try {
            R publishResult = publishFunction.apply(publisher);
            Optional.ofNullable(onSuccess)
                    .ifPresent(success -> success.accept(publishResult));
        } catch (Exception e) {
            Optional.ofNullable(onError)
                    .ifPresent(error -> error.accept(e));
        } finally {
            Optional.ofNullable(publisher)
                    .ifPresent(this::executeFinalOperation);

        }
    }

    private void executeFinalOperation(P publisher) {
        Optional.ofNullable(whenFinallyThen)
                .ifPresent(finallyThen -> finallyThen.accept(publisher));
    }

}
