package tech.prodigio.core.libeventproducer.handler;

import java.util.function.Consumer;

public interface PublisherEventHandlerTemplate<P, R>  extends PublisherEventHandler {

    default PublisherEventHandler onSuccess(Consumer<?> onSuccess) {
        return handleOnSuccess(adaptConsumerR(onSuccess));
    }

    default PublisherEventHandler onError(Consumer<Exception> errorHandler) {
        return handlerOnError(errorHandler);
    }
    default PublisherEventHandler onFinal(Consumer<?> onFinal) {
        return handleOnFinal(adaptConsumerP(onFinal));
    }

    @SuppressWarnings("unchecked")
    default  Consumer<R> adaptConsumerR(Consumer<?> consumer) {
        return (Consumer<R>) consumer;
    }

    @SuppressWarnings("unchecked")
    default  Consumer<P> adaptConsumerP(Consumer<?> consumer) {
        return (Consumer<P>) consumer;
    }
    DefaultPublisherEventHandler<P, R> publisher(P publisher);
    DefaultPublisherEventHandler<P, R> handleOnSuccess(Consumer<R> onSuccess);
    DefaultPublisherEventHandler<P, R> handlerOnError(Consumer<Exception> errorHandler);
    DefaultPublisherEventHandler<P, R> handleOnFinal(Consumer<P> onFinal);
}
