package tech.prodigio.core.libeventproducer.publisher;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import tech.prodigio.core.libeventproducer.enums.EventSourceType;
import tech.prodigio.core.libeventproducer.event.Event;
import tech.prodigio.core.libeventproducer.event.EventHandlerPlatform;
import tech.prodigio.core.libeventproducer.event.PubSubEvent;
import tech.prodigio.core.libeventproducer.exception.NoSupportedEventException;
import tech.prodigio.core.libeventproducer.factory.EventHandlerPlatformFactory;
import tech.prodigio.core.libeventproducer.factory.GenericPubSubEvent;
import tech.prodigio.core.libeventproducer.factory.PublisherEventHandlerFactory;
import tech.prodigio.core.libeventproducer.handler.PublisherEventHandler;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;


@Component
public class PubSubPublisher implements tech.prodigio.core.libeventproducer.core.Publisher {

    @Value("${lib.core.event.producer.max.attempts:3}")
    private Integer maxAttempts;


    private final Map<Class<? extends Event>, Function<Event, PublisherEventHandlerFactory>> factoryOptions = Map.of(
            PubSubEvent.class, event -> new GenericPubSubEvent((PubSubEvent) event, maxAttempts),
            EventHandlerPlatform.class, event -> new EventHandlerPlatformFactory((EventHandlerPlatform) event)
    );

    @Override
    public EventSourceType getEventSourceType() {
        return EventSourceType.GCP_PUBLISHER;
    }

    @Override
    public PublisherEventHandler buildHandler(Event event) {
        return factory(event).buildHandler();
    }




    private PublisherEventHandlerFactory factory(Event event) {
        return factoryOptions.entrySet().stream()
                .filter(entry -> Objects.equals(event.getClass().getName(), entry.getKey().getName()))
                .findFirst()
                .map(entry -> entry.getValue().apply(event))
                .orElseThrow(()-> new NoSupportedEventException(factoryOptions.keySet().stream().toList()));

    }


}

