/*
 * Decompiled with CFR 0.152.
 */
package tech.raaf.logelastic.log4j.appender;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import tech.raaf.logelastic.log4j.appender.HttpManager;
import tech.raaf.logelastic.log4j.config.Header;

@Plugin(name="Elastic", category="Core", elementType="appender", printObject=true)
public final class ElasticAppender
extends AbstractAppender {
    private final HttpManager manager;

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    private ElasticAppender(String name, Layout<? extends Serializable> layout, Filter filter, boolean ignoreExceptions, HttpManager manager) {
        super(name, filter, layout, ignoreExceptions);
        Objects.requireNonNull(layout, "layout");
        this.manager = Objects.requireNonNull(manager, "manager");
    }

    public void start() {
        super.start();
    }

    public void append(LogEvent event) {
        try {
            this.manager.send(this.getLayout(), event);
        }
        catch (Exception e) {
            this.error("Unable to send HTTP in appender [" + this.getName() + "]", event, e);
        }
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        boolean stopped = super.stop(timeout, timeUnit, false);
        this.setStopped();
        return stopped &= this.manager.stop(timeout, timeUnit);
    }

    public String toString() {
        return "ElasticAppender{name=" + this.getName() + ", state=" + this.getState() + '}';
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<ElasticAppender> {
        private HttpManager httpManager = null;
        @PluginBuilderAttribute
        @Required(message="No URL provided for ElasticAppender")
        private String url;
        @PluginBuilderAttribute
        private int connectTimeoutMillis = 1000;
        @PluginBuilderAttribute
        private int readTimeoutMillis = 0;
        @PluginElement(value="Headers")
        private Header[] headers;
        @PluginElement(value="Properties")
        private Property[] properties;
        @PluginElement(value="SslConfiguration")
        private SslConfiguration sslConfiguration;
        @PluginBuilderAttribute
        private boolean verifyHostname = true;

        public ElasticAppender build() {
            this.url = new StrSubstitutor(System.getProperties()).replace(this.url).toLowerCase();
            try {
                this.httpManager = new HttpManager(this.getConfiguration(), this.getName(), new URL(this.url), new URL(this.url + "/_doc"), this.connectTimeoutMillis, this.readTimeoutMillis, this.headers, this.properties, this.sslConfiguration, this.verifyHostname);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            return new ElasticAppender(this.getName(), this.getLayout(), this.getFilter(), this.isIgnoreExceptions(), this.httpManager);
        }

        public String getUrl() {
            return this.url;
        }

        public int getConnectTimeoutMillis() {
            return this.connectTimeoutMillis;
        }

        public int getReadTimeoutMillis() {
            return this.readTimeoutMillis;
        }

        public Header[] getHeaders() {
            return this.headers;
        }

        public Property[] getProperties() {
            return this.properties;
        }

        public SslConfiguration getSslConfiguration() {
            return this.sslConfiguration;
        }

        public boolean isVerifyHostname() {
            return this.verifyHostname;
        }

        public B setUrl(String url) {
            this.url = url;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setConnectTimeoutMillis(int connectTimeoutMillis) {
            this.connectTimeoutMillis = connectTimeoutMillis;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setReadTimeoutMillis(int readTimeoutMillis) {
            this.readTimeoutMillis = readTimeoutMillis;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setHeaders(Header[] headers) {
            this.headers = headers;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setProperties(Property[] properties) {
            this.properties = properties;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setSslConfiguration(SslConfiguration sslConfiguration) {
            this.sslConfiguration = sslConfiguration;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setVerifyHostname(boolean verifyHostname) {
            this.verifyHostname = verifyHostname;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }
}

