/*
 * Decompiled with CFR 0.152.
 */
package tech.raaf.logelastic.log4j.appender;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.ws.http.HTTPException;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import tech.raaf.logelastic.log4j.appender.LaxHostnameVerifier;
import tech.raaf.logelastic.log4j.config.Header;

public class HttpManager
extends AbstractManager {
    private static int counter = 0;
    private static Date when = new Date();
    private static final Charset CHARSET = Charset.forName("US-ASCII");
    private static final int[] SECONDS = new int[]{0, 1, 10, 30, 60, 120, 180, 240, 300, 600, 900, 1200};
    private final Configuration configuration;
    private final URL indexUrl;
    private final URL postUrl;
    private final int connectTimeoutMillis;
    private final int readTimeoutMillis;
    private final Header[] headers;
    private final Property[] properties;
    private final SslConfiguration sslConfiguration;
    private final boolean verifyHostname;

    public HttpManager(Configuration configuration, String name, URL indexUrl, URL postUrl, int connectTimeoutMillis, int readTimeoutMillis, Header[] headers, Property[] properties, SslConfiguration sslConfiguration, boolean verifyHostname) throws MalformedURLException {
        super(configuration.getLoggerContext(), name);
        this.configuration = Objects.requireNonNull(configuration);
        this.indexUrl = indexUrl;
        this.postUrl = postUrl;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
        this.headers = headers != null ? headers : new Header[]{};
        this.properties = properties != null ? properties : new Property[]{};
        this.sslConfiguration = sslConfiguration;
        this.verifyHostname = verifyHostname;
    }

    private Configuration getConfiguration() {
        return this.configuration;
    }

    void send(Layout<?> layout, LogEvent event) throws IOException {
        HashSet<Header> clientHeaders = new HashSet<Header>();
        if (layout.getContentType() != null) {
            clientHeaders.add(Header.createHeader("Content-Type", layout.getContentType()));
        }
        for (Header header : this.headers) {
            clientHeaders.add(Header.createHeader(header.getName(), header.isValueNeedsLookup() ? this.getConfiguration().getStrSubstitutor().replace(event, header.getValue()) : header.getValue()));
        }
        Date now = new Date();
        if (when.equals(now) || when.before(now)) {
            try {
                if (counter != 0) {
                    this.fakeLogMessage("WARN", ((Object)((Object)this)).getClass().getSimpleName(), "Ah, it's around " + new SimpleDateFormat("HH:mm:ss").format(when) + ", attempting to resume logging..  ");
                }
                this.conditionalConnect("POST", this.postUrl, clientHeaders, layout.toByteArray(event));
                counter = 0;
                when.setTime(now.getTime());
            }
            catch (ConnectException | SocketTimeoutException | UnknownHostException e) {
                counter = counter <= SECONDS.length ? ++counter : 0;
                when.setTime(now.getTime() + (long)(SECONDS[counter] * 1000));
                this.fakeLogMessage("WARN", e.getClass().getSimpleName(), "Skipping log shipping to Elasticsearch for  " + SECONDS[counter] + " seconds.. Resuming somewhere around " + new SimpleDateFormat("HH:mm:ss").format(when));
            }
            catch (HTTPException e) {
                if (e.getStatusCode() == 404) {
                    this.fakeLogMessage("WARN", ((Object)((Object)e)).getClass().getSimpleName(), "Index does not exist, (re)creating..");
                    byte[] body = this.toByteArray(((Object)((Object)this)).getClass().getResourceAsStream("/index_mapping.json"));
                    this.conditionalConnect("PUT", this.indexUrl, clientHeaders, body);
                    this.conditionalConnect("POST", this.postUrl, clientHeaders, layout.toByteArray(event));
                }
                this.fakeLogMessage("WARN", ((Object)((Object)e)).getClass().getSimpleName(), "Got an HTTP status code that I don't handle: " + e.getStatusCode());
            }
        }
    }

    private void conditionalConnect(String method, URL url, Set<Header> headers, byte[] body) throws IOException {
        HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
        httpConnection.setAllowUserInteraction(false);
        httpConnection.setDoOutput(true);
        httpConnection.setDoInput(true);
        httpConnection.setRequestMethod(method);
        if (this.connectTimeoutMillis > 0) {
            httpConnection.setConnectTimeout(this.connectTimeoutMillis);
        }
        if (this.readTimeoutMillis > 0) {
            httpConnection.setReadTimeout(this.readTimeoutMillis);
        }
        for (Header header : headers) {
            httpConnection.setRequestProperty(header.getName(), header.getValue());
        }
        if (!url.getProtocol().equalsIgnoreCase("http") && !url.getProtocol().equalsIgnoreCase("https")) {
            throw new ConfigurationException("URL must have scheme http or https");
        }
        boolean isHttps = url.getProtocol().equalsIgnoreCase("https");
        if (this.sslConfiguration != null && !isHttps) {
            throw new ConfigurationException("SSL configuration can only be specified with URL scheme https");
        }
        if (isHttps && !this.verifyHostname) {
            ((HttpsURLConnection)httpConnection).setHostnameVerifier(LaxHostnameVerifier.INSTANCE);
        }
        if (this.sslConfiguration != null) {
            ((HttpsURLConnection)httpConnection).setSSLSocketFactory(this.sslConfiguration.getSslSocketFactory());
        }
        httpConnection.setFixedLengthStreamingMode(body.length);
        httpConnection.connect();
        try (OutputStream os = httpConnection.getOutputStream();){
            os.write(body);
        }
        byte[] buffer = new byte[1024];
        try (InputStream is = httpConnection.getInputStream();){
            while (-1 != is.read(buffer)) {
            }
        }
        catch (IOException e) {
            StringBuilder errorMessage = new StringBuilder();
            try (InputStream es = httpConnection.getErrorStream();){
                errorMessage.append(httpConnection.getResponseCode());
                if (httpConnection.getResponseMessage() != null) {
                    errorMessage.append(' ').append(httpConnection.getResponseMessage());
                }
                if (es != null) {
                    int n;
                    errorMessage.append(" - ");
                    while (-1 != (n = es.read(buffer))) {
                        errorMessage.append(new String(buffer, 0, n, CHARSET));
                    }
                }
            }
            switch (httpConnection.getResponseCode()) {
                case 404: {
                    throw new HTTPException(404);
                }
            }
            if (httpConnection.getResponseCode() > -1) {
                throw new IOException(errorMessage.toString());
            }
            throw e;
        }
    }

    private void fakeLogMessage(String level, String logger, String message) {
        String hostname = "unknown";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        System.err.println("[" + level.toUpperCase() + "] [" + this.getCurrentDateTime() + "] [" + hostname + "] " + logger + ": " + message);
    }

    private String getCurrentDateTime() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSS"));
    }

    private byte[] toByteArray(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }
}

