/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.veraid;

import java.security.PrivateKey;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.veraid.Member;
import tech.relaycorp.veraid.Periods;
import tech.relaycorp.veraid.SignatureBundle;
import tech.relaycorp.veraid.SignatureException;
import tech.relaycorp.veraid.SignatureMetadata;
import tech.relaycorp.veraid.VeraidOids;
import tech.relaycorp.veraid.dns.DnssecChain;
import tech.relaycorp.veraid.dns.InvalidChainException;
import tech.relaycorp.veraid.pki.MemberCertificate;
import tech.relaycorp.veraid.pki.MemberIdBundle;
import tech.relaycorp.veraid.pki.OrgCertificate;
import tech.relaycorp.veraid.pki.PkiException;
import tech.relaycorp.veraid.utils.asn1.ASN1Exception;
import tech.relaycorp.veraid.utils.asn1.ASN1Utils;
import tech.relaycorp.veraid.utils.cms.SignedData;
import tech.relaycorp.veraid.utils.cms.SignedDataException;
import tech.relaycorp.veraid.utils.x509.Certificate;
import tech.relaycorp.veraid.utils.x509.CertificateException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\r\u001a\u00020\u000eJ)\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J9\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0016\b\u0002\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0018j\u0004\u0018\u0001`\u0019H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2={"Ltech/relaycorp/veraid/SignatureBundle;", "", "memberIdBundle", "Ltech/relaycorp/veraid/pki/MemberIdBundle;", "signedData", "Ltech/relaycorp/veraid/utils/cms/SignedData;", "(Ltech/relaycorp/veraid/pki/MemberIdBundle;Ltech/relaycorp/veraid/utils/cms/SignedData;)V", "getMemberIdBundle$veraid", "()Ltech/relaycorp/veraid/pki/MemberIdBundle;", "getSignedData$veraid", "()Ltech/relaycorp/veraid/utils/cms/SignedData;", "getSignatureMetadata", "Ltech/relaycorp/veraid/SignatureMetadata;", "serialise", "", "verify", "Ltech/relaycorp/veraid/Member;", "plaintext", "serviceOid", "", "date", "Ljava/time/ZonedDateTime;", "([BLjava/lang/String;Ljava/time/ZonedDateTime;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "datePeriod", "Lkotlin/ranges/ClosedRange;", "Ltech/relaycorp/veraid/DatePeriod;", "([BLjava/lang/String;Lkotlin/ranges/ClosedRange;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "veraid"})
public final class SignatureBundle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MemberIdBundle memberIdBundle;
    @NotNull
    private final SignedData signedData;

    public SignatureBundle(@NotNull MemberIdBundle memberIdBundle, @NotNull SignedData signedData) {
        Intrinsics.checkNotNullParameter((Object)memberIdBundle, (String)"memberIdBundle");
        Intrinsics.checkNotNullParameter((Object)signedData, (String)"signedData");
        this.memberIdBundle = memberIdBundle;
        this.signedData = signedData;
    }

    @NotNull
    public final MemberIdBundle getMemberIdBundle$veraid() {
        return this.memberIdBundle;
    }

    @NotNull
    public final SignedData getSignedData$veraid() {
        return this.signedData;
    }

    @NotNull
    public final byte[] serialise() {
        Object[] objectArray = new ASN1Object[]{new ASN1Integer(0L), this.memberIdBundle.getDnssecChain$veraid().encode$veraid(), this.memberIdBundle.getOrgCertificate$veraid().encode$veraid(), this.signedData.encode()};
        return ASN1Utils.INSTANCE.serializeSequence(CollectionsKt.listOf((Object[])objectArray), false);
    }

    @Nullable
    public final Object verify(@NotNull byte[] plaintext2, @NotNull String serviceOid, @NotNull ZonedDateTime date, @NotNull Continuation<? super Member> $completion) {
        return this.verify(plaintext2, serviceOid, (ClosedRange<ZonedDateTime>)RangesKt.rangeTo((Comparable)date, (Comparable)date), $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object verify(@NotNull byte[] var1_1, @NotNull String var2_2, @Nullable ClosedRange<ZonedDateTime> var3_3, @NotNull Continuation<? super Member> var4_4) {
        if (!(var4_4 instanceof verify.2)) ** GOTO lbl-1000
        var12_5 = var4_4;
        if ((var12_5.label & -2147483648) != 0) {
            var12_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                /* synthetic */ Object result;
                final /* synthetic */ SignatureBundle this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.verify((byte[])null, (String)null, (ClosedRange<ZonedDateTime>)null, (Continuation<? super Member>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var13_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                now = ZonedDateTime.now();
                v0 = datePeriod;
                if (v0 == null) {
                    v0 = RangesKt.rangeTo((Comparable)now, (Comparable)now);
                }
                if (((ZonedDateTime)(verificationPeriod = v0).getEndInclusive()).compareTo((ChronoZonedDateTime)verificationPeriod.getStart()) < 0) {
                    throw new SignatureException("Verification expiry date cannot be before start date", null, 2, null);
                }
                try {
                    this.signedData.verify((byte[])plaintext);
                }
                catch (SignedDataException exc) {
                    throw new SignatureException("Signature is invalid", exc);
                }
                metadata = this.getSignatureMetadata();
                v1 = Periods.intersect(metadata.getValidityPeriod(), (ClosedRange<ZonedDateTime>)verificationPeriod);
                if (v1 == null) {
                    throw new SignatureException("Signature period does not overlap with required period", null, 2, null);
                }
                signaturePeriodIntersection = v1;
                if (!Intrinsics.areEqual((Object)metadata.getService().getId(), (Object)serviceOid)) {
                    throw new SignatureException("Signature is bound to a different service (" + metadata.getService().getId() + ")", null, 2, null);
                }
                $continuation.label = 1;
                v2 = this.memberIdBundle.verify$veraid(new ASN1ObjectIdentifier((String)serviceOid), signaturePeriodIntersection, (Continuation<? super Member>)$continuation);
                ** if (v2 != var13_7) goto lbl37
lbl36:
                // 1 sources

                return var13_7;
lbl37:
                // 1 sources

                ** GOTO lbl43
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl43:
                    // 2 sources

                    var9_13 = (Member)v2;
                }
                catch (PkiException exc) {
                    throw new SignatureException("Member id bundle is invalid", exc);
                }
                return var9_13;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object verify$default(SignatureBundle signatureBundle, byte[] byArray, String string, ClosedRange closedRange, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            closedRange = null;
        }
        return signatureBundle.verify(byArray, string, (ClosedRange<ZonedDateTime>)closedRange, (Continuation<? super Member>)continuation);
    }

    private final SignatureMetadata getSignatureMetadata() {
        SignatureMetadata signatureMetadata;
        Attribute attribute;
        AttributeTable signedAttrs;
        AttributeTable attributeTable = signedAttrs = this.signedData.getSignedAttrs();
        Attribute attribute2 = attribute = attributeTable != null ? attributeTable.get(VeraidOids.INSTANCE.getSIGNATURE_METADATA_ATTR()) : null;
        if (attribute == null) {
            throw new SignatureException("SignedData should have VeraId metadata attribute", null, 2, null);
        }
        Attribute metadataAttribute = attribute;
        if (metadataAttribute.getAttrValues().size() == 0) {
            throw new SignatureException("Metadata attribute should have at least one value", null, 2, null);
        }
        ASN1Encodable metadataAttributeValue = metadataAttribute.getAttrValues().getObjectAt(0);
        try {
            Intrinsics.checkNotNull((Object)metadataAttributeValue);
            signatureMetadata = SignatureMetadata.Companion.decode(metadataAttributeValue);
        }
        catch (SignatureException exc) {
            throw new SignatureException("Metadata attribute is malformed", exc);
        }
        return signatureMetadata;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J8\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u00a8\u0006\u0012"}, d2={"Ltech/relaycorp/veraid/SignatureBundle$Companion;", "", "()V", "deserialise", "Ltech/relaycorp/veraid/SignatureBundle;", "serialisation", "", "generate", "plaintext", "serviceOid", "", "memberIdBundle", "Ltech/relaycorp/veraid/pki/MemberIdBundle;", "signingKey", "Ljava/security/PrivateKey;", "expiryDate", "Ljava/time/ZonedDateTime;", "startDate", "veraid"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SignatureBundle generate(@NotNull byte[] plaintext2, @NotNull String serviceOid, @NotNull MemberIdBundle memberIdBundle, @NotNull PrivateKey signingKey, @NotNull ZonedDateTime expiryDate, @NotNull ZonedDateTime startDate) throws SignatureException {
            Intrinsics.checkNotNullParameter((Object)plaintext2, (String)"plaintext");
            Intrinsics.checkNotNullParameter((Object)serviceOid, (String)"serviceOid");
            Intrinsics.checkNotNullParameter((Object)memberIdBundle, (String)"memberIdBundle");
            Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
            Intrinsics.checkNotNullParameter((Object)expiryDate, (String)"expiryDate");
            Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
            SignatureMetadata metadata = new SignatureMetadata(new ASN1ObjectIdentifier(serviceOid), (ClosedRange<ZonedDateTime>)RangesKt.rangeTo((Comparable)startDate, (Comparable)expiryDate));
            Attribute metadataAttribute = new Attribute(VeraidOids.INSTANCE.getSIGNATURE_METADATA_ATTR(), (ASN1Set)new DERSet((ASN1Encodable)metadata.encode()));
            Object[] objectArray = new Certificate[]{memberIdBundle.getMemberCertificate$veraid(), memberIdBundle.getOrgCertificate$veraid()};
            SignedData signedData = SignedData.Companion.sign$default(SignedData.Companion, plaintext2, signingKey, memberIdBundle.getMemberCertificate$veraid(), SetsKt.setOf((Object[])objectArray), null, false, CollectionsKt.listOf((Object)metadataAttribute), 16, null);
            return new SignatureBundle(memberIdBundle, signedData);
        }

        public static /* synthetic */ SignatureBundle generate$default(Companion companion, byte[] byArray, String string, MemberIdBundle memberIdBundle, PrivateKey privateKey, ZonedDateTime zonedDateTime, ZonedDateTime zonedDateTime2, int n, Object object) throws SignatureException {
            if ((n & 0x20) != 0) {
                ZonedDateTime zonedDateTime3 = ZonedDateTime.now();
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime3, (String)"now(...)");
                zonedDateTime2 = zonedDateTime3;
            }
            return companion.generate(byArray, string, memberIdBundle, privateKey, zonedDateTime, zonedDateTime2);
        }

        @NotNull
        public final SignatureBundle deserialise(@NotNull byte[] serialisation) throws SignatureException {
            SignedData exc4;
            DnssecChain exc22;
            OrgCertificate exc32;
            ASN1TaggedObject[] aSN1TaggedObjectArray;
            Intrinsics.checkNotNullParameter((Object)serialisation, (String)"serialisation");
            try {
                aSN1TaggedObjectArray = ASN1Utils.INSTANCE.deserializeHeterogeneousSequence(serialisation);
            }
            catch (ASN1Exception exc32) {
                throw new SignatureException("Signature bundle should be a SEQUENCE", exc32);
            }
            ASN1TaggedObject[] sequence = aSN1TaggedObjectArray;
            if (sequence.length < 4) {
                throw new SignatureException("Signature bundle should have at least 4 items", null, 2, null);
            }
            try {
                exc32 = OrgCertificate.Companion.decode$veraid(sequence[2]);
            }
            catch (CertificateException exc22) {
                throw new SignatureException("Organisation certificate is malformed", exc22);
            }
            OrgCertificate orgCertificate = exc32;
            try {
                exc22 = DnssecChain.Companion.decode$veraid(orgCertificate.getCommonName$veraid(), sequence[1]);
            }
            catch (InvalidChainException exc4) {
                throw new SignatureException("VeraId DNSSEC chain is malformed", exc4);
            }
            DnssecChain dnssecChain = exc22;
            try {
                exc4 = SignedData.Companion.decode(sequence[3]);
            }
            catch (SignedDataException exc5) {
                throw new SignatureException("SignedData is malformed", exc5);
            }
            SignedData signedData = exc4;
            Certificate certificate = signedData.getSignerCertificate();
            if (certificate == null) {
                throw new SignatureException("SignedData should have signer certificate attached", null, 2, null);
            }
            Certificate signerCertificate2 = certificate;
            MemberIdBundle memberIdBundle = new MemberIdBundle(dnssecChain, orgCertificate, new MemberCertificate(signerCertificate2.getCertificateHolder$veraid()));
            return new SignatureBundle(memberIdBundle, signedData);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

